<?php

###############################################################################
# japanese_utf-8.php
# This is the english language page for Geeklog!
# Special thanks to Mischa Polivanov for his work on this project
#
# Copyright (C) 2000 Jason Whittenburg
# jwhitten AT securitygeeks DOT com
# Copyright (C) 2002,2003,2004,2005 SAKATA Yusuke
#               2006,2007 Geeklog IvySOHO Project Ivy(KOMMA Tetsuko), SAKATA Yusuke
# sakata@ecofirm.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
################################################################################
# これは，Geeklogコア用日本語言語ファイルです。
# language/japanese_utf-8.php
# http://www.geeklog.jp/
# Last Update 2007/10/25

$LANG_CHARSET = 'utf-8';

###############################################################################
# Array Format:
# $LANGXX[YY]:  $LANG - variable name
#               XX    - file id number
#               YY    - phrase id number
###############################################################################

# @@@@@ Geeklog Japanese 日本語対応版用　一部追加----->ここから

$LANG_JPN = array(
    1 => ' さん',
);

# @@@@@ Geeklog Japanese 日本語対応版用　一部追加<-----ここまで

###############################################################################
# USER PHRASES - These are file phrases used in end user scripts
###############################################################################

###############################################################################
# lib-common.php

$LANG01 = array(
    1 => '投稿者:',
    2 => '続きを読む',

    // Changed by Phize <----
    3 => 'コメント',
    // Changed by Phize ---->

    4 => '編集',
    5 => '投票',
    6 => '結果',
    7 => '',
    8 => '投票数',
    9 => '管理機能:',
    10 => '投稿管理',
    11 => '記事',
    12 => 'ブロック',
    13 => '話題',
    14 => '',
    15 => '',
    16 => '',
    17 => 'ユーザ',
    18 => 'SQL Query',
    19 => 'ログアウト',
    20 => 'ユーザ情報:',
    21 => 'ユーザ名',
    22 => 'ユーザID',
    23 => '管理レベル',
    24 => 'ゲストユーザ',
    25 => 'コメントを追加',
    26 => 'コメントは投稿者の責任においてなされるものであり，サイト管理者は責任を負いません。',
    27 => '最新の投稿',
    28 => '削除',
    29 => '-',
    30 => '過去の記事',
    31 => '使用できるHTMLタグ:',
    32 => 'エラー。ユーザ名が入力されていません。',
    33 => 'エラー。ログファイルに書き込めません。',
    34 => 'エラー',
    35 => 'ログアウト',
    36 => 'on',
    37 => '-',
    38 => 'RSS配信',
    39 => '更新',
    40 => ' あなたの <tt>php.ini</tt> で，<tt>register_globals = Off</tt> になっているようです。Geeklogは， <tt>register_globals</tt> が <strong>on</strong> になっていなければなりません。 Geeklogを使うために， <strong>on</strong> にして，Webサーバーを再起動してください。',
    41 => 'ゲストユーザ',
    42 => '投稿者:',
    43 => 'コメントを追加',
    44 => '元の記事',
    45 => 'MySQLのエラー番号は，',
    46 => 'MySQLのエラーメッセージは，',
    47 => 'ログイン',
    48 => 'マイアカウント',
    49 => '設定',
    50 => 'SQL文にエラーがあります。',
    51 => 'ヘルプ',
    52 => '新規',
    53 => '管理画面',
    54 => 'ファイルが開けません',
    55 => '次の場所でエラーがありました。->',
    56 => '投票',
    57 => 'パスワード',
    58 => 'ログイン',
    59 => "<a href=\"{$_CONF['site_url']}/users.php?mode=new\">新規登録</a>",
    60 => 'コメント投稿',
    61 => 'アカウント登録',
    62 => 'ワード',
    63 => 'コメントの設定',
    64 => '記事を友人にメールする',
    65 => '印刷用画面',
    66 => '',
    67 => 'ようこそ！ ',
    68 => 'ホーム',
    69 => '連絡先',
    70 => '検索',
    71 => '記事投稿',
    72 => 'リンク',
    73 => '',
    74 => '',
    75 => '検索',
    76 => 'サイト情報',
    77 => 'プラグイン',
    78 => '',
    79 => '新着情報',
    80 => '件の記事（',
    81 => '件の記事（',
    82 => '時間以内）',
    83 => 'コメント',
    84 => '',
    85 => '（48 時間以内）',
    86 => '  -',
    87 => '（最近2週間）',
    88 => '',
    89 => '',
    90 => 'ホーム',
    91 => 'ページ作成時間',
    92 => '秒',
    93 => 'Copyright',
    94 => '本ページのすべての商標と著作権はそれぞれの所有者に帰属します。',
    95 => 'Powered By',
    96 => 'グループ',
    97 => 'ワードリスト',
    98 => 'プラグイン',
    99 => '記事',
    100 => '-',
    101 => '',
    102 => '',
    103 => 'データベース',
    104 => '：',
    105 => 'グループメール',
    106 => '閲覧件数',
    107 => 'GLバージョンテスト',
    108 => 'キャッシュをクリア',
    109 => '迷惑報告',
    110 => '投稿をサイト管理者に通知する',
    111 => 'PDFで閲覧',
    112 => '登録ユーザ数',
    113 => 'ドキュメント',
    114 => 'トラックバック',
    115 => '-',
    116 => 'トラックバック',
    117 => '記事一覧',
    118 => '続きのページへ：',
    119 => "<a href=\"{$_CONF['site_url']}/users.php?mode=getpassword\">パスワードを忘れたら</a>",
    120 => 'このコメントへの永久リンク',
    121 => 'コメント (%d件)',
    122 => 'トラックバック (%d件)',
    123 => '',
    124 => 'チェックされたすべてのユーザを削除するのはここをクリック',
    125 => 'すべてのチェックされたユーザを削除してよいですか？',
    126 => 'すべて選択または選択を解除'
);

###############################################################################
# comment.php

$LANG03 = array(
    1 => 'コメントの投稿',
    2 => '投稿方法',
    3 => 'ログアウト',
    4 => 'アカウントを作る',
    5 => 'ユーザ名',
    6 => 'コメントの投稿の前にログインしてください。アカウントを登録していなければ，下のフォームで登録してください。',
    7 => 'あなたは',
    8 => " 秒前にコメントしています。投稿と投稿の間は {$_CONF['commentspeedlimit']} 秒以上あけてください",
    9 => 'コメント',
    10 => 'レポートを送る',
    11 => 'コメントの投稿',
    12 => '投稿するためには，タイトルと本文が必要です。',
    13 => 'あなたの情報',
    14 => 'プレビュー',
    15 => 'この投稿のレポート',
    16 => 'タイトル',
    17 => 'エラーです',
    18 => '注意事項',
    19 => '内容にそった話題で投稿してください',
    20 => 'できるだけ新しいスレッドを立てず，コメントを追加してください',
    21 => '他の人のコメントをよく読んで同じようなコメントを投稿しないようにしてください',
    22 => '内容がよくわかるタイトルをつけてください',
    23 => 'あなたのメールアドレスは表示されません！（保護されています）',
    24 => 'ゲストユーザ',
    25 => '投稿をサイト管理者に通知してよいですか？',
    26 => '%s さんが以下の投稿を迷惑だと指摘しています。',
    27 => '迷惑通知'
);

###############################################################################
# usersettings.php

$LANG04 = array(
    1 => 'アカウント情報',
    2 => 'ユーザ名',
    3 => '氏名',
    4 => 'パスワード',
    5 => 'メールアドレス',
    6 => 'ホームページ',
    7 => '自己紹介',
    8 => 'PGP鍵',
    9 => '保存する',
    10 => '最新コメント（10件）',
    11 => '-',
    12 => 'ユーザ情報',
    13 => 'メールでダイジェストを読む',
    14 => "なお，パスワードの変更をおすすめします。\nサイトにログインし，「マイアカウント」をクリックすると，パスワードを変更できます。",
    15 => "{$_CONF['site_name']} でのあなたのアカウントが作成されました。\n下記のユーザ名とパスワードでログインしてください。\nこのメールは念のため保存してください。",
    16 => 'ユーザ情報',
    17 => 'アカウントがありません',
    18 => 'このメールアドレスは，有効なアドレスではないようです',
    19 => 'ユーザ名かメールアドレスがすでに使われています。',
    20 => 'このメールアドレスは，有効なアドレスではないようです',
    21 => 'エラー',
    22 => "新規登録",
    23 => "{$_CONF['site_name']}にユーザアカウントを登録すると，コメントや記事の投稿をあなたの名前で投稿できます。そうでなければゲストユーザとしてしか投稿できません。なお，サイト上でメールアドレスが表示されることはありませんのでご安心ください。ユーザ名は30文字以内で，半角・全角どちらも利用できます。",
    24 => 'パスワードは，ここに入力されたメールアドレス宛てに，送信されます。',
    25 => 'パスワードを忘れた方',
    26 => "ご登録頂いているユーザ名またはメールアドレスの<strong>どちらかを入力</strong>して『送信』ボタンを押してください。ご登録のメールアドレス宛にパスワード再発行用のURL を記載したメールが送信されます。",
    27 => '新規登録',
    28 => '送　　信',
    29 => 'ログアウトしました：',
    30 => 'ログインしました:',
    31 => 'ログインが必要です。',
    32 => '署名',
    33 => '公開されることはありません',
    34 => '本名',
    35 => '変更後のパスワード',
    36 => 'http://から始めてください',
    37 => 'あなたのコメントに使用されます。',
    38 => 'あなたの紹介文です。公開されます。',
    39 => 'あなたの公開PGP鍵',
    40 => '話題アイコンを非表示',
    41 => '修正を受け入れる',
    42 => '日付フォーマット',
    43 => '記事の最大数',
    44 => 'ボックスを表示しない',
    45 => '表示設定',
    46 => '次のアイテムを除外',
    47 => 'ニュースボックスの設定',
    48 => '話題',
    49 => '記事にアイコンを非表示',
    50 => '興味がなければチェックをはずしてください',
    51 => '記事だけを表示',
    52 => '初期値:',
    53 => 'その日の記事を毎晩メールで受け取る。',
    54 => '読みたくない投稿者名と話題をチェックする。',
    55 => 'すべてのチェックをはずした場合は，初期値が反映されます。一つでもチェックした場合，初期値は無視されますので，読みたいものを全部チェックするようにしてください。 初期値は強調表示されている話題です。',
    56 => '投稿者名',
    57 => '表示モード',
    58 => 'ソート順',
    59 => 'コメントの最大数',
    60 => 'コメントの表示方法',
    61 => '順番',
    62 => '初期値は100です',
    63 => "パスワードをメールで送信しました。メッセージにログイン方法をご案内しています。{$_CONF['site_name']}のご利用お待ちしています。",
    64 => 'コメントの設定：',
    65 => 'ログインしてください',
    66 => 'ログインしてください',
    67 => '登録日時',
    68 => '認証の保存期間',
    69 => 'いったんログインした後，どのぐらい認証情報を残しますか？',
    70 => "{$_CONF['site_name']}の表示と内容を設定",
    71 => "{$_CONF['site_name']}では，レイアウトを自由に変えることができます。そのためには，まず，{$_CONF['site_name']}に<a href=\"{$_CONF['site_url']}/users.php?mode=new\">登録</a>する必要があります。もし，すでに登録済みならば左のフォームを利用してログインしてください。",
    72 => 'テーマ',
    73 => '言語',
    74 => 'このサイトのデザインを変更',
    75 => '記事がメールで送信されました。送信先：',
    76 => '下記のリストから話題を選択すれば，毎晩その話題の記事をメールで受け取ることができます。興味のある話題だけ選択してください。',
    77 => 'アバター',
    78 => 'アバターを追加',
    79 => 'アバターを削除する場合，ここをチェックしてください',
    80 => 'ログイン',
    81 => 'メール送信',
    82 => '最新投稿（10件）',
    83 => '投稿状況',
    84 => '投稿記事の総数:',
    85 => 'コメントの総数:',
    86 => 'ユーザのすべての投稿を検索',
    87 => 'あなたのログイン名',
    88 => "%s さん，こんにちは。\n\n{$_CONF['site_name']}よりお知らせです。\n\n以下のページよりパスワード再発行の手続きを行い、そのパスワードで\n今後はログインするようにしてください。\n\nなお、このメールに覚えがない場合、他の方がメールアドレスを間違えて\n入力された可能性があります。パスワードを変更されることはございません\nのでご安心ください。\n\n",
    89 => "",
    90 => '新しいパスワードを入力して 『再発行』 ボタンを押してください。',
    91 => '再発行',
    92 => 'パスワードを再発行する',
    93 => 'パスワード再発行は，%d秒前に行われています。%d秒お待ちください。',
    94 => 'アカウント（"%s"）を削除',
    95 => 'あなたのアカウントを削除するには，下の「アカウント削除」ボタンをクリックしてください。ただし，あなたのアカウント名で投稿された記事やコメントは<strong>削除されません</strong>。これらの記事やコメントは「ゲストユーザ」の投稿として表示されます。',
    96 => 'アカウント削除',
    97 => 'アカウント削除の確認',
    98 => '本当にアカウントを削除しますか。削除すると，このサイトに新しいアカウントを作らない限り，ログインできなくなります。よろしければ，もう一度「アカウント削除」ボタンをクリックしてください',
    99 => 'プライバシーオプション：',
    100 => '管理者からのメール',
    101 => 'サイト管理者からのメールを受け取る',
    102 => '他のユーザからのメール',
    103 => '他のユーザからのメールを受け取る',
    104 => 'オンラインかどうかを表示する',
    105 => '「現在のログイン状況」に名前を表示する',
    106 => '居住地',
    107 => '公開プロフィールで表示',
    108 => 'パスワード（再入力）',
    109 => '新しいパスワードを再入力',
    110 => '現在のパスワード',
    111 => '現在のパスワードを入力してください',
    112 => 'ログイン試行回数を超えてしまいましたので，後ほどまたログインしてみてください。',
    113 => 'ログインできませんでした',
    114 => 'アカウントが無効になっています',
    115 => 'アカウントが無効になりましたのでログインできません。管理者に連絡してください。',
    116 => 'アカウントが有効になるのを待機しています',
    117 => 'あなたのアカウントは管理者が有効にするのを待っています。管理者が承認するまでログインできません。',
    118 => "{$_CONF['site_name']} のあなたのアカウントが有効になりました。以下のリンクから，あなたのユーザ名(<username>)とメールで送られてきたパスワードでログインできます。",
    119 => 'パスワードを忘れた場合，以下のリンクから新しいパスワードを再発行できます。',
    120 => 'アカウントが有効になりました。',
    121 => 'サービス',
    122 => '申し訳ありませんが，ユーザの新規登録は停止中です。',
    123 => "<a href=\"{$_CONF['site_url']}/users.php?mode=new\">新規登録</a>",
    124 => '（確認） メールアドレス',
    125 => '両方の入力欄に同じメールアドレスを入力してください。',
    126 => '確認のために同じものを繰り返し入力してください。',
    127 => '設定を変更するには，現在のパスワードを入力する必要があります。',
    128 => 'お名前',
    129 => 'パスワードとメールアドレス',
    130 => '個人情報',
    131 => '毎日のダイジェスト版オプション',
    132 => '毎日のダイジェスト版機能',
    133 => 'コメント表示',
    134 => 'コメントオプション',
    135 => '<li>デフォルトのコメント表示法</li><li>コメントを表示するデフォルトの順序</li><li>表示するコメントの最大数を設定してください。デフォルトは 100件です。</li>',
    136 => '話題と投稿者の除外',
    137 => '記事のフィルタリング',
    138 => 'その他の設定',
    139 => 'レイアウトと言語',
    140 => '<li>「話題別アイコンを非表示」をチェックすると，記事に話題別アイコンが表示されなくなります</li><li>「ボックスを非表示」をチェックすると，管理者メニューブロック・ユーザメニューブロック・話題ブロックしか表示されなくなります。<li>1ページに表示する記事の最大数を設定してください</li><li>テーマと好みの日付フォーマットを設定してください</li>',
    141 => 'プライバシーの設定',
    142 => 'デフォルトの設定では，他のユーザや管理者があなたにメールアドレスを送ることができ，オンラインかどうかを表示するようになっています。プライバシーを保護するには，対応するオプションのチェックを外してください。',
    143 => 'ブロックのフィルタリング',
    144 => 'ブロックの表示・非表示',
    145 => '公開プロフィール',
    146 => 'パスワードとメールアドレス',
    147 => 'パスワード，メールアドレス，自動ログイン機能を編集します。パスワードとメールアドレスは確認のため，2回入力する必要があります。',
    148 => '個人情報',
    149 => '他のユーザにも読める個人情報を編集します。<li>「署名」はコメントや掲示板の投稿に付加されます</li><li>「自己紹介」は他のユーザにも読める短い自己紹介です</li><li> 「PGP公開鍵」を公開しましょう</li>',

    // Changed by Phize <----
    150 => '操作性向上のために，Javascriptをオンにすることをお勧めします',
    // Changed by Phize ---->

    151 => 'プレビュー',
    152 => 'ユーザ名とパスワード',
    153 => 'レイアウトと言語',
    154 => 'コンテンツ',
    155 => 'プライバシー',
    156 => 'アカウント削除',
    157 => 'アカウント削除オプション'
);

###############################################################################
# index.php

$LANG05 = array(
    1 => '記事がありません',
    2 => '記事がありません。このテーマに関する投稿がないのか表示設定を絞り過ぎなのかのどちらかです。',
    3 => '話題 %s に関する記事',
    4 => '今日の注目記事',
    5 => '次へ',
    6 => '前へ',
    7 => '最初',
    8 => '最後'
);

###############################################################################
# profiles.php

$LANG08 = array(
    1 => 'メッセージを送信する際にエラーが発生しました。もう一度試してください。',
    2 => 'メッセージは送信されました',
    3 => 'メールアドレスをただしく入力していますか？',
    4 => '名前，メールアドレス，件名，内容をすべて入力してください',
    5 => '該当ユーザはいません',
    6 => 'エラーが発生しました',
    7 => 'ユーザ情報',
    8 => '氏名',
    9 => 'URL',
    10 => 'メールの宛先',
    11 => '名前:',
    12 => 'メールアドレス:',
    13 => '件名:',
    14 => '本文:',
    15 => 'HTMLは使えません',
    16 => '送信',
    17 => '友達に記事を送信する',
    18 => '送信先名',
    19 => '送信先E-mail',
    20 => '名前',
    21 => 'メールアドレス',
    22 => 'すべての項目を入力して送信ボタンをクリックしてください',
    23 => "こんにちは！{$_CONF['site_name']}よりお知らせです。\n\n%s さんが\n{$_CONF['site_url']}\nの記事をあなたに知らせたいと思ったため，\n%s のアドレスから送信されました。\nこれはいわゆる迷惑（SPAM）メールではありませんし，\n送信に使用されたアドレスを他の目的に使用することもありません。",
    24 => 'この記事に関するコメントは次の場所でできます。',
    25 => 'この機能を使用するためにはログインしてください。',
    26 => 'このフォームでメールを送ります。',
    27 => 'メッセージ',
    28 => '%s さんからのメッセージ: ',
    29 => "[{$_CONF['site_name']}] に関するダイジェストです。({$_CONF['shortdate']})",
    30 => " [{$_CONF['site_name']}] ニュースレター({$_CONF['shortdate']})",
    31 => 'タイトル',
    32 => '日付',
    33 => '以下の場所で記事全体を読むことができます。',
    34 => 'メッセージは以上です',
    35 => '残念ながらこのユーザはメールを受け付けておりません。'
);

###############################################################################
# search.php

$LANG09 = array(
    1 => '検索オプション',
    2 => 'キーワード',
    3 => '話題',
    4 => 'すべて',
    5 => 'タイプ',
    6 => '記事',
    7 => 'コメント',
    8 => '所有者',
    9 => 'すべて',
    10 => '検索',
    11 => '検索結果',
    12 => '件が該当',
    13 => '記事の検索結果：該当なし',
    14 => '該当するものはありませんでした',
    15 => '他のキーワードで検索してください',
    16 => 'タイトル',
    17 => '日付',
    18 => '所有者',
    19 => " {$_CONF['site_name']} 全体のすべての記事を検索する",
    20 => '日付',
    21 => '～',
    22 => '(書式は YYYY-MM-DD)',
    23 => '件の閲覧',
    24 => '%d件，見つかりました',
    25 => '次のキーワードについて検索：',
    26 => '件',
    27 => '秒',
    28 => '該当する記事・コメントは見つかりませんでした',
    29 => '記事・コメントの検索結果：',
    30 => '',
    31 => 'プラグインからは該当するものを見つかりませんでした',
    32 => '',
    33 => 'URL',
    34 => '場所',
    35 => '一日中',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => '検索文字列は３文字以上必要です',
    42 => '日付の書式は，YYYY-MM-DD（年-月-日）としてください',
    43 => '正確な文字列',
    44 => 'すべて含む',
    45 => 'いずれか含む',
    46 => '次',
    47 => '前',
    48 => '所有者',
    49 => '日付',
    50 => '閲覧件数',
    51 => '',
    52 => '場所',
    53 => '記事の検索結果',
    54 => 'コメントの検索結果',
    55 => '検索文字列',
    56 => 'AND',
    57 => 'OR',
    58 => '次の検索結果へ &gt;&gt;',
    59 => '１ページあたりの件数',
    60 => '件',
    61 => '検索条件の修正'
);

###############################################################################
# stats.php

$LANG10 = array(
    1 => 'サイトに関する統計',
    2 => 'システム全体のアクセス数',
    3 => '記事（コメント）の数',
    4 => '',
    5 => '',
    6 => '',

    // Changed by Phize <----
    7 => 'もっとも閲覧の多かった記事(上位10件)',
    // Changed by Phize ---->

    8 => '記事のタイトル',
    9 => '件',

    // Changed by Phize <----
    10 => '<p>このサイトには記事が一件もないか，閲覧した人がいないのかどちらかのようです。</p>',
    // Changed by Phize ---->

    // Changed by Phize <----
    11 => 'もっともコメントされた記事(上位10件)',
    // Changed by Phize ---->

    12 => '件',

    // Changed by Phize <----
    13 => '<p>このサイトには記事が一件もないか，コメントした人がいないのかどちらかのようです。</p>',
    // Changed by Phize ---->

    14 => '',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => '',

    // Changed by Phize <----
    22 => 'もっとも紹介された記事(上位10件)',
    // Changed by Phize ---->

    23 => 'メールアドレス',

    // Changed by Phize <----
    24 => '<p>友達に紹介された記事はないようです。</p>',
    // Changed by Phize ---->

    25 => 'トラックバック(上位10件)',

    // Changed by Phize <----
    26 => '<p>トラックバックはありません。</p>',
    // Changed by Phize ---->

    27 => '登録ユーザの数',
    28 => '',
    29 => '',
    30 => 'ヒット',
    31 => ''
);

###############################################################################
# article.php

$LANG11 = array(
    1 => '関連情報',
    2 => '友達に記事をメールする',
    3 => '印刷フォームページ',
    4 => '記事のオプション',
    5 => 'PDF Story Format'
);

###############################################################################
# submit.php

$LANG12 = array(
    1 => ' %s を投稿する前にログインしてください',
    2 => 'ログイン',
    3 => '新規登録',
    4 => '',
    5 => '',
    6 => '記事の投稿',
    7 => 'ログインが必要です',
    8 => '投稿',
    9 => '<p>このサイトに情報を投稿する際には，次のルールを守ってください。<ul><li>必要とされるすべての項目を入力してください。</p><li>正確かつ必要十分な情報を提供してください<li>URLについては特に注意して確認してください</ul>',
    10 => 'タイトル',
    11 => '',
    12 => '開始日',
    13 => '終了日',
    14 => '場所',
    15 => '詳細',
    16 => '',
    17 => '',
    18 => '',
    19 => 'はじめにお読みください',
    20 => '',
    21 => '',
    22 => '入力に不備があります',
    23 => 'すべてのフィールドに入力してください。',
    24 => '投稿を受け付けました',
    25 => '%s に関する投稿を受け付けました',
    26 => '投稿間隔の制限',
    27 => 'ユーザ名',
    28 => '話題',
    29 => '記事',
    30 => '前回，あなたは，',
    31 => "秒前に投稿しています。投稿間隔を{$_CONF['speedlimit']}秒以上にしてください。",
    32 => 'プレビュー',
    33 => '記事のプレビュー',
    34 => 'ログアウト',
    35 => 'HTMLタグは使用できません',
    36 => '投稿モード',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => '',
    42 => '',
    43 => '',
    44 => '住所1',
    45 => '住所2',
    46 => '市町村名',
    47 => '都道府県',
    48 => '郵便番号',
    49 => '',
    50 => '',
    51 => '場所',
    52 => '削除',
    53 => 'アカウント作成'
);

###############################################################################
# ADMIN PHRASES - These are file phrases used in admin scripts
###############################################################################

###############################################################################
# admin/auth.inc.php

$LANG20 = array(
    1 => '管理権限が必要です',
    2 => 'ログインできません。もう一度入力してください',
    3 => 'パスワードが違います。ユーザ名：',
    4 => 'ユーザ名：',
    5 => 'パスワード：',
    6 => '管理ツールの使用は，すべてが記録されます。<br>このページは，管理者のみ使用できます。',
    7 => 'ログイン'
);

###############################################################################
# admin/block.php

$LANG21 = array(
    1 => 'ここを管理する権限がない',
    2 => 'このブロックを編集する権限がない',
    3 => 'ブロックの編集',
    4 => 'フィードの読み込みでエラーが発生しました。（error.logを参照してください。）',
    5 => '',
    6 => '',
    7 => 'すべて',
    8 => 'ブロックのセキュリティレベル',
    9 => 'ブロックの順序',
    10 => '',
    11 => 'ポータルブロック',
    12 => 'ノーマルブロック',
    13 => 'ポータルブロックのオプション',
    14 => 'RSS URL',
    15 => 'RSS更新日時',
    16 => 'ノーマルブロックのオプション',
    17 => 'コンテンツ',
    18 => 'ブロックのタイトル・セキュリティレベル・コンテンツを入力してください。',
    19 => 'ブロック管理',
    20 => '',
    21 => 'セキュリティ',
    22 => '',
    23 => '順序',
    24 => '',
    25 => 'ブロックの編集・削除はブロックの編集アイコンを，新規作成は上の「新規作成」リンクをクリックします',
    26 => 'レイアウト用ブロック',
    27 => 'PHPブロック',
    28 => 'PHPブロックのオプション',
    29 => '関数',
    30 => 'PHPを使用したブロックを使う場合，接頭子「phpblock_」（例 phpblock_themetester）のPHP関数名を入力してください。この接頭子が付いていない関数は呼び出されません。これは，悪意を持ったユーザがサイトに有害な関数を定義することを避けるためです。関数名に（）は不要です。すべてのPHPブロック関数は，/path/to/geeklog/system/lib-custom.phpにまとめてください。そうすることで，Geeklogをアップグレードしても使用し続けることができます。',

    // Changed by Phize <----
    31 => '<p>PHPブロックにエラーがあります。%sが存在しません</p>',
    // Changed by Phize ---->

    32 => 'エラー。未入力の項目があります',
    33 => 'ポータルブロックの.rdfファイルにはURLが入力されている必要があります',
    34 => 'PHPブロックにはタイトルと関数名を入力してください',
    35 => '普通のブロックにはタイトルと内容を入力してください',
    36 => 'レイアウト用ブロックには内容を入力してください',
    37 => 'PHPブロックの関数名が不適切です',
    38 => 'PHPブロックの関数名は，接頭子\'phpblock_\' (例 phpblock_themetester)が必要です。セキュリティ対策のため，ご協力ください。',
    39 => '表示場所',
    40 => '左',
    41 => '右',
    42 => 'ブロックのタイトルと表示順序を入力してください',
    43 => 'ホームページのみ',
    44 => '',
    45 => "管理権限のないブロックを編集しようとしました。この行為は記録されます。<a href=\"{$_CONF['site_admin_url']}/block.php\">ブロックの編集</a>画面に戻ってください.",
    46 => '移動',
    47 => '',
    48 => 'ブロックID',
    49 => '(半角英数字とハイフン)',
    50 => '',
    51 => 'http://を含む',
    52 => '空欄のままにしておくと，このブロックに対するヘルプのアイコンは表示されません',
    53 => '有効',
    54 => '保存',
    55 => 'キャンセル',
    56 => '削除',
    57 => 'ブロックを下に',
    58 => 'ブロックを上に',
    59 => 'ブロックを右側に',
    60 => 'ブロックを左側に',
    61 => 'タイトルなし',
    62 => '表示件数',
    63 => 'ブロックのタイトルが不適切です',
    64 => 'タイトルは空欄ではいけませんし，HTMLを含んでもいけません！',
    65 => '順番',
    66 => '自動タグ',
    67 => '自動タグ使用許可'
);

###############################################################################
# admin/story.php

$LANG24 = array(
    1 => '前の記事',
    2 => '後の記事',
    3 => 'モード',
    4 => '投稿モード',
    5 => '記事の編集',
    6 => '記事がありません',
    7 => 'ユーザ',
    8 => '保存',
    9 => 'プレビュー',
    10 => 'キャンセル',
    11 => '削除',
    12 => '記事ID',
    13 => '',
    14 => '',
    15 => '日時',
    16 => '冒頭文',
    17 => '本文',
    18 => '閲覧件数',
    19 => 'コメント数',
    20 => 'Ping',
    21 => 'トラックバック・ピングを送る',
    22 => '記事管理',
    23 => '記事の編集・削除は記事の編集アイコン，記事の閲覧は記事のタイトル，新しい記事を作成する場合は，「新規作成」をクリックしてください。',
    24 => '指定した記事IDはすでに使われています。他の記事IDを入力してください。',
    25 => '記事の登録中にエラーがありました。',
    26 => '記事のプレビュー',
    27 => '<p>自動タグ[imageX]のかわりに[unscaledX]を使うと，画像はオリジナルのサイズで表示されます。</p>',

    // Changed by Phize <----
    28 => '<strong>プレビュー</strong>: 画像付きの記事をプレビューする場合，プレビューボタンをクリックしないで一旦ドラフトモードで保存してください。プレビューボタンは画像がない場合にのみクリックしてください。</p>',
    // Changed by Phize ---->

    29 => 'トラックバック数',
    30 => 'ファイルのアップロード時にエラーが発生しました',
    31 => 'タイトルと冒頭文を入力してください',
    32 => '注目記事',
    33 => '注目記事は最後に指定した１件が指定されます',
    34 => 'ドラフト',
    35 => '○',
    36 => '－',
    37 => '同じ投稿者からの投稿：',
    38 => '同じ話題：',
    39 => 'メールアドレス紹介',
    40 => '',
    41 => "管理権限のない記事を編集しようとしました。この行為は記録されます。下記の記事は読みとり専用です。読み終わったら，<a href=\"{$_CONF['site_admin_url']}/story.php\">記事の編集画面</a>に戻ってください。",
    42 => "管理権限のない記事を編集しようとしました。この行為は記録されます。<a href=\"{$_CONF['site_admin_url']}/story.php\">記事の編集画面</a>に戻ってください",
    43 => '',
    44 => '',
    45 => '',

    // Changed by Phize <----
    46 => '<strong>注意</strong>: 記事の日付を将来の日付に変更すると，その日まで記事は表示されません。また，RSSフィードにも反映せず，検索やサイト情報にも反映されません。',
    // Changed by Phize ---->

    47 => 'image',
    48 => 'image',
    49 => 'right',
    50 => 'left',

    // Changed by Phize <----
    51 => '<p>添付した画像は，自動タグで記述してください。書式は，[imageX]，[imageX_right]，[imageX_left]（Xは添付した画像の番号）（例 [image1]）。注意：添付した画像は記事内ですべて使用しなければ記事を保存できません。<br><strong>プレビュー</strong>: 画像付きの記事はドラフト（下書き）として保存して閲覧してください。プレビューボタンは画像が無いときにのみ利用できます。</p>',
    // Changed by Phize ---->

    52 => '',
    53 => 'は使用されていません。保存する前に冒頭文または本文で画像を使用しなければなりません。',
    54 => '添付された画像が使用されていません。',
    55 => '記事を保存する際に下記のエラーが発生しました。保存する前に修正してください。',
    56 => '話題アイコン表示',
    57 => '元のサイズの画像を表示',
    58 => '圧縮オプション',
    59 => 'オプション',
    60 => '',
    61 => '自動圧縮',
    62 => '自動削除',
    63 => '',
    64 => '',
    65 => '',
    66 => '',
    67 => '編集エリアの拡大',
    68 => '編集エリアの縮小',
    69 => '投稿日時と公開モードの設定',
    70 => 'ツールバーの選択',
    71 => '基本的なツールバー',
    72 => '一般的なツールバー',
    73 => '拡張ツールバー',
    74 => '拡張ツールバーその２',
    75 => '全機能',
    76 => '公開オプション',
    77 => 'アドバンストエディタの利用は，ブラウザでJavaScriptが使える環境にする必要があります。このオプションはconfig.phpで無効にできます。 ',
    78 => '<a href="%s/story.php?mode=edit&sid=%s&editopt=default">ノーマルエディタを使う場合</a>',
    79 => 'プレビュー',
    80 => 'エディタ',
    81 => '公開オプション',
    82 => '画像',
    83 => '圧縮',
    84 => 'パーミッション',
    85 => '全て表示',
    86 => 'アドバンストエディタ',
    87 => '記事の情報'
);


###############################################################################
# admin/topic.php

$LANG27 = array(
    1 => '話題の編集',
    2 => '話題ID',
    3 => '話題名',
    4 => '話題アイコンファイル指定',
    5 => '(半角英数字とハイフン)',
    6 => '話題を削除すると，関連した記事・ブロックもすべて削除されます',
    7 => '話題IDと話題名を入力してください',
    8 => '話題管理',
    9 => '話題とは，記事カテゴリのことです。話題の編集・削除は各話題名を，新しい話題の作成は「新規作成」リンクをクリックしてください。カッコ内はあなたのアクセスレベルです。*は，記事投稿時のデフォルト話題です。',
    10 => '並べる順序',
    11 => '１ページあたりの記事数',
    12 => 'アクセスが拒否されました',
    13 => "管理権限のない話題を編集しようとしました。この行為は記録されます。<a href=\"{$_CONF['site_admin_url']}/topic.php\">話題の編集画面</a>に戻ってください",
    14 => '並べ替え方法',
    15 => 'アルファベット順',
    16 => '初期値は：',
    17 => '新規話題',
    18 => '管理画面',
    19 => '保存',
    20 => 'キャンセル',
    21 => '削除',
    22 => 'デフォルト',
    23 => 'この話題を新規記事投稿の際のデフォルトにします。',
    24 => '(*)',
    25 => '圧縮',
    26 => '話題を圧縮します。',
    27 => '話題アイコンアップロード',
    28 => '最大',
    29 => 'ファイルアップロード時にエラー'
);

###############################################################################
# admin/user.php

$LANG28 = array(
    1 => 'ユーザの編集',
    2 => 'ユーザID',
    3 => 'ユーザ名',
    4 => '氏名',
    5 => 'パスワード',
    6 => 'セキュリティレベル',
    7 => 'メールアドレス',
    8 => 'ホームページ',
    9 => '(半角英数字とハイフン)',
    10 => 'ユーザ名・メールアドレスを入力してください。',
    11 => 'ユーザ管理',
    12 => 'ユーザの編集・削除はユーザ別編集アイコン，新規ユーザの作成は「新規作成」，ユーザの一括登録（インポート）は「一括登録」，ユーザの一括削除は「一括削除」をクリックしてください。',
    13 => 'セキュリティ',
    14 => '登録日',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => '保存',
    21 => '登録しようとしたユーザ名はすでに存在します',
    22 => 'エラー',
    23 => '一括登録',
    24 => 'ユーザの一括登録',
    25 => 'ユーザをGeeklogに一括登録できます（重複チェック付き）。一括登録するファイルはユーザは一行あたり一人ずつで，各ユーザのデータはタブ区切りで「氏名，ユーザ名，メールアドレス」のフィールド順です。ユーザのパスワードは無作為に決定されます。ファイルはかならず本サイトと同じ文字コードのテキスト形式で保存してください。',
    26 => '',
    27 => '',
    28 => '画像を削除する場合チェックする',
    29 => 'パス',
    30 => '実行',
    31 => '新規ユーザ',
    32 => '処理が完了しました。%d 件登録が成功しました。%d 件のエラーが発生しました',
    33 => '検索',
    34 => 'エラー：登録するファイルを指定してください',
    35 => '最後のログイン日時',
    36 => '未',
    37 => 'ユーザID',
    38 => 'グループ一覧',
    39 => 'パスワード（再入力）',
    40 => '登録日',
    41 => '最終ログイン',
    42 => '禁止',
    43 => '有効になるのを待機中',
    44 => '承認されるのを待機中',
    45 => '有効',
    46 => 'ユーザの状態',
    47 => '編集',
    48 => '管理者グループを表示',
    49 => '管理者グループ',
    50 => 'このグループを管理者グループとしてフィルタリングするには，チェックしてください。',
    51 => 'オンライン期間',
    52 => '<br>注: 「オンライン期間」とは，最初にアカウントを登録してから前回ログインした時までの日数です。',
    53 => '登録済み',
    54 => '一括削除',
    55 => 'config.phpで <code>$_CONF[\'lastlogin\'] = true;</code> としている場合しか，この機能は働きません。',
    56 => '削除したいユーザの種類を選択して「リスト更新」をクリックしてください。次に，削除したくないユーザのチェックを外して「削除」アイコンをクリックしてください。このリストがページをまたがっている場合，現在表示されているユーザしか削除されないことに注意してください。',
    57 => '幽霊ユーザ',
    58 => '一時的ユーザ',
    59 => '過去のユーザ',
    60 => '',
    61 => 'ヶ月前に登録したが，一度もログインしていないユーザ。',
    62 => '',
    63 => 'ヶ月前に登録して，それから24時間以内にログインしたが，それ以来一度も戻ってきてログインしていないユーザ。',
    64 => '単に ',
    65 => 'ヶ月間，サイトを訪問していない普通のユーザ。',
    66 => 'リストを更新',
    67 => '登録して何ヶ月経つか',
    68 => 'オンライン時間',
    69 => 'オフライン月数',
    70 => '削除できませんでした',
    71 => '削除されました',
    72 => '削除するユーザが選択されていません',
    73 => '削除すると元に戻せません。選択したユーザをすべて削除してよいですか？',
    74 => '最近のユーザ',
    75 => '最後に登録したユーザ ',
    76 => ' ヶ月の間に登録したユーザ'
);

###############################################################################
# admin/moderation.php

$LANG29 = array(
    1 => '承認',
    2 => '削除',
    3 => '編集',
    4 => 'プロフィール',
    10 => 'タイトル',
    11 => '開始日',
    12 => 'URL',
    13 => '投稿',
    14 => '日付',
    15 => '話題',
    16 => 'ユーザ名',
    17 => '氏名',
    18 => 'メールアドレス',
    34 => '投稿管理',
    35 => '記事の投稿申請',
    36 => '',
    37 => '',
    38 => '実行',
    39 => 'ただいま申請はありません',
    40 => 'ユーザの登録申請'
);

###############################################################################
# admin/mail.php

$LANG31 = array(
    1 => 'グループメール送信',
    2 => '送信者名',
    3 => '返信先',
    4 => '件名',
    5 => '内容',
    6 => '送信先：',
    7 => 'すべてのユーザ',
    8 => '管理者',
    9 => 'オプション',
    10 => 'HTML',
    11 => '緊急！',
    12 => 'グループメールを送信する',
    13 => '入力しなおす',
    14 => 'ユーザの受信許可設定を無視して送る',
    15 => '送信中にエラーが発生。宛先： ',
    16 => 'メッセージの送信が完了しました。宛先：',
    17 => "<a href={$_CONF['site_admin_url']}/mail.php>他のメッセージを送る</a>",
    18 => '送信先',
    19 => '補足: 登録者全員に送信するには，送信先を「Logged-in Users」としてください。',
    20 => "<successcount> 件のメッセージの送信に成功し，<failcount> 件のメッセージの送信には失敗しました。個別のメッセージの送信状態は次のとおりです。<a href=\"{$_CONF['site_admin_url']}/mail.php\">別のメッセージを送信</a>するか，<a href=\"{$_CONF['site_admin_url']}/moderation.php\">管理画面に戻る</a>ことができます",
    21 => '送信失敗',
    22 => '送信成功',
    23 => '失敗したものはありません',
    24 => '成功したものはありません',
    25 => '-- グループを選択 --',
    26 => 'すべてのフィールドに入力してください。また，グループはドロップダウンリストで選択してください。'
);

###############################################################################
# admin/plugins.php

$LANG32 = array(
    1 => 'プラグインをインストールすることで，Geeklogや最悪の場合はシステムに悪影響を与えることがあります。悪影響を避けるために，Geeklogのホームページでは様々なOSでテストしたプラグインのみを掲載していますので，<a href="http://www.geeklog.net" target="_blank">Geeklogのホームページ</a>からのみダウンロードするようにしてください。プラグインのインストールに際しては，システムのコマンドを実行する必要がありますので，特に公式サイト以外からダウンロードしたばあいは，この点に注意してください。また，これらの注意は，プラグインのインストールの成功やプラグインによる影響について我々がなんらかの保証をするものではありません。プラグインのインストール方法は，それぞれのプラグインに同梱されています。',
    2 => 'プラグインのインストールに関する注意',
    3 => 'プラグインのインストールフォーム',
    4 => 'プラグインのファイル',
    5 => 'プラグイン管理',
    6 => '注意：プラグインはすでにインストールされています。',
    7 => 'インストールしようとしているプラグインはすでに存在しています。再インストールする前に一旦削除してください。',
    8 => 'プラグインの互換性チェックに失敗しました。',
    9 => 'このプラグインは新しいバージョンのGeeklogが必要です。<a href=http://www.geeklog.net>Geeklog</a>をアップグレードするか，新しいバージョンのプラグインを入手してください。',

    // Changed by Phize <----
    10 => '<br><strong>プラグインはインストールされていません</strong><br><br>',
    // Changed by Phize ---->

    11 => 'プラグインを修正・削除するにはプラグインの編集アイコンをクリックしてください。プラグインの作者のページへのリンクも併せて表示されます。プラグインのバージョンは，インストール中のものとファイルから得られたものが表示されます。これによってプラグインの更新の必要性を判断することができます。',
    12 => 'plugineditor()にプラグイン名が渡されませんでした',
    13 => 'プラグイン編集',
    14 => '新規プラグイン',
    15 => '管理画面',
    16 => 'プラグイン名',
    17 => 'プラグインバージョン',
    18 => 'GLバージョン',
    19 => '有効',
    20 => 'Yes',
    21 => 'No',
    22 => 'インストール',
    23 => '保存',
    24 => 'キャンセル',
    25 => '削除',
    26 => 'プラグイン名',
    27 => 'プラグインWebページ',
    28 => 'プラグインバージョン',
    29 => 'GLバージョン',
    30 => 'このプラグインを削除しますか？',
    31 => 'このプラグインを削除してよいですか？削除すると関連するファイルやデータがすべて削除されます。削除する場合は「削除」ボタンをもう一度クリックしてください。',

    // Changed by Phize <----
    32 => '<p><strong>オートリンクタグのフォーマットが正しくありません。</strong></p>',
    // Changed by Phize ---->

    33 => '最新のバージョン',
    34 => '更新',
    35 => '編集',
    36 => 'コード',
    37 => 'データ',
    38 => '更新されています'
);

###############################################################################
# admin/syndication.php

$LANG33 = array(
    1 => 'フィードの作成',
    2 => '保存',
    3 => '削除',
    4 => 'キャンセル',
    10 => 'RSS配信管理',
    11 => '新しいフィード',
    12 => '管理画面',
    13 => 'フィードを修正・削除する場合は，タイトル左のアイコンをクリックしてください。新しいフィードを作成する場合は，「新規フィード」をクリックしてください。',
    14 => 'タイトル',
    15 => 'タイプ',
    16 => 'ファイル名',
    17 => 'フォーマット',
    18 => '更新日',
    19 => '有効',
    20 => 'Yes',
    21 => 'No',
    22 => '<i>(フィードがありません)</i>',
    23 => 'すべての話題',
    24 => 'フィードの編集',
    25 => 'フィードのタイトル',
    26 => '配信最大件数',
    27 => 'エントリの長さ',
    28 => '(0 = 本文なし, 1 = 本文全て, other = 指定した文字数に制限。)',
    29 => '詳細',
    30 => '更新',
    31 => '文字コード',
    32 => '言語',
    33 => '話題',
    34 => '件',
    35 => '時間以内',
    36 => 'フィードのタイプを選択してください。',
    37 => 'RSS配信を有効にするためには，関係するプラグインを少なくとも一つインストールしておいて下さい。以下では，Geeklogのフィードを作成するのか，プラグインで取得するフィードを作成するのか選択してください。',
    38 => 'エラー: 入力していない項目があります。',
    39 => 'フィードのタイトル，詳細，ファイル名を入力してください。',
    40 => 'エントリ数または，取得する時間を入力してください。',
    41 => 'リンク',
    42 => '',
    43 => 'すべて',
    44 => 'なし',
    45 => 'ヘッダーリンクする話題',
    46 => '表示件数',
    47 => '検索',
    48 => '編集',
    49 => 'ロゴ',
    50 => "本サイトからの相対URL ({$_CONF['site_url']})",
    51 => '選択したフィード名は他のフィードで使用されています。別の名前にしてください。',
    52 => 'エラー: このファイル名は既に使用されています'
);

###############################################################################
# confirmation and error messages

$MESSAGE = array(
    1 => "パスワードをメールで送信しましたので確認してください。利用方法はメールを参照してください。{$_CONF['site_name']}",
    2 => "{$_CONF['site_name']} に記事を投稿してくれてありがとうございます。記事はスタッフに通知しました。承認されればすぐにサイトに掲載されます。",
    3 => '',
    4 => '',
    5 => 'アカウント情報は，変更されました。',
    6 => '表示設定を保存しました。',
    7 => 'コメントの設定変更を。',
    8 => 'ログアウトが完了しました。',
    9 => '記事の変更を反映しました。',
    10 => '記事の削除が完了しました。',
    11 => 'ブロックの変更を反映しました。',
    12 => 'ブロックの削除が完了しました。',
    13 => '話題の変更を反映しました。',
    14 => '話題とそれに含まれるすべての記事とブロックを削除しました',
    15 => 'リンクの変更を反映しました。',
    16 => 'リンクを削除しました。',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => 'ユーザ情報は保存されました。',
    22 => 'ユーザを削除しました。',
    23 => '',
    24 => '',
    25 => '',
    26 => '',
    27 => 'メッセージを送信しました。',
    28 => 'プラグインを保存しました',
    29 => '',
    30 => 'アクセスが拒否されました',
    31 => '話題管理用画面へのアクセス権がありません。管理権限のない場所へのアクセスはすべて記録されます。',
    32 => '記事管理用画面へのアクセス権がありません。管理権限のない場所へのアクセスはすべて記録されます。',
    33 => 'ブロック編集用画面へのアクセス権がありません。管理権限のない場所へのアクセスはすべて記録されます。',
    34 => '',
    35 => '',
    36 => '',
    37 => 'ユーザ管理用画面へのアクセス権がありません。管理権限のない場所へのアクセスはすべて記録されます。',
    38 => 'プラグイン管理用画面へのアクセス権がありません。管理権限のない場所へのアクセスはすべて記録されます。',
    39 => 'メール管理用画面へのアクセス権がありません。管理権限のない場所へのアクセスはすべて記録されます。',
    40 => 'システムからのメッセージ',
    41 => '文字置換用画面へのアクセス権がありません。管理権限のない場所へのアクセスはすべて記録されます。',
    42 => '単語が登録されました。',
    43 => '単語を削除しました',
    44 => 'プラグインをインストールしました',
    45 => 'プラグインを削除しました',
    46 => 'データベースバックアップユーティリティへのアクセス権がありません。管理権限のない場所へのアクセスはすべて記録されます。',
    47 => 'この機能は，*nix上でしか動きません。もし，*nix上で動かしているならば，キャッシュは無事クリアされました。Windows上で動かしている場合は，adodb_*.phpというファイルを検索して，手動で削除してください。',
    48 => "{$_CONF['site_name']}にご登録ありがとうございます。管理者の間で審査します。登録が認められたら，あなたの登録したメールアドレスにパスワードを送信します。",
    49 => 'グループが無事登録されました。',
    50 => 'グループを削除しました。',
    51 => 'ユーザ名が既に使われています。別の名前を指定してください。',
    52 => '入力されたメールアドレスは無効なアドレスだと思われます。',
    53 => '新しいパスワードが登録されました。このパスワードを使ってログインしてください。',
    54 => 'あなたの新規パスワード発行申請は期限が切れています。下のフォームから再申請してください。',
    55 => 'メールが送信されました。届いたメールの指示にしたがって新しいパスワードを設定してください。',
    56 => 'メールアドレスは別のアカウントで既に使われています。',
    57 => 'アカウントの削除が完了しました。',
    58 => 'フィードが無事保存されました。',
    59 => 'フィードが削除されました。',
    60 => 'プラグインが更新されました。',
    61 => '%sプラグイン : メッセージのプレイスホルダーが不明です。',
    62 => 'トラックバックのコメントが削除されました。',
    63 => 'トラックバックのコメントを削除する際に問題が発生しました。',
    64 => 'トラックバックが無事送られました。',
    65 => 'Weblog ディレクトリサービスがセーブされました。',
    66 => 'Weblog ディレクトリサービスが削除されました。',
    67 => '新しいパスワードと確認用パスワードが一致しません。',
    68 => '正しいパスワードを入力してください。',
    69 => 'アカウントが停止されています。',
    70 => 'アカウントは管理者の承認を待っています。',
    71 => 'アカウントが登録されて，管理者の承認を待っています。',
    72 => 'プラグインのインストール時にエラーがありました。error.logを確認してください。',
    73 => 'プラグインの削除時にエラーがありました。See error.logを確認してください。',
    74 => 'ピングバックが無事送られました。',
    75 => 'トラックバックはPOST requestで送る必要があります。',
    76 => 'この項目を削除してもよいですか？',
    77 => '警告:<br>デフォルトのエンコーディングをUTF-8に設定していますが，サーバーがマルチバイトエンコーディングをサポートしていません。PHP用に mbstring モジュールをインストールするか，UTF-8ではないキャラクタセットないし言語に変更してください。',
    78 => 'メールアドレスと確認用メールアドレスには同じものを入力してください。',
    79 => '開こうしたページは，このサイトにもはや存在していない関数を参照しています。',
    80 => 'このフィードを作成したプラグインは，現在無効にされています。そのプラグインを再び有効にしなければ，フィードを編集できません。',
    81 => 'ログイン情報の入力が不正確だったようです。もう一度，ログインし直してください。',
    82 => 'ログイン回数制限を超えました。しばらく経って，再度ログインしてください。',
    83 => 'パスワード，メールアドレス，認証の保存期間を変更するには，現在のパスワードを入力してください。',
    84 => 'アカウントを削除するには，現在のパスワードを入力してください。'
);

###############################################################################

$LANG_ACCESS = array(
    'access' => 'アクセス',
    'ownerroot' => '所有者/Root',
    'group' => 'グループ',
    'readonly' => '読みとり専用',
    'accessrights' => 'アクセス権限',
    'owner' => '所有者',
    'grantgrouplabel' => '上記のグループに編集権限を与える',
    'permmsg' => '参考: メンバーとはログインしているメンバー。ゲストユーザとは，ログインせずに閲覧している一般の閲覧者。',
    'securitygroups' => 'セキュリティグループ',
    'editrootmsg' => "管理権限を持っていても，rootユーザにならずにrootユーザを編集することはできません。それ以外のユーザの編集は可能です。権限なしにrootユーザを編集しようとした場合，記録に残ることに注意してください。<a href=\"{$_CONF['site_admin_url']}/user.php\">ユーザ管理ページ</a>に戻る",
    'securitygroupsmsg' => 'このユーザが所属するグループにチェックしてください。',
    'groupeditor' => 'グループの編集',
    'description' => '詳細',
    'name' => '名前',
    'rights' => '権限',
    'missingfields' => '未入力項目',
    'missingfieldsmsg' => '名前と詳細を入力してください。',
    'groupmanager' => 'グループ管理',
    'newgroupmsg' => 'グループの編集・削除は各グループの編集アイコンをクリック，グループ作成は「新規作成」リンクをクリックしてください。ただし，「コア（中核）グループ」はシステムで使用するため削除できません。',
    'groupname' => 'グループ名',
    'coregroup' => 'コアグループ',
    'yes' => 'Yes',
    'no' => 'No',
    'corerightsdescr' => "このグループは，{$_CONF['site_name']}の「コア（中核）グループ」です。そのため，本グループの権限を編集することはできないため，下記の権限リストは読みとり専用となっています。",
    'groupmsg' => '本サイトのセキュリティグループは階層的になっています。本グループを下記のグループに追加する場合，そのグループの持つ権限と同じ権限を本グループにも与えることになります。可能であれば，本グループに権限を与える場合，下記のグループの権限を継承させることが望ましい方法です。本グループに個別に権限を与える場合は，下記の「権限」部分から様々な機能に関する権限を選択することができます。本グループを追加する場合は，下記のグループの横にあるボックスをチェックするだけです。',
    'coregroupmsg' => "本グループは{$_CONF['site_name']}の「コア（中核）グループ」です。そのため，本グループの所属するグループは編集できません。下記のリストは読みとり専用となっています。",
    'rightsdescr' => 'グループのアクセス権は下記の権限で与えられているか，グループが所属するグループ全体の権限を継承しています。下記のうち，チェックのない権限は，本グループの所属するグループから継承した権限です。チェックのある権限は本グループ自体が直接与えられている権限です。',
    'lock' => 'ロック',
    'members' => 'メンバー　',
    'anonymous' => 'ゲストユーザ',
    'permissions' => 'パーミッション',
    'permissionskey' => 'R = 閲覧, E = 編集, （編集権は閲覧権を含みます）',
    'edit' => '編集',
    'none' => 'なし',
    'accessdenied' => 'アクセスが拒否されました',
    'storydenialmsg' => "この記事を閲覧する権限がありません。これは，あなたが{$_CONF['site_name']}のメンバーがないためだと思われます。{$_CONF['site_name']} の<a href=users.php?mode=new> メンバーになること</a>で閲覧が可能になります。",
    'nogroupsforcoregroup' => 'このグループは他のどのグループにも所属していません',
    'grouphasnorights' => 'このグループは管理権限を一切所有していません。',
    'newgroup' => '新規',
    'adminhome' => '管理画面',
    'save' => '保存',
    'cancel' => 'キャンセル',
    'delete' => '削除',
    'canteditroot' => 'Rootグループに所属していないのにRootグループを編集しようとしたため，アクセスは拒否されました。このエラーがおかしいと思った場合はシステムの管理者に連絡してください。',
    'listusers' => 'ユーザの表示と編集',
    'listthem' => 'リスト',
    'usersingroup' => '"%s"に含まれるユーザの一覧',
    'usergroupadmin' => 'グループ管理',
    'add' => '追加',
    'remove' => '削除',
    'availmembers' => 'ユーザ一覧',
    'groupmembers' => 'グループメンバー',
    'canteditgroup' => 'グループを編集するためには，グループのメンバーでなければなりません。このメッセージがエラーである場合は，システム管理者に連絡してください。',
    'cantlistgroup' => 'メンバーリストを閲覧するためには，グループのメンバーでなければなりません。このメッセージがエラーである場合は，システム管理者に連絡してください。',
    'editgroupmsg' => 'グループメンバーを編集するには，メンバー名をクリックして「追加」または「削除」ボタンをクリックしてください。ユーザがグループメンバーのときは右側だけに表示されます。編集が終わったら，「保存」ボタンをクリックしてください。管理画面に戻ります。',

    // Changed by Phize <----
    'listgroupmsg' => 'グループ<strong>%s</strong>に含まれるユーザ：',
    // Changed by Phize ---->

    'search' => '検索',
    'submit' => '実行',
    'limitresults' => 'リスト',
    'group_id' => 'グループID',
    'plugin_access_denied_msg' => 'このプラグインの管理権限がないのに管理画面にアクセスしようとしました。この行為は記録されます。',
    'groupexists' => 'このグループ名はすでに存在しています。',
    'groupexistsmsg' => '同じグループ名があります。グループ名はそれぞれ異なっている必要があります.'
);

###############################################################################
# admin/database.php

$LANG_DB_BACKUP = array(
    'last_ten_backups' => '過去のバックアップ（10世代分）',
    'do_backup' => 'バックアップの実行',
    'backup_successful' => 'データベースのバックアップが完了しました',
    'no_backups' => 'システムにバックアップがありません',
    'db_explanation' => 'Geeklogをバックアップするには下のボタンをクリックしてください',
    'not_found' => "パスの指定が間違っているか，mysqldumpが実行可能になっていません。<br><strong>\$_DB_mysqldump_path</strong>の設定をconfig.phpでチェックしてください。<br>現在の設定は，\n<var>{$_DB_mysqldump_path}</var>です。",
    'zero_size' => 'バックアップが失敗しました。ファイルの大きさが0 bytesです。',
    'path_not_found' => "{$_CONF['backup_path']} は存在しないか，ディレクトリではありません。",
    'no_access' => "エラー： {$_CONF['backup_path']} ディレクトリにアクセスできません。",
    'backup_file' => 'バックアップファイル',
    'size' => 'サイズ',
    'bytes' => 'バイト',
    'total_number' => 'バックアップ総数は，%dです。'
);
###############################################################################

$LANG_BUTTONS = array(
    1 => 'ホーム',
    2 => 'メールを送る',
    3 => '記事公開',
    4 => '',
    5 => '',
    6 => '',
    7 => 'サイト情報',
    8 => '個人設定',
    9 => '検索',
    10 => '検索オプション',
    11 => '記事管理'
);

###############################################################################
# 404.php

$LANG_404 = array(
    1 => '404 Error',

    // Changed by Phize <----
    2 => '<strong>%s</strong>はどこにも見つかりませんでした。',
    // Changed by Phize ---->

    3 => '指定されたファイルは存在しません。メインページをチェックしてみるか，検索ページで探してみてください。'
);

###############################################################################

$LANG_LOGIN = array(
    1 => 'ログインしてください',
    2 => '申し訳ありませんが，先にログインしてください。',
    3 => 'ログイン',
    4 => '新規登録'
);

$LANG_PDF = array(
    1 => 'The PDF feature has been disabled',
    2 => 'The document provided was not rendered. The document was received but could not be processed.  Please make sure to submit only html formatted documents that have been written to the xHTML standard. Please note that overly complex html documents may not render correctly or at all.The document resulting from your attempt was 0 bytes in length, and has been deleted. If you\'re sure that your document should render fine, please re-submit it.',
    3 => 'Unknown error during PDF generation',
    4 => "No page data was given or you want to use the ad-hoc PDF generation tool below.  If you think you are getting this page\n          in error then please contact the system administrator.  Otherwise, you may use the form below to generate PDF's in an ad-hoc fashion.",
    5 => 'Loading your document.',
    6 => 'Please wait while your document is loaded.',
    7 => 'You may right click the button below and choose \'save target...\' or \'save link location...\' to save a copy of your document.',
    8 => "The path given in the configuration file to the HTMLDoc binary is invalid or this system cannot execute it.  Please contact the site administrator if this problem\n          persists.",
    9 => 'PDF Generator',
    10 => "This is the Ad-hoc PDF Generation tool. It will attempt to convert any URL you give into a PDF.  Please note that some web pages will not render properly with this feature.  This\n           is a limitation of the HTMLDoc PDF generation tool and such errors should not be reported to the administrators of this site",
    11 => 'URL',
    12 => 'Generate PDF!',
    13 => 'The PHP configuration on this server does not allow URLs to be used with the fopen() command.  The system administrator must edit the php.ini file and set allow_url_fopen to On',
    14 => 'The PDF you requested either does not exist or you tried to illegally access a file.'
);

###############################################################################
# trackback

$LANG_TRB = array (
    'trackback'          => 'トラックバック',
    'from'               => 'from',
    'tracked_on'         => 'トラックバック　オン',
    'read_more'          => '続きを読む',
    'intro_text'         => "'%s'について他のサイトでは次のように言及されています:",
    'no_comments'        => 'この記事にはトラックバック・コメントがありません。',
    'this_trackback_url' => 'このエントリのトラックバックURL:',
    'num_comments'       => '%d件のトラックバック',
    'send_trackback'     => 'トラックバック・ピングを送る',
    'preview'            => 'プレビュー',
    'editor_title'       => 'トラックバックを送る',
    'trackback_url'      => 'トラックバックURL',
    'entry_url'          => 'エントリのURL',
    'entry_title'        => 'エントリのタイトル',
    'blog_name'          => 'サイト名',
    'excerpt'            => '概要',
    'truncate_warning'   => '注: 受信したサイト側で概要を切り詰めることがあります',
    'button_send'        => '送信',
    'button_preview'     => 'プレビュー',
    'send_error'         => 'エラー',
    'send_error_details' => 'トラックバックの送信中にエラーが発生しました:',
    'url_missing'        => 'エントリのURL',
    'url_required'       => 'エントリのURLは必ず入力してください。',
    'target_missing'     => 'トラックバックURLがありません',
    'target_required'    => 'トラックバックURLを入力してください',
    'error_socket'       => 'ソケットをオープンできませんでした。',
    'error_response'     => '不明な応答が返されました。',
    'error_unspecified'  => '不明なエラーです。',
    'select_url'         => 'トラックバックURLを選択してください',
    'not_found'          => 'トラックバックURLが見つかりません',
    'autodetect_failed'  => 'コメントを送ろうとした記事のトラックバックURLを見つけられませんでした。URLを下に入力してください。',
    'trackback_explain'  => '以下のリンクからトラックバックを送りたいURLを選択してください。その記事の正しいトラックバックURLを決定します。URLがわかっているなら<a href="%s">自分で入力</a>することもできます。',
    'no_links_trackback' => 'リンクが見つかりません。このエントリにトラックバックを送信できません。',
    'pingback'           => 'ピングバック',
    'pingback_results'   => 'ピングバックの結果',
    'send_pings'         => 'ピングを送信',
    'send_pings_for'     => '"%s"にトラックバック・ピングを送る',
    'no_links_pingback'  => 'リンクが見つかりません。このエントリへのピングバックは送信されませんでした。',
    'pingback_success'   => 'ピングバックを送信しました。',
    'no_pingback_url'    => 'ピングバックURLが見つかりません。',
    'resend'             => '再送',
    'ping_all_explain'   => 'あなたがリンクしたことを相手のサイトに知らせたり(<a href="http://en.wikipedia.org/wiki/Pingback">ピングバック</a>)，ウェブログディレクトリサービスにピングを送ってサイトが更新されたことを知らせたり，誰かのサイトの記事について書いたときに<a href="http://ja.wikipedia.org/wiki/%E3%83%88%E3%83%A9%E3%83%83%E3%82%AF%E3%83%90%E3%83%83%E3%82%AF">トラックバック</a>を送ったりすることができます。',
    'pingback_button'    => 'ピングバック送信',
    'pingback_short'     => '記事のリンク先にピングバックを送信する。',
    'pingback_disabled'  => '(ピングバックは無効です)',
    'ping_button'        => 'ピング送信',
    'ping_short'         => '登録したウェブログサイトにピングを一斉送信する。',
    'ping_disabled'      => '(ピングは無効です)',
    'trackback_button'   => 'トラックバック送信',
    'trackback_short'    => '記事のリンク先にトラックバックを送信する。',
    'trackback_disabled' => '(トラックバックは無効です)',
    'may_take_a_while'   => 'ピングバックやピングの送信には時間がかかることがあります。',
    'ping_results'       => 'ピングの結果',
    'unknown_method'     => '不明なピングメソッドです。',
    'ping_success'       => 'ピングを送信しました。',
    'error_site_name'    => 'サイト名を入力してください。',
    'error_site_url'     => 'サイトのURLを入力してください。',
    'error_ping_url'     => '正しいピングURLを入力してください。',
    'no_services'        => 'ウェブログディレクトリサービスが設定されていません。',
    'services_headline'  => 'トラックバック管理',
    'admin_home'         => '管理画面',
    'new_service'        => '新規作成',
    'service_explain'    => 'ピング送信先のウェブログディレクトリサービスを修正・削除する場合は，編集アイコンをクリックしてください。新しいウェブログディレクトリサービスを作成する場合は，「新規作成」をクリックしてください。',
    'service'            => 'サービス',
    'ping_method'        => 'ピングメソッド',
    'ping_standard'      => '標準ピング',
    'ping_extended'      => '拡張ピング',
    'ping_unknown'       => '(不明なメソッド)',
    'edit_service'       => 'ウェブログディレクトリサービスの編集',
    'trackbacks'         => 'トラックバック',
    'editor_intro'       => '<a href="%s">%s</a>へのトラックバックを準備してください。',
    'editor_intro_none'  => 'トラックバックを準備してください。',
    'trackback_note'     => '記事にトラックバックを送るには，記事一覧でその記事の"' . $LANG24[21] . '"をクリックしてください。 記事に関係のないトラックバックを送るには <a href="%s">ここをクリック</a>。',
    'pingback_explain'   => 'ピングバックするURLを入力してください。ピングバックで他のサイトからリンク が張られたことを自動的に通知されます',
    'pingback_url'       => 'ピングバックURL',
    'site_url'           => 'このサイトのURL',
    'pingback_note'      => '記事へのピングバックを送るには，記事をクリックしてください。"' . $LANG24[21] . '" に関係している記事にピングバックを送るには，<a href="%s">ここをクリック</a>.',
    'pbtarget_missing'   => 'ピングバックURLではありません。',
    'pbtarget_required'  => 'ピングバックURLを入力してください',
    'pb_error_details'   => '次のピングバックの送信中にエラー:',
    'delete_trackback'   => 'トラックバック削除: '
);

###############################################################################
# directory.php

$LANG_DIR = array (
    'title'            => '記事一覧',
    'title_year'       => '%d年の記事一覧',
    'title_month_year' => '%d年%s月の記事一覧',
    'nav_top'          => '記事一覧のトップに戻る',
    'no_articles'      => '記事がありません'
);

################################################################################
# "What's New" Time Strings

$LANG_WHATSNEW = array (
    # This here determines the order of the sentence "No new stories in 2 hrs"
    # order it so it makes sense in your language:
    # %i    item, "Stories"
    # %n    amount, "2", "20" etc
    # %t    time, "2" (weeks)
    # %s    scale, "hrs", "weeks"
    'new_string'  => '新着%i %n件(%t%s)',
    'new_last'    => '(%t%s)',
    # other strings
    'minutes'     => '分',
    'hours'       => '時間',
    'days'        => '日',
    'weeks'       => '週',
    'months'      => 'ヶ月',
    'minute'      => '分',
    'hour'        => '時間',
    'day'         => '日',
    'week'        => '週',
    'month'       => 'ヶ月'
);

$LANG_MONTH = array(
    1 => ' 1月',
    2 => ' 2月',
    3 => ' 3月',
    4 => ' 4月',
    5 => ' 5月',
    6 => ' 6月',
    7 => ' 7月',
    8 => ' 8月',
    9 => ' 9月',
    10 => '10月',
    11 => '11月',
    12 => '12月'
);

$LANG_WEEK = array(
    1 => '日',
    2 => '月',
    3 => '火',
    4 => '水',
    5 => '木',
    6 => '金',
    7 => '土'
);

################################################################################
# Admin - Strings
#
# These are some standard strings used by core functions as well as plugins to
# display adminiatration lists and edit pages

$LANG_ADMIN = array (
    'search'        => '検索',
    'limit_results' => 'リスト',
    'submit'        => '実行',
    'edit'          => '編集',
    'edit_adv'      => 'アドバンストエディタ',
    'admin_home'    => '管理画面',
    'create_new'    => '新規作成',
    'create_new_adv'=> '新規作成(アドバンスト)',
    'enabled'       => '有効にする',
    'title'         => 'タイトル',
    'type'          => 'タイプ',
    'topic'         => '話題',
    'help_url'      => 'ヘルプURL:',
    'save'          => '保存',
    'cancel'        => 'キャンセル',
    'delete'        => '削除',
    'delete_sel'    => '削除選択',
    'copy'          => 'コピー',
    'no_results'    => '- 見つかりませんでした -',
    'data_error'    => '送信データに問題があります。データをチェックしてください',
    'preview'       => 'プレビュー',
    'records_found' => '件数'
);

# Localisation of the texts for the various drop-down menus that are actually
# stored in the database. If these exist, they override the texts from the
# database.

$LANG_commentcodes = array(
    0   => 'コメント有効',
    -1  => 'コメント停止'
);

$LANG_commentmodes = array(
    'flat'      => '一覧',
    'nested'    => '入れ子',
    'threaded'  => 'ツリー',
    'nocomment' => '表示しない'
);

$LANG_cookiecodes = array(
    0       => '受け付けない',
    3600    => '１時間',
    7200    => '２時間',
    10800   => '３時間',
    28800   => '８時間',
    86400   => '１日',
    604800  => '１週間',
    2678400 => '１ヶ月'
);

$LANG_dateformats = array(
    0   => 'デフォルト'
);

$LANG_featurecodes = array(
    0 => '通常の記事',
    1 => '注目記事'
);

$LANG_frontpagecodes = array(
    0 => '該当する話題にだけ表示',
    1 => 'トップページに表示'
);

$LANG_postmodes = array(
    'plaintext' => 'テキスト',
    'html'      => 'HTML'
);

$LANG_sortcodes = array(
    'ASC'  => '古い順に',
    'DESC' => '新しい順に'
);

$LANG_trackbackcodes = array(
    0   => 'トラックバック有効',
    -1  => 'トラックバック停止'
);

?>