<?php
//
// +---------------------------------------------------------------------------+
// | Japanese Mail Plugin for Geeklog - The Ultimate Weblog                    |
// +---------------------------------------------------------------------------+
// | Copyright (C) 2007 mystral-kk - geeklog AT mystral-k DOT net              |
// | Constructed with the Universal Plugin                                     |
// +---------------------------------------------------------------------------+
// |                                                                           |
// | This program is free software; you can redistribute it and/or             |
// | modify it under the terms of the GNU General Public License               |
// | as published by the Free Software Foundation; either version 2            |
// | of the License, or (at your option) any later version.                    |
// |                                                                           |
// | This program is distributed in the hope that it will be useful,           |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of            |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
// | GNU General Public License for more details.                              |
// |                                                                           |
// | You should have received a copy of the GNU General Public License         |
// | along with this program; if not, write to the Free Software Foundation,   |
// | Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.           |
// |                                                                           |
// +---------------------------------------------------------------------------+
//

//define( "DEBUG", 1 );

$langfile = $_CONF['path'] . 'plugins/jpmail/language/' . $_CONF['language'] . '.php';

if ( file_exists( $langfile ) ) {
    include_once $langfile;
} else {
    include_once $_CONF['path'] . 'plugins/jpmail/language/english.php';
}

/*
* Includes jpmail config file
*/

require_once $_CONF['path'] . 'plugins/jpmail/config.php';

// +---------------------------------------------------------------------------+
// | Geeklog Plugin API Implementations                                        |
// +---------------------------------------------------------------------------+

/**
* Returns the items for this plugin that should appear on the main menu
*
* NOTE: this MUST return the url/value pairs in the following format
* $<arrayname>[<label>] = <url>
*
* Universal Plugin:  Uncomment and fill in variables;
* 
* @return    array   Associative array of menu items to be added to menu
*
*/

function plugin_getmenuitems_jpmail() {
//    return $menuitems;
}

/**
* Checks to see if this Plugin uses comments
*
* Geeklog is checking to see if this plugin supports comments, tell it no!
* NOTE: to support comments you must use the same date/time based ID for your
* widget.  In other words, to make primary keys for your plugin you should call
* makesid().  Comments are keyed off of that...it is a limitation on how geeklog
* does comments.
*
* @return   boolean true or false
*
*/

function plugin_commentsupport_jpmail() {
    return false;
}

/**
* Shows the statistics for the plugin on stats.php.  If
* $showsitestats is 1 then we are to only print the overall stats in the 'site
* statistics' box otherwise we show the detailed stats for the plugin
*
* Universal Plugin:  Modify/uncomment use it
*
* @param    int showsitestate   Flag to let us know which stats to get
* @return   string  returns formatted HTML to insert in stats page
*
*/

function plugin_showstats_jpmail( $showsitestats ) {
	$retval = '';
    
	return $retval;
}

/**
* This will put an option for the plugin in the command and control block on moderation.php
*
* Adds the plugin name, icon and link to the command and control block in moderation.php
*
* @return   array   Array containing (plugin name, admin url, url of plugin icon)
*
*/

function plugin_cclabel_jpmail() {
    global $_CONF;

	$pi_name   = ucfirst( 'jpmail' );
	$admin_url = $_CONF['site_admin_url'] . '/plugins/jpmail/index.php';
	$icon_url  = $_CONF['site_admin_url'] . '/plugins/jpmail/images/jpmail.gif';

    return array ( $pi_name, $admin_url, $icon_url );
}

/**
* Returns the administrative option for this plugin
*
* Adds the plugin to the Admin menu
*
* Universal Plugin:  Modify/Uncomment use it
*
* @return   array   Array containing (plugin name, plugin admin url, # of items in plugin or '')
*
*/

function plugin_getadminoption_jpmail() {
	global $_CONF, $LANG_JPML;

	if ( SEC_hasRights( 'jpmail.admin' ) ) {
		$admin_url = $_CONF['site_admin_url'] . '/plugins/jpmail/index.php';
		$num_items = '';
		return array ( $LANG_JPML['jpmail'], $admin_url, $num_items );
	}
}

/*
 * Returns the version for this plugin
 *
 * @return string VersionNo
 */

function plugin_chkVersion_jpmail() {
	global $_JPML_CONF;
	
	return $_JPML_CONF['pi_version'];
}

/**
* Returns the user option for this plugin
*
* Adds the plugin to the user menu
*
* Universal Plugin:  modify/uncomment use it
*
* @return   array   Array containing (plugin name, plugin user url, 0)
*
*/

function plugin_getuseroption_jpmail() {
}

/**
* Upgrade the plugin
*
* Universal Plugin:  modify/uncomment use it
*
* @return   boolean true (= success)
*
*/

function plugin_upgrade_jpmail() {
	global $_CONF, $_TABLES, $_JPML_CONF;

	$result = DB_query( "SELECT pi_version FROM {$_TABLES['plugins']} WHERE (pi_name = 'jpmail')" );
	$A = DB_fetchArray( $result );
	$pi_version = $A['pi_version'];		// Version info stored in database
	
	// Do upgrading
	
// 	switch ($pi_version) {
// 		case '':
// 		break;
// 		
// 		case '':
// 		break;
// 		
// 	}
	
	// Update plugin info
	
	$result = DB_query( "UPDATE {$_TABLES['plugins']} SET pi_version = \"{$_JPML_CONF['pi_version']}\" WHERE (pi_name = 'jpmail')" );
	COM_errorLog( ucfirst( "jpmail" ) . " plugin was successfully updated to version {$_JPML_CONF['pi_version']}." );
	
	return true;
}

/**
* Removes the datastructures for this plugin from the Geeklog database.
* This routine will get called from the Plugin install program if user select De-Install or if Delete is used in the Plugin Editor.
* The Plugin Installer will also call this routine upon and install error to remove anything it has created.
* The Plugin installer will pass the optional parameter which will then double check that plugin has first been disabled. 
* 
* For this plugin, this routine will also remove the Block definition.
* 
* Returns True if all Plugin related data is removed without error
*
* @param    string   $installCheck     Default is blank but if set, check if plugin is disabled first
* 
* @return   boolean True if successful false otherwise
*
*/  

function plugin_uninstall_jpmail( $installCheck = '' ) {
    global $_TABLES, $LANG_JPML;

    // $FEATURES and $TABLES have to be changed accodrding to your plugin
    $pi_name  = 'jpmail';
    $FEATURES = array ( 'jpmail.admin' );
    $TABLES   = array ( 'jpml_rules' );
    
    // Check and see if plugin is still enabled - if so display warning and exit
    if ( $installCheck != '' && DB_getItem( $_TABLES['plugins'], 'pi_enabled', 'pi_name = "' . $pi_name . '"' ) ) {
	    COM_errorLog( "Plugin is installed and enabled.  Disable first if you want to de-install it", 1 );
		$display .= COM_startBlock( $LANG_JPML['warning'] );
		$display .= $LANG_JPML['enabled'];
		$display .= COM_endBlock();
		echo $display;
		return false;
	}
    	
	// Ok to proceed and delete plugin

    // Unregister the plugin with Geeklog
    COM_errorLog( 'Attempting to unregister the jpmail plugin from Geeklog', 1 );
    DB_query( "DELETE FROM {$_TABLES['plugins']} WHERE pi_name = 'jpmail'", 1 );

    // Drop jpmail tables
    foreach ( $TABLES as $table ) {
        $t = $_TABLES["$table"];
        COM_errorLog( "Removing Table $t", 1 );
        DB_query( "DROP TABLE $t", 1 );
    }

    // Remove Security for this plugin
    $grp_id = DB_getItem( $_TABLES['vars'], 'value', "name = '{$pi_name}_gid'" );
    
    COM_errorLog( "Removing $pi_name Admin Group", 1 );
    DB_query( "DELETE FROM {$_TABLES['groups']} WHERE grp_id = $grp_id", 1 );
    DB_query( "DELETE FROM {$_TABLES['vars']} WHERE name = '{$pi_name}_gid'" );
    COM_errorLog( "Removing root users from admin of $pi_name" );
    DB_query( "DELETE FROM {$_TABLES['group_assignments']} WHERE ug_main_grp_id = $grp_id", 1 );
    
    // Remove all the associated features -- access rights
    foreach ( $FEATURES as $feature ) {
        COM_errorLog( "Removing $feature feature and rights to it", 1 );
        $feat_id = DB_getItem( $_TABLES['features'], 'ft_id', "ft_name = '$feature'" );
        DB_query( "DELETE FROM {$_TABLES['access']} WHERE acc_ft_id = $feat_id", 1 );
        DB_query( "DELETE FROM {$_TABLES['features']} WHERE ft_id = $feat_id", 1 );
    }
        
    COM_errorLog( '...success', 1 );
    return true;
}

/**
* Detects encoding based on mb_detect_order(), but WITHOUT using
* mb_detect_encoding()
*
* Charset patterns are borrowed from mbstring emulator included in Nucleus CMS
*/

function JPML_detectEncoding( $str ) {
	global $_CONF;
	
	$mbemu_internals_regex = array (
		'ASCII'      => "[\x01-\x7F]",
		'EUC-JP'     => "[\xA1-\xFE]([\xA1-\xFE])|[\x01-\x7F]|\x8E([\xA0-\xDF])",
		'SJIS'       => "[\x81-\x9F\xE0-\xFC]([\x40-\xFC])|[\x01-\x7F]|[\xA0-\xDF]",
		'JIS'        => "(?:^|\x1B\(\x42)([\x01-\x1A,\x1C-\x7F]*)|(?:\x1B\\$\x42([\x01-\x1A,\x1C-\x7F]*))|(?:\x1B\(I([\x01-\x1A,\x1C-\x7F]*))",
		'UTF-8'      => "[\x01-\x7F]|[\xC0-\xDF][\x80-\xBF]|[\xE0-\xEF][\x80-\xBF][\x80-\xBF]",
		'UTF-16'     => "..",
		'ISO-8859-1' => ".",
	);
	
	$encodings  = mb_detect_order();
	foreach ( $encodings as $encoding ) {
		$encoding = strtoupper( trim( $encoding ) );
		if ( array_key_exists( $encoding, $mbemu_internals_regex ) ) {
			if ( preg_match( '/^(' . $mbemu_internals_regex[$encoding] . ')+$/', $str ) ) {
				return $encoding;
			}
		}
	}
	
	// If none detected, then we return Geeklog's internal encoding
	return strtoupper( $_CONF['default_charset'] );
}

/**
* Converts encoding if necessary
*
* See $_JPML['detect_encoding']
*/

function JPML_convertEncoding( $string, $to_encoding, $from_encoding = '' ) {
	global $_CONF, $_JPML_CONF;
	
	if ( $from_encoding == '' ) {
		if ( $_JPML_CONF['detect_encoding'] == 'default' ) {
			$from_encoding = $_CONF['default_charset'];
		} else if ( $_JPML_CONF['detect_encoding'] == 'auto' ) {
			$from_encoding = JPML_detectEncoding( $string );
		}
	}
	
	if ( strcasecmp( $from_encoding, $to_encoding ) != 0 ) {
		$string = @mb_convert_encoding( $string, $to_encoding, $from_encoding );
	}
	
	return $string;
}

/**
* Returns a string in the quoted printable format
*
* @todo Not tested enough
*/

function JPML_quoted_printable_encode( $str, $max_len = 75 ) {

	if ( !preg_match( '/[^0-9a-z\-\.,:;\?! ]/i', $str ) ) {
		return $str;
	}
	
	$parts = array();
	$part = '';
	$len = strlen( $str );

	for ( $i = 0; $i < $len; $i ++ ) {
		$ch = $str[$i];
		if ( strpos( "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-.,:;?! \t", $ch ) === false ) {
			$ch = sprintf( '=%02x', ord( $ch ) );
		}
		if ( strlen( $part . $ch ) > $max_len ) {
			$part .= '=';
			$parts[] = $part;
			$part = '';
			if ( $ch == ' ' ) {
				$ch = '=20';
			} else if ( $ch == "\t" ) {
				$ch = '=09';
			}
		}

		$part .= $ch;
	}
	
	if ( $part != '' ) {
		$parts[] = $part;
	}
	return implode( "\r\n", $parts );
}

/**
* Returns a matching rule if any, otherwise the default rule
*/

function JPML_getRule( $address ) {
    global $_JPML_CONF, $_TABLES;

	// Look up a matching rule

	$sql = "SELECT * FROM {$_TABLES['jpml_rules']}";
	$result = DB_query( $sql );
	if ( !DB_error() ) {
		while ( ( $A = DB_fetchArray( $result ) ) !== false ) {
			if ( @preg_match( $A['rule'], $address ) ) {
				if ( defined( 'DEBUG' ) ) {
					COM_errorLog( "JPML_getRule: address = \"{$address}\" rule = \"{$A['rule']}\"" );
				}

				return $A;
			}
		}
	}
	
	return $_JPML_CONF['default_rule'];
}

/**
* Undoes an email header converted by COM_emailEscape()
*
* @return  array ( 'comment' => comment, 'address' => address )
*/

function JPML_emailUnEscape( $string, $asSubject = false ) {
	global $_CONF;
	
	// Unfolds a header
	$string = preg_replace( "/(\r\n|\n|\r)[ \t]+/", '', $string );
	
	// Decodes a header
	while ( preg_match( '/=\?([^?]+)\?([bq])\?([^?]+)\?=/i', $string, $M ) ) {
		$charset      = $M[1];
		$encoding     = strtoupper( $M[2] );
		$encoded_part = $M[3];
		if ( $encoding == 'B' && function_exists( 'base64_decode' ) ) {
			$part = base64_decode( $encoded_part );
		} else if ( $encoding == 'Q' && function_exists( 'quoted_printable_decode' ) ) {
			$part = quoted_printable_decode( $encoded_part );
		} else {
			$part = $encoded_part;
			COM_errorLog( "JPML_emailUnEscape: Unknown encoding: {$encoding}" );
		}
		
		// Converts a header into the internal encoding
		if ( strcasecmp( $charset, $_CONF['default_charset'] ) != 0 ) {
			$part = JPML_convertEncoding( $part, $_CONF['default_charset'], $charset );
		}
		
		$string = str_replace( $M[0], $part, $string );
	}
	
	if ( $asSubject ) {
		return $string;
	}
	
	// In case of an email address, we try to split a string into a comment and an
	// address
	
	$string = trim( $string );
	$l_br = strrchr( $string, '<' );
	if ( $l_br !== false && substr( $l_br, -1, 1) == '>' ) {
		$comment = rtrim( substr( $string, 0, strlen( $string ) - strlen( $l_br ) ) );
		$address = substr( $l_br, 1, strlen( $l_br ) - 2 );
	} else {
		$address = $string;
		$comment = '';
	}
	
	return array ( 'comment' => $comment, 'address' => $address );
}

/**
* Encodes the body of a message accoring to a given rule
*/

function JPML_escapeBody( $string, $rule ) {
	global $_CONF, $_JPML_CONF;
	
//	$old_mb_internal_encoding = mb_internal_encoding();
//	mb_internal_encoding( $rule['body_charset'] );
	$string = JPML_convertEncoding( $string, $rule['body_charset'] );
	
	if ( $rule['body_encoding'] == 'B' ) {
		$string = chunk_split(
			base64_encode( $string ), $_JPML_CONF['body_line_length'], "\n"
		);
	} else if ( $rule['body_encoding'] == 'Q' ) {
		$string = JPML_quoted_printable_encode( $string, $_JPML_CONF['body_line_length'] );
	}
	
//	mb_internal_encoding( $old_mb_internal_encoding );

	return $string;
}

/**
* Encodes a string such that it can be used in an email header
*
* @param    string  $string     a header string
* @param    string  $rule       array -- See $_JPML_CONF['default_rule'] in config.php
* @return   string              encoded text (doesn't contain $field_name)
*
*/

function JPML_escapeHeader( $field_name, $field_value, $rule ) {
	global $_CONF, $_JPML_CONF;
	
	$retval = array();
	$old_mb_internal_encoding = mb_internal_encoding();
	mb_internal_encoding( $rule['header_charset'] );
	
	$str = str_replace( array ( "\r\n", "\r", "\n" ), '', $field_value );
	$str = JPML_convertEncoding( $str, $rule['header_charset'] );
	
	$mime_prefix = "=?{$rule['header_charset']}?{$rule['header_encoding']}?";
	$mime_suffix = '?=';
	$len_mime    = strlen( $mime_prefix ) + strlen( $mime_suffix );
	$offset      = strlen( $field_name ) + 2;	// char(2) = ': '
	
	while ( $str != '' ) {
		$len = mb_strlen( $str );
		$cut = 0;
		
		for ( $i = 0; $i < $len; $i ++ ) {
			$part = mb_substr( $str, $i, 1 );
			if ( $rule['header_encoding'] == 'B' ) {
				$encoded_part = base64_encode( $part );
			} else if ( $rule['header_encoding'] == 'Q' ) {
				$encoded_part = JPML_quoted_printable_encode( $part );
			} else {
				$encoded_part = $part;
			}
			if ( strlen( $encoded_part ) + $offset + $len_mime > $_JPML_CONF['header_line_length'] ) {
				$cut = $i - 1;
				break;
			}
		}
		
		if ( $cut == 0 ) {	// Didn't stop in the loop
			$cut = $len;
		}

		$part = mb_substr( $str, 0, $cut );
		if ( $rule['header_encoding'] == 'B' ) {
			$encoded_part = base64_encode( $part );
		} else if ( $rule['header_encoding'] == 'Q' ) {
			$encoded_part = JPML_quoted_printable_encode( $part );
		} else {
			$encoded_part = $part;
		}

		$retval[] = $mime_prefix . $encoded_part . $mime_suffix;
		$offset = 1;	// Skip a TAB
		$str = mb_substr( $str, $cut );
	}
	
	mb_internal_encoding( $old_mb_internal_encoding );
	
	return implode( $_JPML_CONF['header_linebreak'] . "\t", $retval );
}

/**
* Takes a name and an email address and returns a string that vaguely
* resembles an email address specification conforming to RFC(2)822 ...
*
* @param    string  $name       name, e.g. John Doe
* @param    string  $address    email address only, e.g. john.doe@example.com
* @return   string              formatted email address
*
*/

function JPML_formatEmailAddress( $name, $address, $rule ) {
	global $_JPML_CONF;
	
	// 'From' is a dummy and won't be included in the formatted email address
	if ( trim( $name != '' ) ) {
		//Strips '"'
		if ( $name[0] == '"' ) {
			$name = substr( $name, 1, strlen( $name ) - 2);
		}
		
		// Escapes '\\',  '"',  '(',  ')' in comment fields
		$name = str_replace(
			array(   '\\',  '"',  '(',  ')' ),
			array( '\\\\', '\"', '\(', '\)' ),
			$name
		);
		$formatted_name = JPML_escapeHeader( 'From', $name, $rule );

		// Folds the address line
		return $formatted_name . $_JPML_CONF['header_linebreak'] . "\t<" . $address . '>';
	} else {
		return $address;
	}
}

/**
* Sends an email.
*
* @param    string      $to         recipients name and email address
* @param    string      $subject    subject of the email
* @param    string      $message    the text of the email
* @param    string      $from       (optional) sender of the the email
* @param    boolean     $html       (optional) true if to be sent as HTML email
* @param    int         $priority   (optional) add X-Priority header, if > 0
* @param    string      $cc         (optional) other recipients (name + email)
* @param    array       $attach     (optional) file names to be attached
* @return   boolean                 true if successful,  otherwise false
*
* @note Please note that using the $cc parameter will expose the email addresses
*       of all recipients. Use with care.
*
* @todo When $cc is processed as one set of a comment and an email address, not as a list
*
*/

function JPML_mail( $to, $subject, $message, $from = '', $html = false, $priority = 0,
	$cc = '', $attach = array () ) {
	global $_CONF, $_JPML_CONF;

	static $mailobj;
	
	// Remove line-breaks and EOL(\x00)
	$search = array ( "\r", "\n", "\x00" );
	$to      = str_replace( $search, ' ', $to );
	$cc      = str_replace( $search, ' ', $cc );
	$from    = str_replace( $search, ' ', $from );
	$subject = str_replace( $search, ' ', $subject );
	
	// Decide a matching rule baed on the recipient's address
	$temp_to = JPML_emailUnEscape( $to );
	$rule = JPML_getRule( $temp_to['address'] );
	$to = JPML_formatEmailAddress( $temp_to['comment'], $temp_to['address'], $rule );
	
	// Format the sender's address
	if ( empty( $from ) ) {
		$from = JPML_formatEmailAddress(
			$_CONF['site_name'], $_CONF['site_mail'], $rule
		);
	} else {
		$temp_from = JPML_emailUnEscape( $from );
		$from = JPML_formatEmailAddress(
			$temp_from['comment'], $temp_from['address'], $rule
		);
	}
	
	// Formats the subject, cc and message
	$subject = JPML_emailUnEscape( $subject, true );
	$subject = JPML_escapeHeader( 'Subject', $subject, $rule );
	if ( !empty( $cc ) ) {
		$temp_cc = JPML_emailUnEscape( $cc );
		$cc = JPML_formatEmailAddress( $temp_cc['comment'], $temp_cc['address'], $rule );
	}

	$message = JPML_escapeBody( $message, $rule );
	
	// Prepares for PEAR
	if ( $_CONF['have_pear'] === true ) {
		include_once 'Mail.php';
		include_once 'Mail/RFC822.php';
	} else {
		include_once $_CONF['path_pear'] . 'Mail.php';
		include_once $_CONF['path_pear'] . 'Mail/RFC822.php';
	}

	$method = $_CONF['mail_settings']['backend'];

	if ( !isset( $mailobj ) ) {
		if ( ( $method == 'sendmail' ) || ( $method == 'smtp' ) ) {
			$mailobj =& Mail::factory( $method, $_CONF['mail_settings'] );
		} else {
			$method = 'mail';
			$mailobj =& Mail::factory( $method );
		}
	}

	$headers = array ();

	$headers['From'] = $from;
	if ( $method != 'mail' ) {
		$headers['To'] = $to;
	}

	if ( !empty( $cc ) ) {
		$headers['Cc'] = $cc;
	}

	$headers['Date'] = date( 'r' ); // RFC822 formatted date
	if ( $method == 'smtp' ) {
		list( $usec, $sec ) = explode( ' ', microtime() );
		$m = substr( $usec, 2, 5 );
		$headers['Message-Id'] = '<' .  date( 'YmdHis' ) . '.' . $m
							   . '@' . $_CONF['mail_settings']['host'] . '>';
	}

	if ( $html ) {
		$headers['Content-Type'] = 'text/html; charset=' . $rule['body_charset'];
	} else {
		$headers['Content-Type'] = 'text/plain; charset=' . $rule['body_charset'];
	}
	if ( $rule['body_encoding'] == 'Q' ) {
		$headers['Content-Transfer-Encoding'] = 'quoted-printable';
	} else if ( $rule['body_encoding'] == 'B' ) {
		$headers['Content-Transfer-Encoding'] = 'base64';
	} else if ( in_array( $rule['body_charset'], array ( 'ISO-2022-JP', 'ISO-8859-1', 'ASCII'  ) ) ) {
		$headers['Content-Transfer-Encoding'] = '7bit';
	} else {
		$headers['Content-Transfer-Encoding'] = '8bit';
	}

	$headers['Subject'] = $subject;
	if ( $priority > 0 ) {
		$headers['X-Priority'] = $priority;
	}
	$headers['X-Mailer'] = 'jpml-' . $_JPML_CONF['pi_version'];

	if ( defined( 'DEBUG' ) ) {
		$display = COM_siteHeader();
		ob_start();
		var_dump( $headers );
		var_dump( $to );
		var_dump( $message );
		$vars = ob_get_contents();
		$display .= $vars;
		ob_end_clean();
		echo $display;
		exit;
	}
	
	// Sends it
	$retval = $mailobj->send( $to, $headers, $message );
	if( $retval !== true ) {
		COM_errorLog( $retval->toString(), 1 );
	}

	return ( $retval === true ? true : false );
}

/**
* Sends an email.
*
* @param    string      $to         recipients name and email address
* @param    string      $subject    subject of the email
* @param    string      $message    the text of the email
* @param    string      $from       (optional) sender of the the email
* @param    boolean     $html       (optional) true if to be sent as HTML email
* @param    int         $priority   (optional) add X-Priority header, if > 0
* @param    string      $cc         (optional) other recipients (name + email)
* @return   boolean                 true if successful,  otherwise false
*
* @note Please note that using the $cc parameter will expose the email addresses
*       of all recipients. Use with care.
*
*/

function CUSTOM_mail( $to, $subject, $message, $from = '', $html = false, $priority = 0, $cc = '' ) {
	
	$retval = JPML_mail( $to, $subject, $message, $from, $html, $priority, $cc );
	return $retval;
}

?>