<?php

// +---------------------------------------------------------------------------+
// | Japanese Mail Plugin for Geeklog - The Ultimate Weblog                    |
// +---------------------------------------------------------------------------+
// | admin/edit.php                                                            |
// +---------------------------------------------------------------------------+
// | Copyright (C) 2007 mystral-kk - geeklog AT mystral-k DOT net              |
// | Constructed with the Universal Plugin                                     |
// +---------------------------------------------------------------------------+
// |                                                                           |
// | This program is free software; you can redistribute it and/or             |
// | modify it under the terms of the GNU General Public License               |
// | as published by the Free Software Foundation; either version 2            |
// | of the License, or (at your option) any later version.                    |
// |                                                                           |
// | This program is distributed in the hope that it will be useful,           |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of            |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
// | GNU General Public License for more details.                              |
// |                                                                           |
// | You should have received a copy of the GNU General Public License         |
// | along with this program; if not, write to the Free Software Foundation,   |
// | Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.           |
// |                                                                           |
// +---------------------------------------------------------------------------+
//

require_once '../../../lib-common.php';
require_once $_CONF['path_system'] . 'lib-admin.php';

// Only let admin users access this page
if ( !SEC_hasRights( 'jpmail.admin' ) ) {
    // Someone is trying to illegally access this page
    COM_errorLog( "Someone has tried to illegally access the jpmail Admin page.  User id: {$_USER['uid']}, Username: {$_USER['username']}, IP: {$_SERVER['REMOTE_ADDR']}", 1 );
    $display  = COM_siteHeader();
    $display .= COM_startBlock( $LANG_JPML['access_denied'] );
    $display .= $LANG_JPML['access_denied_msg'];
    $display .= COM_endBlock();
    $display .= COM_siteFooter( true );
    echo $display;
    exit;
}

function JPML_createCharsetOptions( $current = '--' ) {
	global $_JPML_CONF;
	
	$retval = '';
	
	foreach ( $_JPML_CONF['charsets'] as $charset ) {
		if ( $charset == $current ) {
			$retval .= "<option selected=\"selected\">{$charset}</option>" . LB;
		} else {
			$retval .= "<option>{$charset}</option>" . LB;
		}
	}
	
	return $retval;
}

function JPML_createEncodingOptions( $current = '' ) {
	global $_JPML_CONF, $LANG_JPML;
	
	$retval = '';
	
	foreach ( $_JPML_CONF['encodings'] as $encoding ) {
		if ( $encoding['name'] == '' ) {
			$encoding['name'] = $LANG_JPML['no_encoding'];
		}
		
		if ( $encoding['value'] == $current ) {
			$retval .= "<option value=\"{$encoding['value']}\" selected=\"selected\">{$encoding['name']}</option>" . LB;
		} else {
			$retval .= "<option value=\"{$encoding['value']}\">{$encoding['name']}</option>" . LB;
		}
	}
	
	return $retval;
}

function JPML_checkCharset( $charset ) {
	global $_JPML_CONF;
	
	return in_array( $charset, $_JPML_CONF['charsets'] );
}

function JPML_checkEncoding( $encoding ) {
	global $_JPML_CONF;
	
	$retval = false;
	
	foreach ( $_JPML_CONF['encodings'] as $enc ) {
		if ( $enc['value'] == $encoding ) {
			$retval = true;
			break;
		}
	}
	
	return $retval;
}

// MAIN

$id = 0;
$err_str = '';

if ( get_magic_quotes_gpc() ) {
	$_GET    = array_map( 'stripslashes', $_GET );
	$_POST   = array_map( 'stripslashes', $_POST );
	$_COOKIE = array_map( 'stripslashes', $_COOKIE );
}

if ( isset( $_POST['submit'] ) && $_POST['submit'] == $LANG_JPML['delete']
	&& isset( $_POST['id'] ) ) {
	$id = COM_applyFilter( $_POST['id'], true );
	$sql = "DELETE FROM {$_TABLES['jpml_rules']} WHERE (id = '{$id}')";
	$result = DB_query( $sql );
	if ( !DB_error() ) {
		$msg = 5;
	} else {
		$msg = 6;
	}

	header( "Location: " . $_CONF['site_admin_url'] . "/plugins/jpmail/index.php?msg={$msg}" );
	exit;
}

if ( isset( $_POST['submit'] ) && $_POST['submit'] == $LANG_JPML['submit'] ) {
	if ( isset( $_POST['id'] ) ) {
		$id = COM_applyFilter( $_POST['id'], true );
		if ( isset( $_POST['rule'] ) ) {
			$rule = $_POST['rule'];
			if ( ( !empty( $rule ) )
			 && isset( $_POST['header_charset'] ) && isset( $_POST['header_encoding'] )
			 && isset( $_POST['body_charset'] ) && isset( $_POST['body_encoding'] ) ) {
				$header_charset  = $_POST['header_charset'];
				$header_encoding = $_POST['header_encoding'];
				$body_charset    = $_POST['body_charset'];
				$body_encoding   = $_POST['body_encoding'];
				
				if ( JPML_checkCharset( $header_charset )
				 && JPML_checkEncoding( $header_encoding )
				 && JPML_checkCharset( $body_charset )
				 && JPML_checkEncoding( $body_encoding ) ) {
					// Add default delimiters
					if ( $rule[0] != substr( $rule, -1, 1 ) ) {
						$rule = '/' . $rule . '/';
					}
					$id              = addslashes( $id );
					$rule            = addslashes( $rule );
					$header_charset  = addslashes( $header_charset );
					$header_encoding = addslashes( $header_encoding );
					$body_charset    = addslashes( $body_charset );
					$body_encoding   = addslashes( $body_encoding );
					
					if ( $id == 0 ) {
						$sql = "INSERT INTO {$_TABLES['jpml_rules']} (rule, header_charset, header_encoding, body_charset, body_encoding) VALUES ('{$rule}', '{$header_charset}', '{$header_encoding}', '{$body_charset}', '{$body_encoding}')";
					} else {
						$sql = "UPDATE {$_TABLES['jpml_rules']} SET rule = '{$rule}', header_charset = '{$header_charset}', header_encoding = '{$header_encoding}', body_charset = '{$body_charset}', body_encoding = '{$body_encoding}' WHERE (id = '{$id}')";
					}
					$result = DB_query( $sql );
					if ( DB_error() ) {
						if ( $id == 0 ) {
							$msg = 2;
						} else {
							$msg = 4;
						}
					} else {
						if ( $id == 0 ) {
							$msg = 1;
						} else {
							$msg = 3;
						}
					}
					header( "Location: " . $_CONF['site_admin_url'] . "/plugins/jpmail/index.php?msg={$msg}" );
					exit;
				}
			}
		}
	}
}

// Displays input screen

if ( isset( $_GET['id'] ) ) {
	$id = COM_applyFilter( $_GET['id'], true );
	$sql = "SELECT * FROM {$_TABLES['jpml_rules']} WHERE (id = '{$id}')";
	$result = DB_query( $sql );
	if ( !DB_error() ) {
		$A = DB_fetchArray( $result );
		$title = $LANG_JPML['title_edit'];
	} else {
		$id = 0;
		$err_str = $LANG_JPML['err_no_data'];
	}
}

if ( $id == 0 ) {
	$A = array (
		'id' => 0, 'rule' => '',
		'header_charset' => '--', 'header_encoding' => 'B',
		'body_charset'   => '--', 'body_encoding'   => ''
	);
	$title = $LANG_JPML['title_new'];
}

$display = COM_siteHeader();
$T = new Template( $_CONF['path'] . 'plugins/jpmail/templates' );
$T->set_file( 'edit', 'edit.thtml' );
$T->set_var( 'site_admin_url', $_CONF['site_admin_url'] );
$T->set_var( 'lang_rule_desc', $LANG_JPML['rule_desc'] );
$T->set_var( 'lang_err_no_data', $err_str );
$T->set_var( 'lang_title', $title );
$T->set_var( 'lang_hdr_rule', $LANG_JPML['hdr_rule'] );
$T->set_var( 'lang_hdr_header_charset', $LANG_JPML['hdr_header_charset'] );
$T->set_var( 'lang_hdr_header_encoding', $LANG_JPML['hdr_header_encoding'] );
$T->set_var( 'lang_hdr_body_charset', $LANG_JPML['hdr_body_charset'] );
$T->set_var( 'lang_hdr_body_encoding', $LANG_JPML['hdr_body_encoding'] );
$T->set_var( 'lang_submit', $LANG_JPML['submit'] );
$T->set_var( 'lang_delete', $LANG_JPML['delete'] );
$T->set_var( 'rule', $A['rule'] );
$T->set_var( 'id', $id );
$T->set_var( 'header_charset_options', JPML_createCharsetOptions( $A['header_charset'] ) );
$T->set_var( 'header_encoding_options', JPML_createEncodingOptions( $A['header_encoding'] ) );
$T->set_var( 'body_charset_options', JPML_createCharsetOptions( $A['body_charset'] ) );
$T->set_var( 'body_encoding_options', JPML_createEncodingOptions( $A['body_encoding'] ) );
$T->parse( 'output', 'edit' );
$display .= $T->finish( $T->get_var( 'output' ) );
$display .= COM_siteFooter( true );
echo $display;

?>