<?php
// functions.php for Theme



// Security measure for forceful browsing -
if (strpos ($_SERVER['PHP_SELF'], 'functions.php') !== false) {
    die ('This file can not be used on its own!');
}
// ----------------------------------------





// Configuration for overriding theme function
$_CONF['r_theme_base'] = 'Revize';

if(file_exists($_CONF['path_themes'] . $_CONF['r_theme_base'] . '/functions.php'))
{
	require_once( $_CONF['path_themes'] . $_CONF['r_theme_base'] . '/functions.php' );
}

// Import configuration file
require_once( 'config.php' );





// Override lib-common.php functions ==============================================
//
// Table Of Contents:
//   *CustomTheme_startBlock
//   *CustomTheme_olderStuff
//   *CustomTheme_whatsNewBlock
//   *CustomTheme_siteHeader
//   *CustomTheme_siteFooter

function CustomTheme_startBlock( $title='', $helpfile='', $template='blockheader.thtml' )
{
    global $_CONF;

    $function = $_CONF['r_theme_base'] . '_startBlock';

    if( function_exists( $function ))
    {
        return $function( $title, $helpfile, $template );
    }
}



function CustomTheme_olderStuff()
{
    global $_CONF;

    $function = $_CONF['r_theme_base'] . '_olderStuff';

    if( function_exists( $function ))
    {
        return $function();
    }
}



function CustomTheme_whatsNewBlock( $help = '', $title = '' )
{
    global $_CONF;

    $function = $_CONF['r_theme_base'] . '_whatsNewBlock';

    if( function_exists( $function ))
    {
        return $function( $help, $title );
    }
}



function CustomTheme_siteHeader( $what = 'menu', $pagetitle = '', $headercode = '' )
{
    global $_CONF;

    $function = $_CONF['r_theme_base'] . '_siteHeader';

    if( function_exists( $function ))
    {
        return $function( $what, $pagetitle, $headercode );
    }
}



function CustomTheme_siteFooter( $rightblock = -1, $CustomTheme = '' )
{
    global $_CONF;

    $function = $_CONF['r_theme_base'] . '_siteFooter';

    if( function_exists( $function ))
    {
        return $function( $rightblock, $CustomTheme );
    }
}
?>