<?php
/*==============================================================================
  File: system/custom/custom_filter.php
  Title: Custom Filter Function
  Description: 渡された変数の内容をカスタムフィルター関数でフィルタリングします。

  Author: Fumito Arakawa as Phize
  Author URI:
    http://geeklog-r.net
    http://phize.net

  License: GNU General Public License(http://www.gnu.org/licenses/gpl.html)

  Table Of Contents:
    ラッパー関数
    フィルター関数
      +レンダリング前
      +記事の保存前
    処理関数
      +内容が空の要素を削除
      +XHTML化
      +HTML・テキストの変換
==============================================================================*/



/*==============================================================================
  ラッパー関数
==============================================================================*/

function CUSTOM_applyFilter($filter, $src, $flag = '')
{
    $retval = $src;

    $function = 'CUSTOM_filter_' . $filter;

    if ( function_exists( $function )) {
        $retval = $function( $src, $flag );
    }

    return $retval;
}



/*==============================================================================
  フィルター関数
    +レンダリング前
    +記事の保存前
==============================================================================*/

/*---------------------------------------
    +レンダリング前
---------------------------------------*/
function CUSTOM_filter_htmlBeforeRendered($src, $flag = '')
{
    global $_CONF;

    $src = CUSTOM_stripEmptyElements($src);

    if ( $_CONF['r_xhtmlize'] ) {
        $src = CUSTOM_xhtmlize($src);
    }

    return $src;
}

/*---------------------------------------
    +記事の保存前
---------------------------------------*/
function CUSTOM_filter_storyBeforeSubmitted($src, $flag = '')
{
    global $_CONF;

    if ( $_CONF['r_transform_text'] ) {
        $src = CUSTOM_transformText($src, $flag);
    }

    return $src;
}



/*==============================================================================
  処理関数
    +内容が空の要素を削除
    +XHTML化
    +HTML・テキストの変換
==============================================================================*/

/*---------------------------------------
    +内容が空の要素を削除
       対象: script, iframe, th, td, textarea, style要素以外の要素
---------------------------------------*/
function CUSTOM_stripEmptyElements($html)
{
    $dest = $html;

    $source = '';
    $regex_comment = '<!(?:--[^-]*-(?:[^-]+-)*?-(?:[^>-]*(?:-[^>-]+)*?)??)*>';

    while ($dest !== $source) {
        $source = $dest;
        $dest = preg_replace('#<(?!script|iframe|th|td|textarea|style)([^"\'>\s]+)(?:\s+[^"\'>]+"[^"]*"|\s+[^"\'>]+\'[^\']*\')*[^>]*>(?:\s|' . $regex_comment . ')*</\1>#i', '', $source);
    }

    return $dest;
}

/*---------------------------------------
    +XHTML化
      *空要素への / の追加。
      *要素名の小文字化
---------------------------------------*/
function CUSTOM_xhtmlize($html)
{
    // Add '/' to empty elemnts
    $html = preg_replace('#<((?:area|base|basefont|br|hr|img|input|isindex|link|meta|param)(?:\s+[^"\'>]*"[^"]*"|\s+[^"\'>]*\'[^\']*\')*[^>]*)(?<!/)>#i', '<$1 />', $html);

    // Transform element's names into lower characters
    $html = preg_replace('#<([a-zA-Z]+[a-zA-Z:]*)((?:\s+[^"\'>]+"[^"]*"|\s+[^"\'>]+\'[^\']*\')*[^>]*)(\s*/)?>#ei', "'<' . strtolower('$1') . '$2$3>'", $html);

    // Replace escaped quotation marks
    $html = preg_replace('#\\\("|\')#', '$1', $html);

    return $html;
}

/*---------------------------------------
    +HTML・テキストの変換
      *素のテキストのp要素化
---------------------------------------*/
function CUSTOM_transformText($src, $flag = 'html')
{

    switch ($flag) {
        case 'plaintext':
            $dest = '';

            if ( trim($src) != '' ) {
                $dest = preg_replace('/\r?\n/', "<br>", $src);
                $dest = '<p>' . $dest . '</p>';
            }

            break;
        default:
            $dest = $src;

            break;
    }

    return $dest;
}
?>
