package G::Infinity;

use G::DB::SDB;
use G::Messenger;

use Socket;
use POSIX qw(WNOHANG);
use IPC::Shareable;

#use strict;
use base qw(Exporter);
use sigtrap;

$| = 1;

our @EXPORT = qw(
		 distribute
		 client
		 distribute_evaluate
);



# Preloaded methods go here.

#::::::::::::::::::::::::::::::
#          Variables
#::::::::::::::::::::::::::::::

use vars qw ( %all_server_info $localtime );

$localtime = scalar localtime();
$localtime =~ s/ /_/g;

#::::::::::::::::::::::::::::::
#           Methods
#::::::::::::::::::::::::::::::

sub distribute {
    # exit program when 
    #  (1) access of server was denied
    #  (2) all servers carry peak CPU load or no servers are running
    #

    print STDERR "updating server information...\n";
    my @server_on = &update_sload();
    if ( $server_on[0] =~ 'accession error' ){
	print STDERR "ERROR: server denied the connection!!\n";
	exit 0;
    }
    print STDERR "finished updating!!\n\n";

    #get_server_info
    foreach my $server_ip ( @server_on ){
	my %server_info = %{sdb_load($server_ip)};
	$all_server_info{$server_ip} = \%server_info;	
    }

    my @server_ips;
    foreach my $server_ip ( keys %all_server_info ){
	next if $all_server_info{$server_ip}->{"load_now"} >= $all_server_info{$server_ip}->{"load_max"};

	my $i = 0;
	while ( $i < $all_server_info{$server_ip}->{"cpu_num"} - $all_server_info{$server_ip}->{"load_now"} ){
	    push( @server_ips, $server_ip );
	    $i++;
	}
    }

    unless ( scalar @server_ips ){
	print STDERR "ERROR: all servers carry peak CPU load or no servers are running!\n";
	exit 0;
    }
    printf STDERR ( "going to use %d CPUs...\n", scalar @server_ips );

    my @returned;
    my $init_sub = shift;
    my $loop_sub = shift;
    my $end_sub = shift;
    my $array_ref = shift;
    my $memory = shift;
    my $eval_counter_max = 5;
    $memory = (32  * 1024 * 1024) unless  $memory;
    my $handle = tie @returned, "IPC::Shareable", undef, { destroy => 1, size => $memory };
############################################################################
#    my $subroutine = $init_sub . ' foreach ( @array ){ ' . $loop_sub . '}' . $end_sub;
    my $subroutine = 
	'my @undone;
        my %evaluate; 
        my $eval_check = 0;
        my $eval_counter = 0;
        my $eval_counter_max = ' . $eval_counter_max . "; " .
	$init_sub . 
	' while(1){
	    $eval_counter++;
	    if($eval_counter==1){
		for (@array){ ' . 
		    $loop_sub .
		    ' $evaluate{$_}=1;
		}
		@undone = &distribute_evaluate(\@array, \%evaluate);
	    }
	    else{
		for (@undone){ ' .
		    $loop_sub .
		    '$evaluate{$_}=1;
		}
		@undone = &distribute_evaluate(\@undone, \%evaluate);
	    }
	    last unless (scalar @undone);
	    last if ($eval_counter==$eval_counter_max);
	} '.
	'if ( scalar @undone ){
            open( UNDONE, "> ./DATA_FROM_GSERVER/" .  $localtime . "/ERROR/" . sprintf("%s_%d.txt", $server_name, $$ ) );
            while(unshift @undone ){ print UNDONE $_, "\n"; }
	    close UNDONE;
        }'.
	$end_sub;
############################################################################
    
    $subroutine =~ s/\\n/backSN/g;
    
    my $sum_of_priority;
    foreach my $server_ip ( @server_ips ){
	$sum_of_priority  += $all_server_info{$server_ip}->{"priority"};
    }
    
    my $array_num = scalar @$array_ref;
    my $quotient_decimal = $array_num / ( $sum_of_priority / 10 );
    my $quotient = sprintf(  "%d", $quotient_decimal );


    my $sum = 0;
    $SIG{CHLD} = sub { while ( waitpid( -1, WNOHANG ) > 0 ) { } };
    foreach my $i ( 0..$#server_ips ){
	my @slice;
	if ( $i == $#server_ips ){
	    @slice = @$array_ref[$sum..$array_num - 1];
	}
	else{
	    my $num = sprintf( "%d",  $quotient * ( $all_server_info{$server_ips[$i]}->{"priority"} / 10 ) );
	    
	    @slice = @$array_ref[$sum..$sum + $num-1];
	    $sum += $num;
	}
	my $pid = fork;
	if ( $pid ){ # parent
	}
	elsif ( defined $pid ){
############################################################################
	    if(0){
	    open( HOGE, "> /home/haya/g-language/test/cebu/distribute/$server_ips[$i]_$$.txt" );
	    foreach my $hoge (@slice){
		print HOGE $hoge, "\n";
	    }
	    close HOGE;
	}
############################################################################
	    my $temp = join( ":::", &client( $server_ips[$i], $subroutine, \@slice ) );
	    my $temp_ref = \$temp;
	    $handle->shlock();
	    $returned[$i] = $temp_ref;
	    $handle->shunlock();
	    exit 0;
	}
    }
    sleep;
    my @solution;
    foreach my $i ( 0..$#server_ips ){
	@solution = ( @solution, split( /:::/, ${$returned[$i]}) );
#	@solution = ( @solution, @{$returned[$i]} );
    }
    IPC::Shareable->clean_up_all;
    return @solution;
}

sub client{ 
    # send subroutine data and array data to the server, and return the result
    # result will be string format, but return the ARRAY data splited by ':::'
    # the data of servers' STDOUT will be in ./DATA_FROM_GSERVER/$localtime/stdout.txt
    #                      STDERR will be in ./DATA_FROM_GSERVER/$localtim/stderr.txt
    # it will work without an array data for the argument
    my ( $server_addr, $subroutine, $array_ref ) = @_;
    my @returned;
    my $port = 18817;
    
    my ( $res_1, $res_t ) = &limitcall(60, \&tcp_connect, SH, $port, $server_addr );

    die "connect timeout" if $res_1;
    die "tcp_connect error" unless $res_t;
    if ( $res_t  eq 'accession error' ){
	print STDERR "ERROR: server denied the connection!!\n";
	exit 0;
    }
#    print STDERR "connected to $server_addr!!\n";
    if ( $array_ref ){
	print SH "client: array data\n"; 
	print SH join( ":::", @$array_ref ), "\n";
	print SH "client: array data finished\n";
    }
    print SH "client: subroutine data\n", $subroutine, "\n";
    print SH "client: subroutine data finished\n";
    
#    passing the $ENV{PWD} data to the server
    print SH "client: pwd data\n", $ENV{PWD}, "\n";
    print SH "client: pwd data finished\n";
    print SH "client: ENDLINE\n";

    system( "mkdir -p ./DATA_FROM_GSERVER/" . $localtime ."/ERROR/" );

    open( STDOUT_FROM_GSERVER, ">> ./DATA_FROM_GSERVER/" .  $localtime . "/" . "stdout.txt" );
    open( STDERR_FROM_GSERVER, ">> ./DATA_FROM_GSERVER/" . $localtime . "/" . "stderr.txt" );

    my $returned;
    while(1){
	my $flag = 0;
	while(<SH>){
	    if (/^server: going to send data.../){
		while(<SH>){
		    if (/^server: ENDLINE/){
			$flag++;
			last;
		    }
		    chomp;
		    s/backSN/\\n/g;
		    $returned = $_;
		}
	    }
	    elsif (/^server: goint to send stderr.../){
		while(<SH>){
		    if (/^server: ENDLINE/){
			$flag++;
			last;
		    }
		    print STDERR_FROM_GSERVER;
		}
	    }
	    else{
		print STDOUT_FROM_GSERVER; 
	    }
	    last if $flag == 2;
	}
	last if $flag == 2;
    }
    close( STDOUT_FROM_GSERVER );
    close( STDERR_FROM_GSERVER );
    limitcall( 60, \&tcp_disconnect , SH);
    return split( /:::/, $returned );
}

sub limitcall($$@){
    my ( $sec, $sub, @arg ) = @_;
    my (@res);

    eval{
	local ( $SIG{ALRM} ) = sub{ die "_LIMITCALL_" };
	alarm $sec;
	@res = &{$sub}(@arg); #= &tcp_connect(@arg)
	alarm 0;
    };
    return $@, @res;
}

sub tcp_connect(*$$){
    local *SOCKETHANDLE;
    my ( $portnum, $server_addr );
    ( *SOCKETHANDLE, $portnum, $server_addr ) = @_;
    my ($inet_addr, $inet_packaddr );
    { #get packed address
	$inet_addr = inet_aton($server_addr) or die "$server_addr: unknown host\n";
	$inet_packaddr = Socket::sockaddr_in( $portnum, $inet_addr );
    }
    my $server_ip = inet_ntoa( $inet_addr );
#    print STDERR "You are connecting to $server_ip...\n";

    { #get port number
	if ($portnum =~ /\D/ ){
	    $portnum = getservbyname( $portnum, 'tcp' ) || return undef;
	}
    }
    my $protonum;
    { #get protocol number
	$protonum = getprotobyname( "tcp" ) || return undef;
    }
    { #make socket
	socket ( SOCKETHANDLE, AF_INET, SOCK_STREAM, $protonum ) || return undef; #Socket::AF_Inet is wrong
    }
    { # connect
	connect ( SOCKETHANDLE, $inet_packaddr ) || ( close(SOCKETHANDLE), return undef );
	my $line = <SH>;
	if ( $line =~ /^Error/ ){
	    print STDERR $line;
	    return "accession error";
	}
    }
    { #buffering off
	select ( (select(SOCKETHANDLE), $| = 1 )[0] );
    }
    return 1;
}

sub update_sload{ 
    #Update all servers' information
    #Exit program if accession denied 
    #if accession was accepted, return ARRAY that contains servers' ip addresses
    #if accession was denied, return 'access error'
    #if there is no data in %server_list, return ARRAY with no data
    
    my %server_list =%{sdb_load("server_list")};
    my @server_on;
    return @server_on unless ( scalar keys %server_list );

    $SIG{CHLD} = sub { while ( waitpid( -1, WNOHANG ) > 0 ) { } };

    my $access_deny;
    my $handle = tie $access_deny, "IPC::Shareable", undef, { destroy => 1, size => 100 };
    foreach my $server_ip ( keys %server_list ){
	if ( $server_list{$server_ip} ){
	    push(@server_on, $server_ip );
	    my $pid = fork;
	    if ( $pid ){ # parent
	    }
	    elsif ( defined $pid ){ # child
		my $port = 18817;
		my ( $res_1, $res_t ) = &limitcall(60, \&tcp_connect, SH, $port, $server_ip );
		die "connect timeout" if $res_1;
		die "tcp_connect error" unless $res_t;
		if ( $res_t eq 'accession error' ){
		    $handle->shlock();
		    $access_deny = 1;
		    $handle->shunlock();
		    exit 0;
		}
		print SH "client: update server load information\n"; 
		while(1){
		    my $flag = 0;
		    while(<SH>){
			if (/^server: ENDLINE/){
			    $flag = 1;
			    last;
			}
		    }
		    last if $flag == 1;
		    limitcall( 60, \&tcp_disconnect , SH);
		}
		exit 0;
	    }
	}
    }
    sleep;

#    IPC::Shareable->clean_up_all;

    return ( 'accession error') if ( $access_deny );
    return @server_on;
}



sub distribute_evaluate{
    my $array_ref = shift;
    my $hash_ref = shift;

    my @undone;
    for my $tmp (@$array_ref){	
	push(@undone, $tmp) unless ($hash_ref->{$tmp}) ;
    }

    return @undone;    
}



1;
