#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2008 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: OverLapping.pm,v 1.1.1.1 2002/04/02 20:25:42 gaou Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#

package G::Seq::OverLapping;

use SubOpt;
use G::Messenger;

use strict;
use base qw(Exporter);
use SelfLoader;

our @EXPORT = qw(
	     over_lapping_finder
	     _over_lapping_printer
);

__DATA__

#::::::::::::::::::::::::::::::
#        Methods Start
#::::::::::::::::::::::::::::::

=head2 over_lapping_finder

  Description:
    This program finds overlapping gene.

  Usage:
    &over_lapping_finder(pointer Genome,  boolean debug);

  Options:
    -output   "f" for file output. "stdout" for STD output.
    -filename output file name.


  Author:
    Koya Mori (mory@g-language.org)

  History:
    20010722-01 initial posting

=cut

sub over_lapping_finder{
    &opt_default(output=>"stdout",filename=>"over_lapping.csv");
    my @args=opt_get(@_);
    
    my $gb=opt_as_gb(shift @args);
    my $output=opt_val("output");
    my $filename=opt_val("filename");
    my $num=1;
    my $tmp;
    my $start;
    my $end;
    my %result;
    my $q;
    my $over;
    my $switch;
    my $type;

    foreach($gb->cds()){
	$over=0;
	$switch=0;
	$tmp=$num-1;
	if($gb->{"CDS$num"}->{start} > $gb->{"CDS$tmp"}->{start} && $gb->{"CDS$num"}->{end} < $gb->{"CDS$tmp"}->{end}){
	    $switch=1;
	    $over=-($gb->{"CDS$num"}->{end}-$gb->{"CDS$num"}->{start}+1);
	    $type="internal";
	}
	elsif($gb->{"CDS$num"}->{direction} eq 'direct' && $gb->{"CDS"."$tmp"}->{direction} eq 'direct'){
	    $start = $gb->{"CDS$num"}->{start};
	    $end = $gb->{"CDS"."$tmp"}->{end};
	    if($start-$end-1<0){
		$switch=1;
		$over=$start-$end-1;
		$type="uni-directional";
	    } 
	}
	elsif($gb->{"CDS$num"}->{direction} eq 'complement' && $gb->{"CDS"."$tmp"}->{direction} eq 'complement'){
	    $start = $gb->{"CDS$num"}->{start};
	    $end = $gb->{"CDS"."$tmp"}->{end};
	    if($start-$end-1<0){
		$switch=1;
		$over=$start-$end-1;
		$type="uni-directional";
	    }
	}
	elsif($gb->{"CDS$num"}->{direction} eq 'direct' && $gb->{"CDS"."$tmp"}->{direction} eq 'complement'){
	    $start = $gb->{"CDS$num"}->{start};
	    $end = $gb->{"CDS"."$tmp"}->{end};
	    if($start-$end-1<0){
		$switch=1;
		$over=$start-$end-1;      
		$type="head-on";
	    }
	}    
	elsif($gb->{"CDS$num"}->{direction} eq 'complement' && $gb->{"CDS"."$tmp"}->{direction} eq 'direct'){
	    $start = $gb->{"CDS$num"}->{start};
	    $end = $gb->{"CDS"."$tmp"}->{end};
	    if($start-$end-1<0){
		$switch=1;
		$over=$start-$end-1;
		$type="end-on";
	    }
	}    
	if($switch==1){
	    $result{$q}{before}="CDS$tmp";
	    $result{$q}{after}="CDS$num";
	    $result{$q}{BeforeStart}=$gb->{"CDS$tmp"}->{start};
	    $result{$q}{BeforeEnd}=$gb->{"CDS$tmp"}->{end};
	    $result{$q}{AfterStart}=$gb->{"CDS$num"}->{start};
	    $result{$q}{AfterEnd}=$gb->{"CDS$num"}->{end};
	    $result{$q}{BeforeDirect}=$gb->{"CDS$tmp"}->{direction};
	    $result{$q}{AfterDirect}=$gb->{"CDS$num"}->{direction};
	    $result{$q}{OverLap}=$over;
	    $result{$q}{type}=$type;
	    $q++;
	}
	$num++;
    }

    if($output eq "f"){
	_over_lapping_printer(\%result,-output=>$output,-filename=>$filename);
    }
    if($output eq "stdout"){
	_over_lapping_printer(\%result,-output=>"stdout");
    }
    return \%result;
}


#over_lapping_printer ver.20010722-01
#scripting by Koya Mori(mory@g-language.org)
#This program prints result of over_lapping_finder.pl.
#&over_lapping_finder(pointer over_lapping_finder,  boolean debug);
sub _over_lapping_printer{
    &opt_default(output=>"stdout",filename=>"over_lapping.csv");
    my @args=opt_get(@_);

    my $result=shift @args;
    my $printer=opt_val("output");
    my $filename=opt_val("filename");
    my $debug=shift;

    
    if($printer eq "f"){
	open(FILE,">$filename");
	foreach(sort{$a <=> $b} keys(%$result)){
	    print FILE "$$result{$_}{before},$$result{$_}{after},$$result{$_}{BeforeStart},$$result{$_}{BeforeEnd},$$result{$_}{AfterStart},$$result{$_}{AfterEnd},$$result{$_}{OverLap},$$result{$_}{type},$$result{$_}{BeforeDirect},$$result{$_}{AfterDirect}\n";
	}   
	print FILE "\n\n";
	close(FILE);
    }
    else{
	foreach(sort{$a <=> $b} keys(%$result)){
	    &msg_send("$$result{$_}{before}\t$$result{$_}{after}\t$$result{$_}{BeforeStart}..$$result{$_}{BeforeEnd}\t$$result{$_}{AfterStart}..$$result{$_}{AfterEnd}\t$$result{$_}{OverLap}\t$$result{$_}{type}\t$$result{$_}{BeforeDirect}\t$$result{$_}{AfterDirect}\n");
	}
    }
}


sub DESTROY {
    my $self = shift;
}

1;
__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

G::Seq::OverLapping - Perl extension for blah blah blah

=head1 SYNOPSIS

  use G::Seq::OverLapping;
  blah blah blah

=head1 DESCRIPTION

Stub documentation for G::Seq::OverLapping was created by h2xs. It looks like the
author of the extension was negligent enough to leave the stub
unedited.

Blah blah blah.

=head1 AUTHOR

A. U. Thor, a.u.thor@a.galaxy.far.far.away

=head1 SEE ALSO

perl(1).

=cut
