#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2011 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: Graph.pm,v 1.2 2002/05/27 19:37:55 gaou Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#

package G::Tools::Graph;

use SubOpt;
use G::Messenger;

use strict;
use base qw(Exporter);
use autouse 'Chart::Graph'=>qw(gnuplot);
use SelfLoader;

our @EXPORT = qw(
		 _UniMultiGrapher
		 grapher
);

__DATA__

#::::::::::::::::::::::::::::::
#        Methods Start
#::::::::::::::::::::::::::::::


=head2 grapher

  Name: grapher   -   graphs given data

  Description:
    This method creates a two dimensional graph (line or scatterplot) with gnuplot.
    Multiple data references can be used.
    Options follow that of Chart::Graph.

  Usage:
   grapher(\@x-axis, \@data1, \@data2, ...);

  Options:
   -x                  name of x axis (default: x)
   -y                  name of y axis (default: y)
   -x1, -x2, ..., x$i  title of graph data$i (default: x$i)
   -filename           outfile name   (default: graph.png)
   -style              style of graph (default: lines)
   -type               type of data (default: columns)

  Author: 
    Kazuharu Arakawa (gaou@sfc.keio.ac.jp)

  History:
   20071106-01 interface changed to grapher()
   20010906-01 initial posting as _UniMultiGrapher

=cut

sub _UniMultiGrapher{
    grapher(@_, -output=>"g");
}

sub grapher {
    &opt_default(x=>"x", y=>"y", title=>"graph", 
		 filename=>"graph.png", type=>"columns",
 		 style=>"lines", grapher=>"gnuplot", output=>"show");

    my @args = opt_get(@_);
    my $filename = opt_val("filename");
    my $output = opt_val("output");
    my $grapher = opt_val("grapher");

    if ($grapher eq 'gnuplot' && 'MSWin32' ne $^O){
	my $ref_y = shift @args;
	my @command = ({"title" => opt_val("title"),
			    "output file" => "graph/$filename",
			    "x-axis label" => opt_val("x"),
			"y-axis label" => opt_val("y")}, );
	my $i = 1;
	foreach my $ref_x (@args){
	    my $title = opt_val("x$i");
	    $title = "x$i" if ($title eq '');
	    
	    push (@command,
		  [{"title" => $title,
		    "style" => opt_val("style"),
		    "type" => opt_val("type")},
		          $ref_y, $ref_x, ]
		  );
	    $i ++;
	}
    
	gnuplot(@command);
    }else{
	require GD::Graph::lines;
	my $graph = GD::Graph::lines->new(640, 480);
	my $skip = int(scalar(@{$args[0]}) / 10);
	   $graph->set(
		       x_label => opt_val("x"),
		       y_label => opt_val("y"),
		       title => opt_val("title"),
		              x_label_skip => $skip,
		       );
	my $i = 1;
	my @legend;
	while(opt_val("x$i")){
	    push (@legend, opt_val("x$i"));
	    $i ++;
	}
	$graph->set_legend(@legend) if (scalar(@legend));
	my $gd = $graph->plot(\@args);

	open(IMG, '>graph/' . $filename) or die $!;
	binmode IMG;
	print IMG $gd->png;
	close(IMG);
    }

    msg_gimv("graph/$filename") if ($output eq 'show');
}

1;
