/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

/************************************

	machine dependent
	task system

*************************************/

#ifndef ___M_TASK_H___
#define ___M_TASK_H___

#ifdef __cplusplus
typedef	class LSimpleThread *	THREAD;
typedef	class LSemaphore *		SEM;
#else
typedef	void *	THREAD;
typedef	void *	SEM;
#endif

#define THREAD_BLOCK_SIZE	1000

typedef struct rw_lock {
	SEM		lock;
	int		cnt;
} RW_LOCK;

typedef struct sw_hash {
	struct sw_hash *		next;
	unsigned int		key;
	THREAD			thread;
} SW_HASH;

typedef union thread_block {
	union thread_block *	next;
	RW_LOCK			rw_lock;
	SW_HASH			sw_hash;
} THREAD_BLOCK;

typedef struct fifo_el {
	struct fifo_el *	next;
} FIFO_EL;

typedef struct fifo {
	SEM			lock;
	int			length;
	struct fifo_el *	head;
	struct fifo_el *	tail;
} FIFO;


typedef void * TKEY;
int GET_TKEY(TKEY);
int _create_task(void (*func)(), int data, int priority, char *name);

#define create_task(func,data,pri) _create_task(func,data,pri,#func)

#define set_t_msg(msg)
#define set_t_msg2(msg)


#endif
