/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<stdlib.h>
#include	<stdio.h>
#include	"memory_debug.h"
#include	"v.h"
#include	"machine/msequence.h"

//001218 yoshida
#include "gbview.h"
//end

typedef struct v_select_box_s {
	VIMAGE * 	obj;
	int		select_flag;
	VPOINT		select[2];
} V_SELECT_BOX_S;

void clear_line(VIMAGE * obj,VPOINT st,VPOINT end,int mode);

typedef struct v_set_image_s{
	VERROR * err;
	VOBJECT * obj;
	int x;
	int y;
	int w;
	int h;
}V_SET_IMAGE_S;

int _v_set_image(V_SET_IMAGE_S *v)
{
VERROR * err = v->err;
VOBJECT * obj = v->obj;
int x = v->x;
int y = v->y;
int w = v->w;
int h = v->h;

int size1,size2;
long * buf_32;
short * buf_16;
char * buf_8;
int i,j,minh;
int pixelbits;
char * dib;

HBITMAP hbm;
BITMAPINFO info;
HDC hdc;

	pixelbits = obj->header.win->d->gb2m_map.pixel_bits;

	if ( h != obj->vimage.h || w != obj->vimage.w )
		obj->vimage.select_flag = 0;
	size1 = obj->vimage.w*obj->vimage.h;
	size2 = w*h;
	minh = h < obj->vimage.h ? h : obj->vimage.h;
	switch ( pixelbits ) {
	case 32:
		if ( size1 < size2 )
			buf_32 = d_re_alloc(obj->vimage.buf_32,size2*
					sizeof(long));
		else	buf_32 = obj->vimage.buf_32;
		if ( w < obj->vimage.w ) {
			for ( i = 1 ; i < minh ; i ++ )
				for ( j = 0 ; j < w ; j ++ )
					buf_32[i*w+j] 
						= buf_32[i*obj->vimage.w+j];
		}
		else if ( w > obj->vimage.w ) {
			for ( i = minh-1 ; i >= 0 ; i -- )
				for ( j = obj->vimage.w-1;
						j >= 0;
						j -- )
					buf_32[i*w+j] 
						= buf_32[i*obj->vimage.w+j];
		}
		if ( size1 > size2 )
			buf_32 = d_re_alloc(buf_32,size2*sizeof(long));
		obj->vimage.buf_32 = buf_32;
		break;
	case 16:
		if ( size1 < size2 )
			buf_16 = d_re_alloc(obj->vimage.buf_16,size2*
					sizeof(long));
		else	buf_16 = obj->vimage.buf_16;
		if ( w < obj->vimage.w ) {
			for ( i = 1 ; i < minh ; i ++ )
				for ( j = 0 ; j < w ; j ++ )
					buf_16[i*w+j] 
						= buf_16[i*obj->vimage.w+j];
		}
		else if ( w > obj->vimage.w ) {
			for ( i = minh-1 ; i >= 0 ; i -- )
				for ( j = obj->vimage.w-1;
						j >= 0;
						j -- )
					buf_16[i*w+j] 
						= buf_16[i*obj->vimage.w+j];
		}
		if ( size1 > size2 )
			buf_16 = d_re_alloc(buf_16,size2*sizeof(long));
		obj->vimage.buf_16 = buf_16;
		break;
	case 8:
		if ( size1 < size2 )
			buf_8 = d_re_alloc(obj->vimage.buf_8,size2*
					sizeof(long));
		else	buf_8 = obj->vimage.buf_8;
		if ( w < obj->vimage.w ) {
			for ( i = 1 ; i < minh ; i ++ )
				for ( j = 0 ; j < w ; j ++ )
					buf_8[i*w+j] 
						= buf_8[i*obj->vimage.w+j];
		}
		else if ( w > obj->vimage.w ) {
			for ( i = minh-1 ; i >= 0 ; i -- )
				for ( j = obj->vimage.w-1;
						j >= 0;
						j -- )
					buf_8[i*w+j] 
						= buf_8[i*obj->vimage.w+j];
		}
		if ( size1 > size2 )
			buf_8 = d_re_alloc(buf_8,size2*sizeof(long));
		obj->vimage.buf_8 = buf_8;
		break;
	default:
		er_panic("v_set_image");
	}
	obj->vimage.w = w;
	obj->vimage.h = h;
	obj->vimage.x = x;
	obj->vimage.y = y;
	obj->vimage.w_border = w;

/*
	obj->vimage.ximage->width = w;
	obj->vimage.ximage->height = h;
	obj->vimage.ximage->xoffset = 0;
	
	obj->vimage.ximage->bytes_per_line = w*sizeof(long);
	err->err1 = E_OK;
*/
	if (obj->vimage.ximage!=NULL) DeleteObject(obj->vimage.ximage);
	info.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	info.bmiHeader.biPlanes = 1;
	info.bmiHeader.biBitCount = pixelbits;
	info.bmiHeader.biCompression = BI_RGB;
	info.bmiHeader.biSizeImage = 0;
	info.bmiHeader.biXPelsPerMeter = 0;
	info.bmiHeader.biYPelsPerMeter = 0;
	info.bmiHeader.biClrUsed = 0;
	info.bmiHeader.biClrImportant = 0;
	info.bmiHeader.biWidth = w;
	info.bmiHeader.biHeight = -h;
	
	hdc = GetDC(obj->vimage._h.win->w);
	hbm = CreateDIBSection( hdc,&info,DIB_RGB_COLORS, &(obj->vimage.dib_buffer), NULL, 0);
	
	dib=obj->vimage.dib_buffer;
	if (dib)
	{
		switch(pixelbits){
		case 8:
			{
				char *buf=obj->vimage.buf_8;
				int bpl=w; bpl=(bpl+3)/4*4;
				for(y=0;y<h;y++)
				{
					int x=0;
					char *dest=dib+bpl*y;
					char *src=buf+w*y;
					for(x=0;x<w;x++)
					{
						*dest++ = *src++;
					}
				}
			}
			break;
		case 16:
			{
				short *buf=obj->vimage.buf_16;
				int bpl=2*w; bpl=(bpl+3)/4*4;
				for(y=0;y<h;y++)
				{
					int x=0;
					short *dest=(short*)(dib+bpl*y);
					short *src= (buf+w*y);
					for(x=0;x<w;x++)
					{
/*						*dest = 
							(((*src) & 0x1f) << 10) |
							(((*src >> 5) & 0x1f) << 5) |
							((*src >> 10) & 0x1f)  ;
*/
						*dest = 
							(((*src >> 1) & 0x1f)) << 11 |
							(((*src >> 6) & 0x1f) << 6) |
							(((*src >> 11) & 0x1f) << 1) ;

//						*dest++ = *src++;

						dest++;src++;
					}
				}
			}
			break;
		case 32:
			{
				long *buf=obj->vimage.buf_32;
				int bpl=4*w;
				for(y=0;y<h;y++)
				{
					int x=0;
					char *dest=(char *)dib+bpl*y;
					long *src=buf+w*y;
					// memcpy(dib+bpl*y, (char*)(buf+w*y), w*4);
					for(x=0;x<w;x++)
					{
						long l=*src++;
						dest[0]=(char)(l>>16);
						dest[1]=(char)((l>>8)&0xff);
						dest[2]=(char)(l&0xff);
						dest+=4;
					}
				}
			}

		}
	}

	if (obj->vimage.ximage!=NULL) DeleteObject(obj->vimage.ximage);
	obj->vimage.ximage = hbm;
	ReleaseDC(obj->vimage._h.win->w,hdc);
	err->err1 = E_OK;
	return 0;
}
/*
void _v_set_image(V_SET_IMAGE_S *v)
{
VERROR * err = v->err;
VIMAGE * vimage = v->vimage;
int x = v->x;
int y = v->y;
int w = v->w;
int h = v->h;

int size1,size2;
long * buf1, *buf2;
long *buf;
int i,j;
int minh,minw;
HBITMAP hbm;
BITMAPINFO info;
HDC hdc;
HWND hwnd;

char * dib;
		
	if ( h != vimage->h || w != vimage->w )
		vimage->select_flag = 0;
	
	size1 = vimage->w*vimage->h;
	size2 = w*h;
		
	minh = h < vimage->h ? h : vimage->h;
	minw = w < vimage->w ? w : vimage->w;

	if ( size1 < size2 ){
		buf = d_re_alloc(vimage->buf,size2*sizeof(long));
	}
	else{
		buf = vimage->buf;
	}
	if ( w < vimage->w ) {
		for ( i = 1 ; i < minh ; i ++ ){
			for ( j = 0 ; j < w ; j ++ ){
				buf[i*w+j] = buf[i*vimage->w+j];
			}
		}
	}
	else if ( w > vimage->w ) {
		for ( i = minh-1 ; i >= 0 ; i -- ){
			for ( j = vimage->w-1; j >= 0; j -- ){
				buf[i*w+j] = buf[i*vimage->w+j];
			}
		}
	}

	vimage->buf = buf;

	vimage->w = w;
	vimage->h = h;
	vimage->x = x;
	vimage->y = y;
	
	if (vimage->ximage!=NULL) DeleteObject(vimage->ximage);
	info.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	info.bmiHeader.biPlanes = 1;
	info.bmiHeader.biBitCount = 24;
	info.bmiHeader.biCompression = BI_RGB;
	info.bmiHeader.biSizeImage = 0;
	info.bmiHeader.biXPelsPerMeter = 0;
	info.bmiHeader.biYPelsPerMeter = 0;
	info.bmiHeader.biClrUsed = 0;
	info.bmiHeader.biClrImportant = 0;
	info.bmiHeader.biWidth = w;
	info.bmiHeader.biHeight = -h;
	
	hdc = GetDC(vimage->_h.win->w);
	hbm = CreateDIBSection( hdc,&info,DIB_RGB_COLORS, &(vimage->dib_buffer), NULL, 0);
	
	dib=vimage->dib_buffer;
	if (dib)
	{
		long *buf=vimage->buf;
		int bpl=3*w; bpl=(bpl+3)/4*4;
		for(y=0;y<h;y++)
		{
			int x=0;
			char *dest=dib+bpl*y;
			long *src=buf+w*y;
			for(x=0;x<w;x++)
			{
				long l=*src++;
				dest[0]=(l>>16);
				dest[1]=(l>>8)&0xff;
				dest[2]=l&0xff;
				dest+=3;
			}
		}
	}

	if (vimage->ximage!=NULL) DeleteObject(vimage->ximage);
	vimage->ximage = hbm;
	ReleaseDC(vimage->_h.win->w,hdc);
	err->err1 = E_OK;

}

*/

void v_set_image(VERROR * err,VOBJECT * obj,int x,int y,int w,int h)
{
	V_SET_IMAGE_S v;
	v.err = err;
	v.obj = obj ;
	v.x = x;
	v.y = y;
	v.w = w;
	v.h = h;
	ms_do (_v_set_image, &v, "v_set_image");
}

int
_v_redraw_image(void * arg)
{
	VIMAGE * vi;
	char *dib;
	HDC hdc;
	HDC memDC;
	BOOL bPaint=TRUE;
	HBITMAP obmp;
	VOBJECT *obj;

	int x;
	int y;
	int w;
	int h;

	obj = (VOBJECT *)arg;
	vi = &(obj->vimage);
	
	dib=vi->dib_buffer;
	
	x=vi->x;
	y=vi->y;
	w=vi->w;
	h=vi->h;

	if (dib)
	{
		VERROR err;

		V_SET_IMAGE_S v;
		v.err = &err;
		v.obj = obj;
		v.w = vi->w;
		v.h = vi->h;
		v.x = x;
		v.y = y;

		_v_set_image(&v);

		hdc = GetDC(vi->_h.win->w);
		memDC = CreateCompatibleDC(hdc);
		obmp = SelectObject(memDC,vi->ximage);
		
		BitBlt(ghBufferDC,0,0,w,h,memDC,0,0,SRCCOPY);
		BitBlt(hdc,0,0,w,h,ghBufferDC,0,0,SRCCOPY);
		ReleaseDC(vi->_h.win->w,hdc);

		SelectObject(memDC,obmp);
		DeleteObject(memDC);
	}
	return 0;
}

void v_redraw_image(VOBJECT *obj){
	ms_do(_v_redraw_image, (void *)obj, "v_redraw");	
}

v_image_handler(VOBJECT * obj,int cmd)
{
	switch ( cmd ) {
	case VE_REDRAW:
		v_redraw_image(obj);
		break;
	case VE_BUTTON:
		break;
	default:
		fprintf(stderr,"v_image::unsupport cmd %i\n",cmd);
	}
}

typedef struct v_create_image_s {
	VERROR *	err;
	VOBJECT *	ret;

	VWINDOW *	win;
	int		x;
	int 		y;
	int		w;
	int		h;
} V_CREATE_IMAGE_S;

int _v_create_image(V_CREATE_IMAGE_S *v)
{
//VOBJECT *v_create_image(VERROR * err,VWINDOW *win,int x,int y,int w,int h)
//{
HBITMAP		hbm;
BITMAPINFO	info;
VOBJECT *	obj;
VWINDOW *	win;
int			x;
int			y;
int			w;
int			h;
HDC			hdc;
int			buf_alloc_size;

	win = v->win;
	x = v->x;
	y = v->y;
	w = v->w;
	h = v->h;

	obj = d_alloc(sizeof(VIMAGE),316);
	memset(obj, 0, sizeof(VIMAGE));
	obj->vimage.ximage=NULL;
	info.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	info.bmiHeader.biPlanes = 1;
	info.bmiHeader.biBitCount = win->d->gb2m_map.pixel_bits;
	info.bmiHeader.biCompression = BI_RGB;
	info.bmiHeader.biSizeImage = 0;
	info.bmiHeader.biXPelsPerMeter = 0;
	info.bmiHeader.biYPelsPerMeter = 0;
	info.bmiHeader.biClrUsed = 0;
	info.bmiHeader.biClrImportant = 0;
	info.bmiHeader.biWidth = w;
	info.bmiHeader.biHeight = -h;
	hdc = GetDC(win->w);
	hbm = CreateDIBSection( hdc,&info,DIB_RGB_COLORS, &(obj->vimage.dib_buffer), NULL, 0);
	ReleaseDC(v->win->w,hdc);
	
	buf_alloc_size = (win->d->gb2m_map.pixel_bits/8)*w*h;
	switch(win->d->gb2m_map.pixel_bits){
	case 32:
		obj->vimage.buf_32 = (long*)d_alloc(buf_alloc_size, 317);
		memset(obj->vimage.buf_32, 0, buf_alloc_size);
		break;
	case 16:
		obj->vimage.buf_16 = (short*)d_alloc(buf_alloc_size, 317);
		memset(obj->vimage.buf_16, 0, buf_alloc_size);
		break;
	case 8:
		obj->vimage.buf_8 = (char*)d_alloc(buf_alloc_size, 317);
		memset(obj->vimage.buf_8, 0, buf_alloc_size);
		break;
	}
	

	obj->vimage.select_flag = 0;
	obj->vimage.ximage = hbm;
	obj->vimage.w = w;
	obj->vimage.h = h;
	obj->vimage.x = x;
	obj->vimage.y = y;
	obj->vimage.w_border = w;
	obj->header.type = VT_IMAGE;
	obj->header.handler = v_image_handler;
	obj->header.win = win;
	obj->header.next = win->obj_list;
	obj->header.win->gc=NULL;
	v->win->obj_list = obj;
	v->err->err1 = E_OK;

//unlock_task(env.wf_lock,"v_create_image");
	return (int)obj;
}

VOBJECT *v_create_image(VERROR * err,VWINDOW *win,int x,int y,int w,int h)
{
	V_CREATE_IMAGE_S v;
	v.err = err;
	v.win = win;
	v.x = x;
	v.y = y;
	v.w = w;
	v.h = h;
	return (VOBJECT *)ms_do(_v_create_image,(void*)&v, "v_create_image");
}

/*
typedef struct v_set_image_s
{
	VERROR * err,VOBJECT * obj,int x,int y,int w,int h
}V_SET_IMAGE_S;
*/
/*
void v_set_image(VERROR * err,VOBJECT * obj,int x,int y,int w,int h)
{
int size1,size2;
long * buf;
int i,j,minh;
HBITMAP hbm;
BITMAPINFO info;
HDC hdc;
HWND hwnd;

char * dib;

//lock_task(env.wf_lock);

	if ( h != obj->vimage.h || w != obj->vimage.w )
		obj->vimage.select_flag = 0;

	size1 = obj->vimage.w*obj->vimage.h;
	size2 = w*h;
	minh = h < obj->vimage.h ? h : obj->vimage.h;
	if ( size1 < size2 )
		buf = d_re_alloc(obj->vimage.buf,size2*sizeof(long));
	else	buf = obj->vimage.buf;
	if ( w < obj->vimage.w ) {
		for ( i = 1 ; i < minh ; i ++ )
			for ( j = 0 ; j < w ; j ++ )
				buf[i*w+j] = buf[i*obj->vimage.w+j];
	}
	else if ( w > obj->vimage.w ) {
		for ( i = minh-1 ; i >= 0 ; i -- )
			for ( j = obj->vimage.w-1;
					j >= 0;
					j -- )
				buf[i*w+j] = buf[i*obj->vimage.w+j];
	}
	if ( size1 > size2 )
		buf = d_re_alloc(buf,size2*sizeof(long));

	obj->vimage.buf = buf;
	obj->vimage.w = w;
	obj->vimage.h = h;
	obj->vimage.x = x;
	obj->vimage.y = y;

	if (obj->vimage.ximage!=NULL) DeleteObject(obj->vimage.ximage);
	info.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	info.bmiHeader.biPlanes = 1;
	info.bmiHeader.biBitCount = 24;
	info.bmiHeader.biCompression = BI_RGB;
	info.bmiHeader.biSizeImage = 0;
	info.bmiHeader.biXPelsPerMeter = 0;
	info.bmiHeader.biYPelsPerMeter = 0;
	info.bmiHeader.biClrUsed = 0;
	info.bmiHeader.biClrImportant = 0;
	info.bmiHeader.biWidth = w;
	info.bmiHeader.biHeight = -h;
	hwnd=obj->header.win->w;
	hdc = GetDC(hwnd);
	hbm = CreateDIBSection( hdc,&info,DIB_RGB_COLORS, &(obj->vimage.dib_buffer), NULL, 0);

	dib=obj->vimage.dib_buffer;
	if (dib)
	{
		long *buf=obj->vimage.buf;
		int bpl=3*w; bpl=(bpl+3)/4*4;
		for(y=0;y<h;y++)
		{
			int x=0;
			char *dest=dib+bpl*y;
			long *src=buf+w*y;
			for(x=0;x<w;x++)
			{
				long l=*src++;
				dest[0]=(l>>16);
				dest[1]=(l>>8)&0xff;
				dest[2]=l&0xff;
				dest+=3;
			}
		}
	}

	if (obj->vimage.ximage!=NULL) DeleteObject(obj->vimage.ximage);
	obj->vimage.ximage = hbm;
	ReleaseDC(hwnd,hdc);

	err->err1 = E_OK;

//unlock_task(env.wf_lock,"v_set_image");
}
*/
int
v_image_minrect(VRECT * r,VOBJECT * obj)
{
	r->tl.x = obj->vimage.x;
	r->tl.y = obj->vimage.y;
	r->br.x = obj->vimage.x + obj->vimage.w;
	r->br.y = obj->vimage.y + obj->vimage.h;
	return 0;
}

void
clear_line(VIMAGE * obj,VPOINT st,VPOINT end,int mode)
{
HBITMAP old;
HDC hdc,memDC;
int length;
VPOINT pt;
int w,h;

	if ( st.x == end.x )
	{
		if ( end.y < st.y ) 
		{
			pt = st;
			st = end;
			end = pt;
		}
		length = end.y - st.y + 1;
		w = 1;
		h = length;
	}
	else if ( st.y == end.y ) 
	{
		if ( end.x < st.x ) 
		{
			pt = st;
			st = end;
			end = pt;
		}
		length = end.x - st.x + 1;
		w = length;
		h = 1;
	}
	else	
		er_panic("clear_line");

	if(mode)
	{
		MoveToEx(ghBufferDC,st.x,st.y,NULL);
		LineTo(ghBufferDC,end.x,end.y);
	}
	else
	{
		RECT rt;
		hdc = GetDC(ghWnd);
		GetClientRect(ghWnd,&rt);
		memDC = CreateCompatibleDC(hdc);
		old = SelectObject(memDC,obj->ximage);
		PatBlt(ghBufferDC,st.x,st.y,w,h,WHITENESS);
		BitBlt(ghBufferDC,st.x,st.y,w,h,memDC,st.x,st.y,SRCCOPY);
		SelectObject(memDC,old);
		DeleteDC(memDC);
		ReleaseDC(ghWnd,hdc);
	}
}

int
_v_select_box(V_SELECT_BOX_S * v)
{
VPOINT st,end;
	if ( v->obj->select_flag ) {
		st = end = v->obj->select[0];
		end.x = v->obj->select[1].x;
		clear_line(v->obj,st,end,0);
		st = end;
		end = v->obj->select[1];
		clear_line(v->obj,st,end,0);
		st = end;
		end.x = v->obj->select[0].x;
		clear_line(v->obj,st,end,0);
		st = end;
		end = v->obj->select[0];
		clear_line(v->obj,st,end,0);
	}
	if ( v->select_flag ) {
		v->obj->select_flag = 1;
		st = v->select[0];
		if ( st.x < v->obj->x )
			st.x = v->obj->x;
		if ( st.x >= v->obj->x + v->obj->w )
			st.x = v->obj->x + v->obj->w - 1;
		if ( st.y < v->obj->y )
			st.y = v->obj->y;
		if ( st.y >= v->obj->y + v->obj->h )
			st.y = v->obj->y + v->obj->h - 1;
		end = v->select[1];
		if ( end.x < v->obj->x )
			end.x = v->obj->x;
		if ( end.x >= v->obj->x + v->obj->w )
			end.x = v->obj->x + v->obj->w - 1;
		if ( end.y < v->obj->y )
			end.y = v->obj->y;
		if ( end.y >= v->obj->y + v->obj->h )
			end.y = v->obj->y + v->obj->h - 1;
		v->obj->select[0] = st;
		v->obj->select[1] = end;
		end = st;
		end.x = v->obj->select[1].x;

		clear_line(v->obj,st,end,1);
		st = end;
		end = v->obj->select[1];
		clear_line(v->obj,st,end,1);
		st = end;
		end.x = v->obj->select[0].x;
		clear_line(v->obj,st,end,1);
		st = end;
		end = v->obj->select[0];
		clear_line(v->obj,st,end,1);
	}
	else	v->obj->select_flag = 0;
	return 0;
}

int
v_select_box(VOBJECT * obj,VPOINT st,VPOINT end,int flag)
{
V_SELECT_BOX_S v;
	v.obj = &obj->vimage;
	v.select[0] = st;
	v.select[1] = end;
	v.select_flag = flag;
//	_v_select_box(&v);
	ms_do(_v_select_box, &v, "v_select_box");

	return 0;
}

typedef struct v_part_redraw_image_s{
	VOBJECT * 	obj;
	int		x;
	int		y;
	int		w;
	int		h;
}V_PART_REDRAW_IMAGE_S;

int
_v_part_redraw_image(V_PART_REDRAW_IMAGE_S *v)
{
	VOBJECT * obj = v->obj;
	int x = v->x;
	int y = v->y;
	int w = v->w;
	int h = v->h;
	
	char *dib=obj->vimage.dib_buffer;
	HDC hdc=obj->vimage._h.win->gc;
	HDC memDC;
	BOOL bPaint=TRUE;
	HBITMAP obmp;
	VERROR err;
	hdc = GetDC(obj->vimage._h.win->w);
	/*
	if (hdc == NULL)
	{
		bPaint = FALSE;
		hdc = GetDC(obj->vimage._h.win->w);
	}
	else{
		er_panic("hdc");
	}
	*/
	if (dib)
	{
		int x=obj->vimage.x;
		int y=obj->vimage.y;
		int w=obj->vimage.w;
		int h=obj->vimage.h;
		V_SET_IMAGE_S v;
		v.err = &err;
		v.obj = obj;
		v.w = w;
		v.h = h;
		v.x = x;
		v.y = y;
		_v_set_image(&v);
		//_v_set_image(&err,obj->vimage,x,y,w,h);
		memDC = CreateCompatibleDC(hdc);
		obmp = SelectObject(memDC,obj->vimage.ximage);

		BitBlt(ghBufferDC,x,y,w,h,memDC,x,y,SRCCOPY);
		BitBlt(hdc,x,y,w,h,ghBufferDC,x,y,SRCCOPY);

		//PostThreadMessage(gdwThreadID, MYMSG_INVRECT,0, 0);

		SelectObject(memDC,obmp);
		DeleteObject(memDC);
	}
/*	if (bPaint==FALSE)
	{
		ReleaseDC(obj->vimage._h.win->w,hdc);
	}	
*/
	ReleaseDC(obj->vimage._h.win->w,hdc);
	return 0;
}

int
v_part_redraw_image(VOBJECT * obj,int x,int y,int w,int h)
{
	V_PART_REDRAW_IMAGE_S v;
	v.obj = obj;
	v.x = x;
	v.y = y;
	v.w = w;
	v.h = h;
	return ms_do(_v_part_redraw_image, (void *)&v, "v_part_redraw_image");
}

typedef struct v_scroll_image_s{
	VOBJECT * obj;
	int dx;
	int dy;
}V_SCROLL_IMAGE_S;

int _v_scroll_image(V_SCROLL_IMAGE_S *v)
{
	
int w,h,src_x,src_y,dest_x,dest_y;
VRECT r1,r2;
int dx = v->dx;
int dy = v->dx;
VOBJECT * obj = v->obj;
	if ( dx < 0 ) {
		if ( -dx >= obj->vimage.w )
			goto all;
		w = obj->vimage.w + dx;
		src_x = -dx;
		dest_x = 0;
		r1.tl.x = w;
		r1.tl.y = 0;
		r1.br.x = obj->vimage.w;
		r1.br.y = obj->vimage.h;
	}
	else {
		if ( dx >= obj->vimage.w )
			goto all;
		w = obj->vimage.w - dx;
		src_x = 0;
		dest_x = dx;
		r1.tl.x = 0;
		r1.tl.y = 0;
		r1.br.x = dx;
		r1.br.y = obj->vimage.h;
	}
	if ( dy < 0 ) {
		if ( -dy >= obj->vimage.h )
			goto all;
		h = obj->vimage.h + dy;
		src_y = -dy;
		dest_y = 0;
		r1.br.y = h;

		r2.tl.x = 0;
		r2.tl.y = h;
		r2.br.x = obj->vimage.w;
		r2.br.y = obj->vimage.h;
	}
	else {
		if ( dy >= obj->vimage.h )
			goto all;
		h = obj->vimage.h - dy;
		src_y = 0;
		dest_y = dy;

		r1.tl.y = dy;

		r2.tl.x = 0;
		r2.tl.y = 0;
		r2.br.x = obj->vimage.w;
		r2.br.y = dy;
	}
	v_part_redraw_image(obj,
		r1.tl.x,
		r1.tl.y,
		r1.br.x - r1.tl.x,
		r1.br.y - r1.tl.y);
	v_part_redraw_image(obj,
		r2.tl.x,
		r2.tl.y,
		r2.br.x - r2.tl.x,
		r2.br.y - r2.tl.y);
	return 0;
all:
	v_redraw_image(obj);
	return 0;
}

int
v_scroll_image(VOBJECT * obj,int dx,int dy)
{
	V_SCROLL_IMAGE_S v;
	v.obj = obj;
	v.dx = dx;
	v.dy = dy;
	return ms_do(_v_scroll_image, (void*)&v, "v_scroll_image");
}

typedef struct v_gn {
    void *      buf;
    int     element_size;
    VOBJECT *   obj;
} V_GN;

int
_v_get_and_new_image(void * arg)
{
V_GN * v;
    v = arg;
	if ( v->obj->vimage.buf_32 ) {
		v->buf = v->obj->vimage.buf_32;
		v->element_size = sizeof(long);
		v->obj->vimage.buf_32 = d_alloc(sizeof(long)*
				v->obj->vimage.w*
				v->obj->vimage.h,125);
	}
	else if ( v->obj->vimage.buf_16 ) {
		v->buf = v->obj->vimage.buf_16;
		v->element_size = sizeof(short);
		v->obj->vimage.buf_16 = d_alloc(sizeof(short)*
				v->obj->vimage.w*
				v->obj->vimage.h,125);
	}
	else if ( v->obj->vimage.buf_8 ) {
		v->buf = v->obj->vimage.buf_8;
		v->element_size = sizeof(char);
		v->obj->vimage.buf_8 = d_alloc(sizeof(char)*
				v->obj->vimage.w*
				v->obj->vimage.h,125);
	}
	else {
		er_panic("_v_get_and_new_image");
	}
	return 0;
}

void *
v_get_and_new_image(int * element_size,VOBJECT * obj)
{
V_GN v;
    v.buf = 0;
    v.element_size = 0;
    v.obj = obj;
    ms_do(_v_get_and_new_image, (void *)&v, "v_get_and_new_image");
    if ( element_size )
        *element_size = v.element_size;
    return v.buf;
}