/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<stdio.h>
#include	"xl.h"
#include	"rcache.h"

int
_main(int argc,char ** argv)
{
int i;
extern int view_agent_switch;

	if ( argc < 2 ) {
		fprintf(stderr,"too few argment\n");
		exit(1);
	}
	if ( strcmp(argv[1],"v") == 0 ) {
		view_init(argc,argv);
		init_http_server();
		init_interface();
		init_polling_class(gblisp_top_env0);
		init_html_db();
		init_gv_flame_switch(gblisp_top_env0);

		set_rcache_dir_path(
			l_string(std_cm,get_preference_path()),
			l_string(std_cm,"cache"));
		enable_rcache(RCF_ALL);


		open_control_port();
		loading_file(0, l_string(std_cm,"local"), 1);

		if ( view_agent_switch == 0 )
			start_gbview();
		event_task();
	}
	else if ( strcmp(argv[1],"i") == 0 ||
		  strcmp(argv[1],"o") == 0 ) {
		if ( argc < 3 ) {
			fprintf(stderr,"too few argment\n");
			exit(1);
		}
		ipc_init(argc,argv);
		ipc_system(argc,argv);
	}
	else {
		fprintf(stderr,"invalid argment %s\n",
			argv[1]);
		exit(1);
	}
	exit(0);
	return 0;
}
