/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___COSMOS_H___
#define ___COSMOS_H___


typedef struct pi_xy {
	int		type;
#define PIT_XY		1
	int *		index_x;
	int *		index_y;
} PI_XY;

typedef struct pi_plane {
	int		type;
#define PIT_PLANE	2
	VPOINT *	index;
} PI_PLANE;

typedef union ptr_index {
	int		type;
	PI_PLANE	p;
	PI_XY		xy;
} PTR_INDEX;

typedef struct snapshot {
	long *		buf_32;
	short *		buf_16;
	char *		buf_8;
} SNAPSHOT;

typedef struct move_set {
	int		(*param_func)();
	int		(*flame_func)();
	int 		(*index_func)();
	int		(*cmp_func)();
} MOVE_SET;

typedef struct cosmos_flame {
	int		seq;
	int		seq_lock;

	VWINDOW *	window;

	int		redraw_flag;
	int		im_out_off;

	VOBJECT *	im;
	VOBJECT *	c_indicate;
	VOBJECT *	zoom_in;
	VOBJECT *	zoom_out;
	VOBJECT *	web_page;
	VOBJECT *	mode_btn[MODE_NOS];
	VOBJECT *	exit_btn;
	VRECT		zoom_in_rect;
	VRECT		zoom_out_rect;
	VRECT		web_page_rect;
	VRECT		mode_btn_rect[MODE_NOS];
	VRECT		exit_btn_rect;

	int		select_mode;

	int		mode;
#define GBM_IDLE		0
#define GBM_PRESS_IMAGE		1
#define GBM_PRESS_ZOOM_IN	2
#define GBM_PRESS_ZOOM_OUT	3
#define GBM_PRESS_WEB_PAGE	4
#define GBM_PRESS_MODE_BTN	5
#define GBM_PRESS_EXIT_BTN	6
	int		press_x;
	int		press_y;
	REAL1		press_zoom;
	int		press_time;

	SNAPSHOT	ss;
	PTR_INDEX	ix;
	void *		last_shot;
	void *		start_shot;
	MOVE_SET *	ms;

	VPOINT		select_st;
	VPOINT		select_end;
	int		select_flag;

} COSMOS_FLAME;

#define CALL_STS_CACHE_NORMAL 1
#define CALL_STS_CACHE_REFRESH 2

void call_wf_status(GBVIEW_STATUS * e, int call_sts_cache_flag);
int call_wf_set_status(GBVIEW_STATUS * e);
int call_wf_click(GBVIEW_STATUS * sts,GBVIEW_PLANE * p,int x,int y);
int call_wf_zoom(GBVIEW_PLANE * p,REAL1 zoom);
int call_wf_move(VPOINT from,VPOINT to);
int call_wf_rotate(GB_POINT from,GB_POINT to);
int call_wf_redraw(GBVIEW_PLANE * p,int x,int y,int w,int h);
void call_wf_indicate(GBVIEW_STATUS * sts,int x,int y,int button);
int call_wf_purge_select();
void call_wf_get_coordinate_info(L_CHAR ** name,int * rid,GB_POINT * ptr,int ptr_len);

#endif
