/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___PFC_H___
#define ___PFC_H___

typedef struct pfc {
	char		filename[100];
	int		interval;
	double		target;
	int		sign;
	double		evaluation;
	unsigned int	last_checkpoint;
	unsigned int	accumulate;
	int		lock_id;
} PFC;

#define INTERVAL_MIN	10
#define CHECKPOINT_RATE	3

int lock_pfc(PFC*);
void unlock_pfc(PFC*);
int load_pfc(PFC*);
int save_pfc(PFC*);
int get_pfc_interval(PFC *);
void pfc_control(PFC*,double eval,double d);
int new_pfc(PFC*);
void set_accumulate(PFC*,int);

#endif
