-- create audit table

CREATE TABLE audit (
	ticketNumber	VARCHAR(15) PRIMARY KEY,
	couponNumber	VARCHAR(2),
	inwardNumber	VARCHAR(3),
	inwardId	VARCHAR(2),
	endorsement	VARCHAR(1024),
	issueDate	VARCHAR(8),
	issuePlace	VARCHAR(128),
	invoiceMonth	VARCHAR(8),
	origin		VARCHAR(3),
	destination	VARCHAR(3),
	currency	VARCHAR(3),
	ticketFare	DOUBLE,
	salesCurrency	VARCHAR(3),
	salesFare	DOUBLE,
	plusAdjustment	DOUBLE,
	lessAdjustment	DOUBLE,
	commissionCurrency	VARCHAR(3),
	commissionRate	DOUBLE,
	commissionAmt	DOUBLE,
	totalNuc	DOUBLE,
	lessAmt		DOUBLE,
	stopOverCharge	DOUBLE,
	tourCode	VARCHAR(1024),
	agentCode	VARCHAR(128),
	fareCalculation	VARCHAR(4096),
	airwayNumber	VARCHAR(3),
	airwayId	VARCHAR(2),
	roeRate		DOUBLE,
	day5Rate	DOUBLE,
	meanRate	DOUBLE,
	fixedFare	DOUBLE,
	amountRatio	DOUBLE,
	plusFlg		BIT,
	errorFlag	INT,
	errorString	VARCHAR(1024)
);

-- create sector table

CREATE TABLE sector (
	id		INT PRIMARY KEY AUTO_INCREMENT,
	ticketNumber	VARCHAR(15) NOT NULL,
	sequenceNo	INT NOT NULL,
	stopOver	TINYINT,
	depCode		VARCHAR(3),
	destCode	VARCHAR(3),
	fareBasis	VARCHAR(128),
	carrier		VARCHAR(2),
	classOfService	VARCHAR(1),
	flightDate	VARCHAR(8),
	depTime		VARCHAR(4),
	fareComponent	DOUBLE,
	flightNo	VARCHAR(4),
	classDiffPlus	DOUBLE,
	secureCharge	DOUBLE,
	sideTripPlus	DOUBLE,
	stopOverPlus	DOUBLE,
	prorateFactor	DOUBLE,
	tax		DOUBLE,
	taxIndex	INT,
	taxInLocal	DOUBLE,
	commission	DOUBLE,
	prorationType	INT,
	spaBaseAmtType	VARCHAR(3),
	spaBaseAmt	DOUBLE,
	spaDay5Rate	DOUBLE,
	spaDiscountRate	DOUBLE,
	spaClassDiff	DOUBLE,
	apdpBaseAmtType	VARCHAR(3),
	apdpBaseAmt	DOUBLE,
	apdpDay5Rate	DOUBLE,
	apdpDiscountRate	DOUBLE,
	apdpClassDiff	DOUBLE,
	proratedClassDiff	DOUBLE,
	exstPlus	DOUBLE,
	proratedExstPlus	DOUBLE,
	prorateError	INT,
	spaNuc		DOUBLE,
	apdpNuc		DOUBLE,
	npPvalues	DOUBLE,
	srpNuc		DOUBLE,
	prorateValue	DOUBLE,
	amountInLocal	DOUBLE,
	invoiceValue	DOUBLE,
	sideTripIndex	INT,
	classDiffIndex	INT,
	secureIndex	INT,
	fixedFareCheck	DOUBLE,
	fixedFareDiscount	DOUBLE,
	componentIndex	INT,
	componentKind	INT,
	viaRouting	VARCHAR(2),
	fareType	INT,
	depAirport	VARCHAR(3),
	destAirport	VARCHAR(3),
	opCarrier	VARCHAR(2),
	npClassDiff	DOUBLE,
	secureChargeSaved	DOUBLE,
	proratedSecureCharge	DOUBLE,
	errorFlag	INT,
	errorString	VARCHAR(1024),
	fixValue	DOUBLE,
	fixCurrency	VARCHAR(3),
	fixAmount	DOUBLE,
	invoiceFlg	BIT,
	certainty	DOUBLE,
	fcomp_id	INTEGER,
CONSTRAINT fk_sector
	FOREIGN KEY (ticketNumber) REFERENCES audit(ticketNumber)
);

-- create fcomp table

CREATE TABLE fcomp (
	id		INT PRIMARY KEY AUTO_INCREMENT,
	ticketNumber	VARCHAR(15) NOT NULL,
	value		DOUBLE,
	kind		INT,
	fixedFareDiscount	DOUBLE,
CONSTRAINT fk_sector
	FOREIGN KEY (ticketNumber) REFERENCES audit(ticketNumber)
);

-- create tax table

CREATE TABLE tax (
	id		INT PRIMARY KEY AUTO_INCREMENT,
	ticketNumber	VARCHAR(15) NOT NULL,
	type		VARCHAR(8),
	amount		DOUBLE,
CONSTRAINT fk_sector
	FOREIGN KEY (ticketNumber) REFERENCES audit(ticketNumber)
);
