-- create audit table

CREATE TABLE audit (
	ticketNumber	VARCHAR(15) PRIMARY KEY,
	couponNumber	VARCHAR(2),
	inwardNumber	VARCHAR(3),
	inwardId	VARCHAR(2),
	endorsement	VARCHAR(1024),
	issueDate	VARCHAR(8),
	issuePlace	VARCHAR(128),
	invoiceMonth	VARCHAR(8),
	origin		VARCHAR(3),
	destination	VARCHAR(3),
	currency	VARCHAR(3),
	ticketFare	REAL,
	salesCurrency	VARCHAR(3),
	salesFare	REAL,
	plusAdjustment	REAL,
	lessAdjustment	REAL,
	commissionCurrency	VARCHAR(3),
	commissionRate	REAL,
	commissionAmt	REAL,
	totalNuc	REAL,
	lessAmt		REAL,
	stopOverCharge	REAL,
	tourCode	VARCHAR(1024),
	agentCode	VARCHAR(128),
	fareCalculation	VARCHAR(4096),
	airwayNumber	VARCHAR(3),
	airwayId	VARCHAR(2),
	roeRate		REAL,
	day5Rate	REAL,
	meanRate	REAL,
	fixedFare	REAL,
	amountRatio	REAL,
	plusFlg		CHAR,
	errorFlag	INTEGER,
	errorString	VARCHAR(1024)
);

-- create sector table

CREATE TABLE sector (
	id		SERIAL PRIMARY KEY,
	ticketNumber	VARCHAR(15) NOT NULL,
	sequenceNo	INTEGER NOT NULL,
	stopOver	SMALLINT,
	depCode		VARCHAR(3),
	destCode	VARCHAR(3),
	fareBasis	VARCHAR(128),
	carrier		VARCHAR(2),
	classOfService	VARCHAR(1),
	flightDate	VARCHAR(8),
	depTime		VARCHAR(4),
	fareComponent	REAL,
	flightNo	VARCHAR(4),
	classDiffPlus	REAL,
	secureCharge	REAL,
	sideTripPlus	REAL,
	stopOverPlus	REAL,
	prorateFactor	REAL,
	tax		REAL,
	taxIndex	INTEGER,
	taxInLocal	REAL,
	commission	REAL,
	prorationType	INTEGER,
	spaBaseAmtType	VARCHAR(3),
	spaBaseAmt	REAL,
	spaDay5Rate	REAL,
	spaDiscountRate	REAL,
	spaClassDiff	REAL,
	apdpBaseAmtType	VARCHAR(3),
	apdpBaseAmt	REAL,
	apdpDay5Rate	REAL,
	apdpDiscountRate	REAL,
	apdpClassDiff	REAL,
	proratedClassDiff	REAL,
	exstPlus	REAL,
	proratedExstPlus	REAL,
	prorateError	INTEGER,
	spaNuc		REAL,
	apdpNuc		REAL,
	npPvalues	REAL,
	srpNuc		REAL,
	prorateValue	REAL,
	amountInLocal	REAL,
	invoiceValue	REAL,
	sideTripIndex	INTEGER,
	classDiffIndex	INTEGER,
	secureIndex	INTEGER,
	fixedFareCheck	REAL,
	fixedFareDiscount	REAL,
	componentIndex	INTEGER,
	componentKind	INTEGER,
	viaRouting	VARCHAR(2),
	fareType	INTEGER,
	depAirport	VARCHAR(3),
	destAirport	VARCHAR(3),
	opCarrier	VARCHAR(2),
	npClassDiff	REAL,
	secureChargeSaved	REAL,
	proratedSecureCharge	REAL,
	errorFlag	INTEGER,
	errorString	VARCHAR(1024),
	fixValue	REAL,
	fixCurrency	VARCHAR(3),
	fixAmount	REAL,
	invoiceFlg	CHAR,
	certainty	REAL,
	fcomp_id	INT,
CONSTRAINT fk_sector
	FOREIGN KEY (ticketNumber) REFERENCES audit(ticketNumber)
);

-- create fcomp table

CREATE TABLE fcomp (
	id		SERIAL PRIMARY KEY AUTO_INCREMENT,
	ticketNumber	VARCHAR(15) NOT NULL,
	value		REAL,
	kind		INTEGER,
	fixedFareDiscount	REAL,
CONSTRAINT fk_sector
	FOREIGN KEY (ticketNumber) REFERENCES audit(ticketNumber)
);

-- create tax table

CREATE TABLE tax (
	id		SERIAL PRIMARY KEY AUTO_INCREMENT,
	ticketNumber	VARCHAR(15) NOT NULL,
	type		VARCHAR(8),
	amount		REAL,
CONSTRAINT fk_sector
	FOREIGN KEY (ticketNumber) REFERENCES audit(ticketNumber)
);
