#!/usr/bin/perl
use strict;
use warnings;

# 旧バージョンのディレクトリ
my $data_dir = 'data';
my $system_dir = 'system';

# トピックデータの変換
my $counterfile = "$system_dir/topiccounter.txt";
open my $counterfh, '<', $counterfile;
my $counter = <$counterfh>;
chop $counter;
close $counterfh;

for my $i (0..$counter) {
    my $id = $i;
    my @dataarray = ();

    my $datafile = "$data_dir/$id" . "tp.data";
    if (-f $datafile) {
        open my $infh, '<', $datafile;
        while (my $datarec = <$infh>) {
            chop $datarec;
            my $rec = '';
            my ($rectype,$topicid,$lastdate,$status,$editor,$handle,$title,$text,$commentnum,$linknum,$tbnum,$ad1,$ad2,$ad3,$point,$keyword,$ipaddr) = ();
            $rectype = substr($datarec, 0, 1);
            if ($rectype == 0) {
                ($rectype,$topicid,$lastdate,$status,$editor,$handle,$title,$text,$commentnum,$linknum,$tbnum,$ad1,$ad2,$ad3,$point,$keyword,$ipaddr) = split(/\,/, $datarec);
                $rec = "$rectype,$topicid,$lastdate,$status,$editor,$handle,$title,$text,$commentnum,$linknum,$tbnum,$ad1,$ad2,$ad3,$point,$keyword,,$ipaddr";
            }
            else {
                $rec = $datarec;
            }
            push @dataarray, $rec;
        }
        close $infh;

        open my $outfh, '>', $datafile;
        foreach my $data (@dataarray) {
            print {$outfh} "$data\n";
        }
        close $outfh;
    }
}

# 全ユーザーのユーザーIDリストを取得
my @userarray = ();
opendir my $dirh, "$system_dir/user/";
while (defined(my $dir = readdir $dirh)) {
    next if ($dir =~ /\A[.]+\z/);
    push @userarray, $dir;
}
closedir $dirh;

@userarray = sort @userarray;

foreach my $userid (@userarray) {

    my @dataarray = ();

    my $datafile = "$system_dir/user/$userid/" . "profile.txt";
    if (-f $datafile) {

        open my $infh, '<', $datafile;
        my $datarec = <$infh>;
        chop $datarec;
        close $infh;

        my ($userid,$password,$mailaddr,$hpurl,$username,$auth,$status,$ad1,$ad2,$ad3,$parts,$feedurl,$amazonid,$nouse) = split(/\,/, $datarec);
        my $data = "$userid,$password,$mailaddr,$hpurl,$username,$auth,$status,$ad1,$ad2,$ad3,$parts,$feedurl,$amazonid,$nouse,,";

        open my $outfh, '>', $datafile;
        print {$outfh} "$data\n";
        close $outfh;
    }
}

