#------------------------------------------------------------------------------
#    59Tracker, weblog software for personal publisher.
#    Copyright (C) 2004-2009 Kaga, Hiroaki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#------------------------------------------------------------------------------

package Lib::Util;

use strict;
use warnings;

use Lib::Logger;
use Lib::String;

my $logger = Lib::Logger->new();

# コンストラクタ
sub new {
    my $self = {};

    use Lib::App::Conf;
    my $conf = Lib::App::Conf->new();

    $self->{excerpt_length} = $conf->get_excerpt_length();

    bless($self);
    return $self;
}

# URLをリンクに変換して返す
sub url_link {
    my $self = shift;
    my $url = shift;
    my $target = shift;

    my $pattern = "s?https?://[-_.!~*'()a-zA-Z0-9;/?:@&=+$,%#]+";
    $url =~ s/($pattern)/<a href="$1" $target>$1<\/a>/g;

    return $url;
}

# URLからコンテンツのタイトルと引用文を取得
sub get_blockquote {
    my $self = shift;
    my $url = shift;

    # URLが設定されている場合はブックマークレット経由
    use LWP::Simple;
    my $content = LWP::Simple::get($url);
    my $string = Lib::String->new();

    # 文字コードの種類を取得
    my $code = $string->get_encode($content);
    $content = $string->convert($content, $code, 'utf8');

    my $blockquote = '';
    my $pattern = "<meta.*name=\"description\".*content=\"(.+)?\".*?>";
    if ($content =~ m/$pattern/i) {
        $blockquote = $1;
    }

    $content =~ s/\r?\n//g;
    $pattern = "<title.*?>(.*)</title>";
    my $title = '';
    if($content =~ m/$pattern/i) {
        $title = $1;
    }

    # description がなかった場合
    if ($blockquote eq '') {
        $pattern = "<body.*?>(.+)</body>";
        if ($content =~ m/$pattern/i) {
            $blockquote = $1;
        }
    }
    $blockquote =~ s/<script>.+?<\/script>//gi;
    $blockquote =~ s/<noscript>.+?<\/noscript>//gi;
    $blockquote =~ s/<!--.+?-->//g;
    $blockquote =~ s/\t//g;
    $blockquote =~ s/[ ]+\z//g;
    $blockquote = $string->cut($blockquote, $self->{excerpt_length});

    my @element = ();
    push @element, $title;
    push @element, $blockquote;

    return @element;
}

1;
# End of Util.pm
