#!/usr/bin/perl
#------------------------------------------------------------------------------
#    59Tracker, weblog software for personal publisher.
#    Copyright (C) 2004-2009 Kaga, Hiroaki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#------------------------------------------------------------------------------

use strict;
use warnings;

use constant {
    LOCK_SH => 1,
    LOCK_EX => 2,
    LOCK_NB => 4,
    LOCK_UN => 8,
};

use Lib::Logger;
use Lib::Error;
use Lib::User;
use Lib::Mail;
use Lib::App::Conf;

my $logger = Lib::Logger->new();
my $error = Lib::Error->new();
my $user = Lib::User->new();
my $conf = Lib::App::Conf->new();

sub act() {
    my ($act, $cgi) = @_;

    my $sessionid = $cgi->cookie('cookie59t');
    if ($sessionid eq '') {
        $error->print_error('00003e');
    }
    my $session_userid = $user->check_session($sessionid);
    if ($session_userid eq '') {
        $error->print_error('00003e');
    }

    if ($act eq 'input_invite') {
        _input_invite();
    }
    elsif ($act eq 'add_invite') {
        _add_invite($session_userid, $cgi);
    }
    else {
        $error->print_error('00002e');
    }
}

sub _input_invite() {
#    $logger->write('_input_invite');   # for debug

    my $invitedata;
    $invitedata->{mailaddr} = '';
    $invitedata->{message}  = '';

    # 入力画面の表示
    _show_page($invitedata, '');
}

sub _add_invite() {
    my ($session_userid, $cgi) = @_;

    # パラメーターの取得
    my $invitedata;
    $invitedata->{mailaddr} = $cgi->param('mailaddr');
    $invitedata->{message}  = $cgi->param('message');

    # 入力チェック
    # メールアドレス
    if ($invitedata->{mailaddr} eq '') {
        _show_page($invitedata, 'メールアドレスが未入力です');
    }
    # メールアドレス形式が正しいかチェック
    if ($invitedata->{mailaddr} !~ /[-_0-9a-z]+\@[-_0-9a-z]+\.[-_0-9a-z.]+/) {
        _show_page($invitedata, 'メールアドレスに誤りがあります');
    }
    if ($invitedata->{message} eq '') {
        _show_page($invitedata, 'メッセージが未入力です');
    }

    # メッセージのコンマはエンコード
    $invitedata->{message} =~ s/,/enc_conma/g;

    my $systemdir = $conf->get_system_dir();
    my $docrootdir = $conf->get_docroot_dir();
    my $sitetitle = $conf->get_site_title();

    # 招待コードを生成
    my $invitecode = int(rand(89999)) + 10000;  # 10000 ～ 99999 のコードを生成

    # 招待コードを保存 (招待コード,メールアドレス)
    my $invitefile = "$systemdir/invite.txt";
    open my $invitefh, '>', "$invitefile";
    flock $invitefh, LOCK_EX;
    print $invitefh "$invitecode,$invitedata->{mailaddr}\n";
    flock $invitefh, LOCK_UN;
    close $invitefh;
    chmod 0766, $invitefile;

    my $mail = Lib::Mail->new();

    my $url = "$docrootdir/?act=input_register&invitecode=$invitecode";

    # 招待者にメール送信
    my $subject = "$session_userid さんがあなたを$sitetitleに招待しました";
    my $body = <<"END_BODY";
$session_userid さんがあなたを $sitetitle の編集者として招待しました。
下記のURLから編集者としてユーザー登録が可能です。

$url

$session_userid さんからのメッセージ：
$invitedata->{message}

END_BODY

    $mail->send($subject, $body, $invitedata->{mailaddr});

    # サイト管理者にメール送信
    $subject = "$invitedata->{mailaddr} さんが編集者として招待されました";
    $body = <<"END_BODY";
$session_userid さんが $invitedata->{mailaddr} さんを編集者として招待しました。
END_BODY

    $mail->send($subject, $body, $conf->get_admin_address());

    # 招待完了メッセージを表示
    my $msg = <<"END_MESSAGE";
$invitedata->{mailaddr} さんを編集者として招待しました。
END_MESSAGE

    _show_message('招待完了', $msg);
}

sub _show_page() {
    my ($invitedata, $msg) = @_;

    $msg = "<p><strong><font class=\"message\" size=\"+1\">$msg</font></strong></p>";

    my $caption = '招待';

    my $path = <<"END_PATH";
<p><strong>
<a href="./" class="path">ホーム</a>&nbsp;
&gt;&nbsp;
$caption
</strong></p>
END_PATH

    my $systemdir = $conf->get_system_dir();

    open my $templatefh, '<', "$systemdir/tmpl/invite.tmpl";
    my $template = do { local $/; <$templatefh> };
    close $templatefh;

    $template =~ s/\$CAPTION\$/$caption/g;
    $template =~ s/\$PATH\$/$path/g;
    $template =~ s/\$MSG\$/$msg/g;
    $template =~ s/\$MAILADDR\$/$invitedata->{mailaddr}/g;
    $template =~ s/\$MESSAGE\$/$invitedata->{message}/g;

    print "Content-Type: text/html\n\n";
    print $template;

    exit;
}

# メッセージを表示する
sub _show_message() {
    my ($title, $msg) = @_;

    $msg = "<p><strong><font class=\"message\">$msg</font></strong></p>";
    my $pageexit = "<strong><a href=\"./\">ホーム</a></strong>";

    my $systemdir = $conf->get_system_dir();

    open my $templatefh, '<', "$systemdir/tmpl/message.tmpl";
    my $template = do { local $/; <$templatefh> };
    close $templatefh;

    $template =~ s/\$TITLE\$/$title/g;
    $template =~ s/\$MSG\$/$msg/g;
    $template =~ s/\$PAGEEXIT\$/$pageexit/g;

    print "Content-Type: text/html\n\n";
    print $template;

    exit;
}

1;
