#!/usr/bin/perl

use strict;
use warnings;

use Lib::App::Topic;
use Lib::App::Archive;
use Lib::App::Keyword;
use Lib::App::Conf;

my $topicobj = Lib::App::Topic->new();
my $archiveobj = Lib::App::Archive->new();
my $keywordobj = Lib::App::Keyword->new();
my $confobj = Lib::App::Conf->new();

my $counter = $archiveobj->get_counter();
for my $i (0 .. $counter) {
    my $topicid = $i;
    my $ret = $topicobj->load($topicid, 1);
    next if (!$ret);

    # キーワードデータの再作成
    my $keyword = $topicobj->get_keyword();
    my @items = split(/ /, $keyword);
    foreach my $item (@items) {
        $keywordobj->add($item, $topicid);
    }

    # ポイントの再計算
    my $trackbacknum = $topicobj->get_trackbacknum();
    my $point = $trackbacknum * $confobj->get_normal_point();
    my @comments = $topicobj->get_comments();

    for my $i (0 .. $#comments) {
        my $comment = $comments[$i];
        my ($commentid, $status, $postdate, $author, $mailaddr, $hpurl, $text, $evaluate, $ipaddr) = split(/\,/, $comment);
        next if ($status == 0);
        if ($evaluate) {
            $point += $confobj->get_good_point();
        }
        else {
            $point += $confobj->get_normal_point();
        }
    }
    $topicobj->set_point($point);
    $topicobj->update();
}

# 完了表示
print "Data adjust completed !\n";

exit;
