/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ESLoader;
import FESI.Data.ESObject;
import FESI.Data.ESValue;
import FESI.Data.ESWrapper;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.LocalClassLoader;

public class ESPackages
extends ESLoader {
    public ESPackages(Evaluator evaluator) {
        super(evaluator);
    }

    public ESPackages(String string, ESPackages eSPackages, LocalClassLoader localClassLoader, Evaluator evaluator) {
        super(string, eSPackages, localClassLoader, evaluator);
    }

    public ESObject getPrototype() {
        throw new ProgrammingError("Cannot get prototype of Package");
    }

    public String getESClassName() {
        return "Packages";
    }

    private Class loadClass(String string) throws ClassNotFoundException {
        if (this.classLoader == null) {
            return Class.forName(string);
        }
        return this.classLoader.loadClass(string);
    }

    public ESValue getProperty(String string, int n) throws EcmaScriptException {
        ESValue eSValue = this.properties.get(string, n);
        if (eSValue == null) {
            String string2 = this.buildPrefix();
            String string3 = string2 == null ? string : String.valueOf(string2) + "." + string;
            try {
                Class clazz = this.loadClass(string3);
                if (ESLoader.debugJavaAccess) {
                    System.out.println("** Class '" + string3 + "' loaded");
                }
                eSValue = new ESWrapper(clazz, this.evaluator);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (ESLoader.debugJavaAccess) {
                    System.out.println("** Could not load '" + string3 + "' by " + this);
                    System.out.println("** Exception: " + classNotFoundException);
                }
                eSValue = new ESPackages(string, this, this.classLoader, this.evaluator);
            }
            this.properties.put(string, n, false, false, eSValue);
        }
        return eSValue;
    }

    public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
        if (this.previousPackage == null && this.classLoader == null) {
            if (eSValueArray.length < 1) {
                throw new EcmaScriptException("Missing class directory or file name");
            }
            String string = eSValueArray[0].toString();
            LocalClassLoader localClassLoader = LocalClassLoader.makeLocalClassLoader(string);
            return new ESPackages(null, null, localClassLoader, this.evaluator);
        }
        throw new EcmaScriptException("Java class not found: '" + this.buildPrefix() + "'");
    }

    public String getTypeofString() {
        return "JavaPackage";
    }

    public String toDetailString() {
        return "ES:<" + this.getESClassName() + ":'" + this.buildPrefix() + "'" + (this.classLoader == null ? "" : ",@" + this.classLoader) + ">";
    }
}

