/*
 * Decompiled with CFR 0.152.
 */
package FESI.Interpreter;

import FESI.Data.ESValue;
import FESI.Interpreter.HashtableEntry;
import FESI.Interpreter.HashtableEnumerator;
import java.util.Enumeration;

public class FesiHashtable
implements Cloneable {
    private transient HashtableEntry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public FesiHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.table = new HashtableEntry[n];
        this.threshold = (int)((float)n * f);
    }

    public FesiHashtable(int n) {
        this(n, 0.75f);
    }

    public FesiHashtable() {
        this(27, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Enumeration keys() {
        return new HashtableEnumerator(this.table, true);
    }

    public Enumeration elements() {
        return new HashtableEnumerator(this.table, false);
    }

    public boolean containsKey(String string, int n) {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        while (hashtableEntry != null) {
            if (hashtableEntry.key == string || hashtableEntry.hash == n && hashtableEntry.key.equals(string)) {
                return true;
            }
            hashtableEntry = hashtableEntry.next;
        }
        return false;
    }

    public ESValue get(String string, int n) {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        while (hashtableEntry != null) {
            if (hashtableEntry.key == string || hashtableEntry.hash == n && hashtableEntry.key.equals(string)) {
                return hashtableEntry.value;
            }
            hashtableEntry = hashtableEntry.next;
        }
        return null;
    }

    public boolean isHidden(String string, int n) {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        while (hashtableEntry != null) {
            if (hashtableEntry.key == string || hashtableEntry.hash == n && hashtableEntry.key.equals(string)) {
                return hashtableEntry.hidden;
            }
            hashtableEntry = hashtableEntry.next;
        }
        return false;
    }

    public boolean isReadonly(String string, int n) {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        while (hashtableEntry != null) {
            if (hashtableEntry.key == string || hashtableEntry.hash == n && hashtableEntry.key.equals(string)) {
                return hashtableEntry.readonly;
            }
            hashtableEntry = hashtableEntry.next;
        }
        return false;
    }

    protected void rehash() {
        int n = this.table.length;
        HashtableEntry[] hashtableEntryArray = this.table;
        int n2 = n * 2 + 1;
        if (n2 < 101) {
            n2 = 101;
        }
        HashtableEntry[] hashtableEntryArray2 = new HashtableEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = hashtableEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            HashtableEntry hashtableEntry = hashtableEntryArray[n3];
            while (hashtableEntry != null) {
                HashtableEntry hashtableEntry2 = hashtableEntry;
                hashtableEntry = hashtableEntry.next;
                int n4 = (hashtableEntry2.hash & Integer.MAX_VALUE) % n2;
                hashtableEntry2.next = hashtableEntryArray2[n4];
                hashtableEntryArray2[n4] = hashtableEntry2;
            }
        }
    }

    public ESValue put(String string, int n, boolean bl, boolean bl2, ESValue eSValue) {
        if (eSValue == null) {
            throw new NullPointerException("value");
        }
        HashtableEntry[] hashtableEntryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n && hashtableEntry.key.equals(string)) {
                ESValue eSValue2 = hashtableEntry.value;
                hashtableEntry.value = eSValue;
                return eSValue2;
            }
            hashtableEntry = hashtableEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(string, n, bl, bl2, eSValue);
        }
        HashtableEntry hashtableEntry2 = new HashtableEntry();
        hashtableEntry2.hash = n;
        hashtableEntry2.key = string;
        hashtableEntry2.value = eSValue;
        hashtableEntry2.hidden = bl;
        hashtableEntry2.readonly = bl2;
        hashtableEntry2.next = hashtableEntryArray[n2];
        hashtableEntryArray[n2] = hashtableEntry2;
        ++this.count;
        return null;
    }

    public ESValue remove(String string, int n) {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        HashtableEntry hashtableEntry2 = null;
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n && hashtableEntry.key.equals(string)) {
                if (hashtableEntry2 != null) {
                    hashtableEntry2.next = hashtableEntry.next;
                } else {
                    hashtableEntryArray[n2] = hashtableEntry.next;
                }
                --this.count;
                return hashtableEntry.value;
            }
            hashtableEntry2 = hashtableEntry;
            hashtableEntry = hashtableEntry.next;
        }
        return null;
    }

    public void clear() {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = hashtableEntryArray.length;
        while (--n >= 0) {
            hashtableEntryArray[n] = null;
        }
        this.count = 0;
    }

    public Object clone() {
        try {
            FesiHashtable fesiHashtable = (FesiHashtable)super.clone();
            fesiHashtable.table = new HashtableEntry[this.table.length];
            int n = this.table.length;
            while (n-- > 0) {
                HashtableEntry hashtableEntry = fesiHashtable.table[n] = this.table[n] != null ? (HashtableEntry)this.table[n].clone() : null;
            }
            return fesiHashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        Enumeration enumeration2 = this.elements();
        stringBuffer.append("{");
        int n2 = 0;
        while (n2 <= n) {
            String string = enumeration.nextElement().toString();
            String string2 = enumeration2.nextElement().toString();
            stringBuffer.append(String.valueOf(string) + "=" + string2);
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

