/*
 * Decompiled with CFR 0.152.
 */
package jp.moja.socklet.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import jp.wda.gpss.SocketProcessor;

public class ChatRoom {
    private String name;
    private HashMap children;
    private ChatRoom parent;
    private ArrayList members;
    private HashMap attributes;
    private boolean systemRoom;
    public static final String ROOM_ATTRIBUTE_NAME = "__ROOM";

    public ChatRoom(String name, boolean system) {
        this.name = name;
        this.children = new HashMap();
        this.parent = null;
        this.members = new ArrayList();
        this.attributes = new HashMap();
        this.systemRoom = system;
    }

    public ChatRoom() {
        this("", false);
    }

    public ChatRoom(String name) {
        this(name, false);
    }

    public ChatRoom getParent() {
        return this.parent;
    }

    public void setParent(ChatRoom tree) {
        this.parent = tree;
    }

    public ChatRoom setName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSystemRoom() {
        return this.systemRoom;
    }

    public void setSystemRoom(boolean system) {
        this.systemRoom = system;
    }

    public List getChildNames() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return new ArrayList(this.children.keySet());
        }
    }

    public List getChildValues() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return new ArrayList(this.children.values());
        }
    }

    public List getChildren() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return new ArrayList(this.children.entrySet());
        }
    }

    public ChatRoom getChild(String name) {
        return (ChatRoom)this.children.get(name);
    }

    public ChatRoom addChild(String name, ChatRoom child) {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            if (this.children.containsKey(name)) {
                return (ChatRoom)this.children.get(name);
            }
        }
        ChatRoom oldParent = child.getParent();
        if (oldParent != null) {
            oldParent.removeChild(child);
        }
        HashMap hashMap2 = this.children;
        synchronized (hashMap2) {
            this.children.put(name, child);
            child.setParent(this);
            child.setName(name);
        }
        return child;
    }

    public ChatRoom addChild(ChatRoom child) {
        return this.addChild(child.getName(), child);
    }

    public ChatRoom addChild(String name) {
        try {
            return this.addChild(name, (ChatRoom)this.getClass().newInstance());
        }
        catch (Exception e) {
            return this.addChild(name, new ChatRoom());
        }
    }

    public ChatRoom removeChild(String name) {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            ChatRoom node = (ChatRoom)this.children.remove(name);
            node.setParent(null);
            return node;
        }
    }

    public ChatRoom removeChild(ChatRoom node) {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            this.children.remove(node.getName());
            node.setParent(null);
            return node;
        }
    }

    public ChatRoom cancelParent() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            if (this.parent != null) {
                this.parent.removeChild(this);
            }
            return this;
        }
    }

    public ChatRoom getRoot() {
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return this;
    }

    public ChatRoom makePath(String path) {
        return this.processPath(path, true);
    }

    public ChatRoom searchPath(String path) {
        return this.processPath(path, false);
    }

    private ChatRoom processPath(String path, boolean make) {
        int terminator = path.indexOf("/");
        if (terminator == -1) {
            if (path.equals("..")) {
                if (this.getParent() == null) {
                    return this;
                }
                return this.getParent();
            }
            if (make) {
                return this.addChild(path);
            }
            return this.getChild(path);
        }
        if (terminator == 0) {
            String nextPath = path.substring(1);
            return this.getRoot().processPath(nextPath, make);
        }
        String childName = path.substring(0, terminator);
        String nextPath = path.substring(terminator + 1);
        if (childName.equals("..")) {
            if (this.getParent() == null) {
                return this.processPath(nextPath, make);
            }
            return this.getParent().processPath(nextPath, make);
        }
        if (make) {
            ChatRoom child = this.addChild(childName);
            return child.processPath(nextPath, make);
        }
        ChatRoom child = this.getChild(childName);
        if (child == null) {
            return null;
        }
        return child.processPath(nextPath, make);
    }

    public String getPathString() {
        String returnPath = "/" + this.name;
        if (this.parent == null) {
            return "/";
        }
        return this.parent.getPathString(returnPath);
    }

    private String getPathString(String path) {
        String returnPath = "/" + this.name;
        if (this.parent == null) {
            return path;
        }
        return this.parent.getPathString(String.valueOf(returnPath) + path);
    }

    public boolean enter(SocketProcessor client) {
        ChatRoom oldRoom = (ChatRoom)client.getAttribute(ROOM_ATTRIBUTE_NAME);
        if (oldRoom != null) {
            oldRoom.exit(client);
        }
        ArrayList arrayList = this.members;
        synchronized (arrayList) {
            if (this.members.add(client)) {
                client.setAttribute((Object)ROOM_ATTRIBUTE_NAME, this);
                return true;
            }
            client.removeAttribute(ROOM_ATTRIBUTE_NAME);
            return false;
        }
    }

    public boolean enter(String path, SocketProcessor client, boolean make) {
        ChatRoom room = make ? this.makePath(path) : this.searchPath(path);
        if (room != null) {
            return room.enter(client);
        }
        return false;
    }

    public boolean enter(String path, SocketProcessor client) {
        return this.enter(path, client, true);
    }

    public boolean enter(Object obj) {
        ArrayList arrayList = this.members;
        synchronized (arrayList) {
            return this.members.add(obj);
        }
    }

    public boolean exit(SocketProcessor client) {
        ChatRoom room = (ChatRoom)client.getAttribute(ROOM_ATTRIBUTE_NAME);
        client.removeAttribute(ROOM_ATTRIBUTE_NAME);
        if (room != null && room != this) {
            return room.exit(client);
        }
        ArrayList arrayList = this.members;
        synchronized (arrayList) {
            return ((AbstractCollection)this.members).remove(client);
        }
    }

    public boolean exit(Object obj) {
        ArrayList arrayList = this.members;
        synchronized (arrayList) {
            return ((AbstractCollection)this.members).remove(obj);
        }
    }

    public ChatRoom getRoom(SocketProcessor client) {
        return (ChatRoom)client.getAttribute(ROOM_ATTRIBUTE_NAME);
    }

    public List getMemberList() {
        ArrayList arrayList = this.members;
        synchronized (arrayList) {
            return new ArrayList(this.members);
        }
    }

    public List getMemberList(SocketProcessor client) {
        ChatRoom room = (ChatRoom)client.getAttribute(ROOM_ATTRIBUTE_NAME);
        if (room != null) {
            return room.getMemberList();
        }
        return new ArrayList();
    }

    public int getMemberCount() {
        ArrayList arrayList = this.members;
        synchronized (arrayList) {
            return this.members.size();
        }
    }

    public void setAttribute(Object key, Object value) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            this.attributes.put(key, value);
        }
    }

    public Object getAttribute(Object key) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            return this.attributes.get(key);
        }
    }

    public Object removeAttribute(Object key) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            return this.attributes.remove(key);
        }
    }

    public List getAttributeKeys() {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            return new ArrayList(this.attributes.keySet());
        }
    }

    public String toString() {
        return this.getPathString();
    }

    public static void main(String[] args) {
        ChatRoom root = new ChatRoom("Root");
        ChatRoom t = root.makePath("a/b/c/d");
        t.makePath("e");
        t.makePath("f/../g");
        System.out.println(root.getClass());
        System.out.println(root);
        System.out.println(root.searchPath("a/b"));
        System.out.println(t);
        System.out.println(t.getClass());
        System.out.println("----");
        Iterator itr = t.getChildValues().iterator();
        while (itr.hasNext()) {
            ChatRoom node = (ChatRoom)itr.next();
            System.out.println(node);
        }
    }
}

