/*
 * Decompiled with CFR 0.152.
 */
package jp.moja.socklet.util;

import java.util.ArrayList;
import jp.wda.gpss.SocketProcessor;

public class IdGenerator {
    private ArrayList idTable = new ArrayList();
    public static final String ID_ATTRIBUTE_NAME = "__ID";

    public IdGenerator() {
        this.idTable.add(null);
    }

    public synchronized int enter(Object obj) {
        int num = 1;
        while (num < this.idTable.size()) {
            if (this.idTable.get(num) == null) {
                this.idTable.set(num, obj);
                return num;
            }
            ++num;
        }
        this.idTable.add(obj);
        return num;
    }

    public synchronized int enter(SocketProcessor client) {
        int id = this.enter((Object)client);
        client.setAttribute((Object)ID_ATTRIBUTE_NAME, id);
        return id;
    }

    public synchronized boolean exit(Object obj) {
        int id = this.idTable.indexOf(obj);
        if (id == -1) {
            return false;
        }
        this.idTable.set(id, null);
        this.reduce();
        return true;
    }

    public synchronized boolean exit(int id) {
        if (id > this.idTable.size() - 1) {
            return false;
        }
        this.idTable.set(id, null);
        this.reduce();
        return true;
    }

    public synchronized boolean exit(SocketProcessor client) {
        client.removeAttribute(ID_ATTRIBUTE_NAME);
        return this.exit((Object)client);
    }

    private void reduce() {
        int id = this.idTable.size() - 1;
        while (id > 0) {
            if (this.idTable.get(id) != null) break;
            this.idTable.remove(id);
            --id;
        }
    }

    public int getId(Object obj) {
        return this.idTable.indexOf(obj);
    }

    public Object getObject(int id) {
        return this.idTable.get(id);
    }
}

