/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss.system;

import java.io.File;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import jp.moja.socklet.util.security.AccessController;
import jp.moja.socklet.util.security.ClientChecker;
import jp.moja.socklet.util.security.IPAddressChecker;
import jp.moja.socklet.util.security.LimitedConnectionChecker;
import jp.moja.socklet.util.security.LimitedConnectionPerHostChecker;
import jp.wda.gpss.SockletDeployInfo;
import jp.wda.gpss.system.ConfigurationError;
import jp.wda.gpss.system.ScriptInfo;
import jp.wda.gpss.util.Finder;
import jp.wda.gpss.util.FinderElement;
import org.apache.commons.digester.Digester;
import org.xml.sax.SAXException;

public class Configuration {
    public static final int DEFAULT_PORT = 9090;
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static File gpsshome = new File(System.getProperty("gpss.home", System.getProperty("user.dir")));
    private ArrayList applications;
    private ArrayList scriptsinfo;
    private Hashtable scriptparams = new Hashtable();
    private File configFile;
    private int port;
    private String encoding;
    private int timeout;
    private boolean useDefault;
    private boolean setdefault;
    private File classpath;
    private Class executable;
    private AccessController securityController;
    private ArrayList allowDomains;
    private int buffermax;
    private SockletDeployInfo syscomInfo = new SockletDeployInfo("SystemCommandSocklet");
    private Properties logprops = new Properties();
    private ArrayList loggers = new ArrayList();
    private boolean setsyslog;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public Configuration(File configFile) {
        this.configFile = configFile;
    }

    public int getPort() {
        return this.port;
    }

    private void setPort(int s) {
        this.port = s;
    }

    public String getEncoding() {
        return this.encoding;
    }

    private void setEncoding(String s) {
        this.encoding = s;
    }

    public int getTimeout() {
        return this.timeout;
    }

    private void setTimeout(int s) {
        this.timeout = s;
    }

    public boolean isUsingDefault() {
        return this.useDefault;
    }

    public boolean setDefault() {
        return this.setdefault;
    }

    public File getClasspath() {
        return this.classpath;
    }

    private void setClasspath(File s) {
        this.classpath = s;
    }

    public Class getExecutable() {
        return this.executable;
    }

    public AccessController getSecurityController() {
        return this.securityController;
    }

    public String getCrossDomainPolicy() {
        String result = "<cross-domain-policy>";
        if (this.allowDomains.size() > 0) {
            Iterator it = ((AbstractList)this.allowDomains).iterator();
            while (it.hasNext()) {
                AllowDomain allowDomain = (AllowDomain)it.next();
                result = String.valueOf(result) + "<allow-access-from domain=\"" + allowDomain.getDomain() + "\" to-ports=\"" + allowDomain.getPorts() + "\" />";
            }
        } else {
            result = String.valueOf(result) + "<allow-access-from domain=\"*\" to-ports=\"" + this.getPort() + "\" />";
        }
        result = String.valueOf(result) + "</cross-domain-policy>";
        return result;
    }

    public int getMessagesBufferSize() {
        return this.buffermax;
    }

    private void setMessagesBufferSize(int s) {
        this.buffermax = s;
    }

    public SockletDeployInfo getSyscomInfo() {
        return this.syscomInfo;
    }

    public Properties getLogProperties() {
        return this.logprops;
    }

    public List getLoggerNames() {
        return this.loggers;
    }

    public boolean setSysLog() {
        return this.setsyslog;
    }

    public void loadConfig() throws ConfigurationError {
        this.applications = new ArrayList();
        this.scriptsinfo = new ArrayList();
        this.setdefault = false;
        this.setsyslog = false;
        this.securityController = new AccessController();
        this.allowDomains = new ArrayList();
        try {
            this.createDigester().parse(this.configFile);
        }
        catch (IOException e) {
            throw new ConfigurationError("\u521d\u671f\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb(" + this.configFile.getAbsolutePath() + ")\u8aad\u8fbc\u6642\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\r\n" + e.toString());
        }
        catch (SAXException e) {
            throw new ConfigurationError("XML\u304c\u4e0d\u6b63\u3067\u3059\u3002\r\n" + e.toString());
        }
    }

    public void setSystemInfomation(String port, String encoding, String buffersize, String timeout, String usedef, String classpath, String exec) {
        int setport;
        block21: {
            try {
                setport = Integer.parseInt(port);
            }
            catch (Exception e) {
                setport = 0;
            }
            if (setport <= 0) {
                System.out.println("Port:" + port + " \u306f\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002");
                System.out.println("\u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u30dd\u30fc\u30c8\u756a\u53f7(9090)\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002");
                setport = 9090;
            }
            if (encoding == null || encoding.length() == 0) {
                System.out.println("\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                System.out.println("\u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002");
                encoding = DEFAULT_ENCODING;
            }
            if (classpath == null || classpath.length() == 0) {
                this.setClasspath(new File(gpsshome, "classes"));
                System.out.println("Socklet\u30af\u30e9\u30b9\u914d\u7f6e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                System.out.println("\u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u30af\u30e9\u30b9\u30d1\u30b9\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002");
                System.out.println("classpath:" + this.getClasspath().getAbsolutePath());
            } else {
                this.setClasspath(Configuration.getAbsolutePath(classpath));
            }
            if (this.executable == null) {
                try {
                    if (exec == null || exec.length() == 0) {
                        System.out.println("Executable\u30af\u30e9\u30b9\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                        System.out.println("\u30c7\u30d5\u30a9\u30eb\u30c8\u306eMain\u30af\u30e9\u30b9\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002");
                        System.out.println("executable: jp.wda.gpss.system.Main");
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("jp.wda.gpss.system.Main");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        this.executable = clazz;
                        break block21;
                    }
                    System.out.println("executable: " + exec);
                    this.executable = Class.forName(exec);
                }
                catch (ClassNotFoundException e) {
                    System.out.println("Executable\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
                    System.out.println("\u30c7\u30d5\u30a9\u30eb\u30c8\u306eMain\u30af\u30e9\u30b9\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002");
                    System.out.println("executable: jp.wda.gpss.system.Main");
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("jp.wda.gpss.system.Main");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    this.executable = clazz;
                }
            }
        }
        int bmax = 30;
        try {
            bmax = Integer.parseInt(buffersize);
        }
        catch (Throwable e) {
            bmax = 30;
        }
        int tout = 0;
        try {
            tout = Integer.parseInt(timeout);
        }
        catch (Throwable e) {
            tout = 0;
        }
        this.useDefault = usedef == null || !usedef.equalsIgnoreCase("invalidate");
        this.setPort(setport);
        this.setEncoding(encoding);
        this.setMessagesBufferSize(bmax);
        this.setTimeout(tout);
    }

    public void addAllowSystemCommand(String addr) {
        this.syscomInfo.addInitParam("allow", addr);
    }

    public void addLogProperty(String key, String value) {
        this.logprops.setProperty("log4j." + key, value);
        if (key.length() > 8 && "logger".equals(key.substring(0, 6))) {
            this.loggers.add(key.substring(7));
        }
    }

    public void addLogger(String name, String mode, String file, String encoding, String layoutPattern) {
        String appender = String.valueOf(name) + "Appender";
        String appnederKey = "log4j.appender." + appender;
        this.loggers.add(name);
        this.logprops.setProperty("log4j.logger." + name, String.valueOf(mode) + "," + appender);
        this.logprops.setProperty(appnederKey, "org.apache.log4j.DailyRollingFileAppender");
        this.logprops.setProperty(String.valueOf(appnederKey) + ".File", Configuration.getAbsolutePath(file).getAbsolutePath());
        this.logprops.setProperty(String.valueOf(appnederKey) + ".DatePattern", "'.'yyyy-MM-dd");
        this.logprops.setProperty(String.valueOf(appnederKey) + ".Encoding", encoding);
        this.logprops.setProperty(String.valueOf(appnederKey) + ".layout", "org.apache.log4j.PatternLayout");
        this.logprops.setProperty(String.valueOf(appnederKey) + ".layout.ConversionPattern", layoutPattern);
    }

    public void addSystemLogger(String mode, String file, String encoding, String layoutPattern) {
        this.setsyslog = true;
        this.addLogger("gpssSystemLogger", mode, file, encoding, layoutPattern);
    }

    public static File getAbsolutePath(String path) {
        File __file = new File(path);
        if (!__file.isAbsolute()) {
            __file = new File(gpsshome, path);
        }
        return __file;
    }

    public void setScriptInfomation(String ext, String enc, String dir, String jsclass) {
        ScriptInfo sinfo = new ScriptInfo();
        if (sinfo.setInfomation(ext, enc, dir, jsclass)) {
            this.scriptsinfo.add(sinfo);
        }
    }

    public List getScriptInfomations() {
        return this.scriptsinfo;
    }

    public ScriptInfo getScriptInfomation(String extention) {
        return (ScriptInfo)new SInfoFinder(extention).get(this.scriptsinfo);
    }

    public void setScriptInitParam(String app, String key, String value) {
        if (!this.scriptparams.containsKey(app)) {
            this.scriptparams.put(app, new SockletDeployInfo(app));
        }
        SockletDeployInfo appinfo = (SockletDeployInfo)this.scriptparams.get(app);
        appinfo.addInitParam(key, value);
    }

    public SockletDeployInfo getScriptApplicationInfo(String name) {
        if (this.scriptparams.containsKey(name)) {
            return (SockletDeployInfo)this.scriptparams.get(name);
        }
        return new SockletDeployInfo(name);
    }

    public void setSystemSecurity(String mode, String param) {
        if (mode == null) {
            System.out.println("mode\u5c5e\u6027\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        } else if (mode.equals("REJECT")) {
            System.out.println(String.valueOf(mode) + ":" + param);
            if (param != null) {
                this.securityController.regist(new IPAddressChecker(param, ClientChecker.REJECT, ClientChecker.CHAIN));
            }
        } else if (mode.equals("ACCEPT")) {
            System.out.println(String.valueOf(mode) + ":" + param);
            if (param != null) {
                this.securityController.regist(new IPAddressChecker(param, ClientChecker.ACCEPT, ClientChecker.CHAIN));
            }
        } else if (mode.equals("MAX_CONNECTION")) {
            System.out.println(String.valueOf(mode) + ":" + param);
            int connection = 0;
            if (param != null) {
                try {
                    connection = Integer.parseInt(param);
                    this.securityController.regist(new LimitedConnectionChecker(connection, ClientChecker.CHAIN, ClientChecker.REJECT));
                }
                catch (Exception e) {}
            }
        } else if (mode.equals("MAX_CONNECTION_PER_HOST")) {
            System.out.println(String.valueOf(mode) + ":" + param);
            int connection = 0;
            if (param != null) {
                try {
                    connection = Integer.parseInt(param);
                    this.securityController.regist(new LimitedConnectionPerHostChecker(connection, ClientChecker.CHAIN, ClientChecker.REJECT));
                }
                catch (Exception e) {}
            }
        } else {
            System.out.println(String.valueOf(mode) + ":" + param + "\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u307e\u305b\u3093");
        }
    }

    public void setAllowAccessFrom(String domain, String toPorts) {
        this.allowDomains.add(new AllowDomain(domain, toPorts));
    }

    public void addApplication(SockletDeployInfo app) {
        if (app.getClassname() == null || app.getClassname().length() == 0 || app.getName() == null || app.getName().length() == 0) {
            return;
        }
        if (app.getName().equals("Default")) {
            this.setdefault = true;
        } else {
            if (app.getName().equals("SystemCommandSocklet")) {
                System.out.println("\u914d\u5099\u540d\u300cSystemCommandSocklet\u300d\u306eSocklet\u306f\u914d\u5099\u3067\u304d\u307e\u305b\u3093\u3002");
                return;
            }
            if (app.getName().equals("BySystemServer")) {
                System.out.println("\u914d\u5099\u540d\u300cBySystemServer\u300d\u306eSocklet\u306f\u914d\u5099\u3067\u304d\u307e\u305b\u3093\u3002");
                return;
            }
        }
        if (app.getLogFile() != null) {
            this.addLogger(app.getName(), app.getLogMode(), app.getLogFile(), app.getLogEncoding(), app.getLogPattern());
        }
        this.applications.add(app);
    }

    public List getInformations() {
        return this.applications;
    }

    public SockletDeployInfo getInformation(String name) {
        return (SockletDeployInfo)new DInfoFinder(name).get(this.applications);
    }

    private Digester createDigester() {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.push((Object)this);
        digester.addCallMethod("XMLServer/system", "setSystemInfomation", 7);
        digester.addCallParam("XMLServer/system", 0, "port");
        digester.addCallParam("XMLServer/system", 1, "encoding");
        digester.addCallParam("XMLServer/system", 2, "buffersize");
        digester.addCallParam("XMLServer/system", 3, "timeout");
        digester.addCallParam("XMLServer/system", 4, "default");
        digester.addCallParam("XMLServer/system", 5, "classpath");
        digester.addCallParam("XMLServer/system", 6, "executable");
        digester.addCallMethod("XMLServer/system/command", "addAllowSystemCommand", 1);
        digester.addCallParam("XMLServer/system/command", 0, "allow");
        digester.addCallMethod("XMLServer/system/logger", "addSystemLogger", 4);
        digester.addCallParam("XMLServer/system/logger", 0, "mode");
        digester.addCallParam("XMLServer/system/logger", 1, "file");
        digester.addCallParam("XMLServer/system/logger", 2, "encoding");
        digester.addCallParam("XMLServer/system/logger", 3, "layoutPattern");
        digester.addCallMethod("XMLServer/log4j/property", "addLogProperty", 2);
        digester.addCallParam("XMLServer/log4j/property", 0, "key");
        digester.addCallParam("XMLServer/log4j/property", 1, "value");
        digester.addCallMethod("XMLServer/log4j/logger", "addLogger", 5);
        digester.addCallParam("XMLServer/log4j/logger", 0, "name");
        digester.addCallParam("XMLServer/log4j/logger", 1, "mode");
        digester.addCallParam("XMLServer/log4j/logger", 2, "file");
        digester.addCallParam("XMLServer/log4j/logger", 3, "encoding");
        digester.addCallParam("XMLServer/log4j/logger", 4, "layoutPattern");
        digester.addCallMethod("XMLServer/script", "setScriptInfomation", 4);
        digester.addCallParam("XMLServer/script", 0, "extention");
        digester.addCallParam("XMLServer/script", 1, "encoding");
        digester.addCallParam("XMLServer/script", 2, "dir");
        digester.addCallParam("XMLServer/script", 3, "class");
        digester.addCallMethod("XMLServer/script/init-param", "setScriptInitParam", 3);
        digester.addCallParam("XMLServer/script/init-param", 0, "application");
        digester.addCallParam("XMLServer/script/init-param", 1, "key");
        digester.addCallParam("XMLServer/script/init-param", 2, "value");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("jp.wda.gpss.SockletDeployInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        digester.addObjectCreate("XMLServer/socklet", (Class)clazz);
        digester.addSetNext("XMLServer/socklet", "addApplication");
        digester.addCallMethod("XMLServer/socklet", "setInformation", 3);
        digester.addCallParam("XMLServer/socklet", 0, "name");
        digester.addCallParam("XMLServer/socklet", 1, "class");
        digester.addCallParam("XMLServer/socklet", 2, "timeout");
        digester.addCallMethod("XMLServer/socklet/init-param", "addInitParam", 2);
        digester.addCallParam("XMLServer/socklet/init-param", 0, "key");
        digester.addCallParam("XMLServer/socklet/init-param", 1, "value");
        digester.addCallMethod("XMLServer/socklet/logger", "setLoggerInfo", 4);
        digester.addCallParam("XMLServer/socklet/logger", 0, "mode");
        digester.addCallParam("XMLServer/socklet/logger", 1, "file");
        digester.addCallParam("XMLServer/socklet/logger", 2, "encoding");
        digester.addCallParam("XMLServer/socklet/logger", 3, "layoutPattern");
        digester.addCallMethod("XMLServer/system/security", "setSystemSecurity", 2);
        digester.addCallParam("XMLServer/system/security", 0, "mode");
        digester.addCallParam("XMLServer/system/security", 1, "param");
        digester.addCallMethod("XMLServer/system/allow-access-from", "setAllowAccessFrom", 2);
        digester.addCallParam("XMLServer/system/allow-access-from", 0, "domain");
        digester.addCallParam("XMLServer/system/allow-access-from", 1, "to-ports");
        return digester;
    }

    private class AllowDomain {
        private String domain;
        private String ports;

        public AllowDomain(String domain, String ports) {
            this.domain = domain != null ? domain : "*";
            this.ports = ports != null ? ports : Integer.toString(Configuration.this.getPort());
        }

        public String getDomain() {
            return this.domain;
        }

        public String getPorts() {
            return this.ports;
        }
    }

    private class DInfoFinder
    extends Finder {
        public DInfoFinder(String name) {
            this.group.add(new DInfoFinderElement(true, name));
        }

        public Object getReturnValue(Object elem) {
            return elem;
        }

        private class DInfoFinderElement
        extends FinderElement {
            DInfoFinderElement(boolean not, String name) {
                super(not, name);
            }

            public Object getFindValue(Object elem) {
                if (!(elem instanceof SockletDeployInfo)) {
                    return null;
                }
                return ((SockletDeployInfo)elem).getName();
            }
        }
    }

    private class SInfoFinder
    extends Finder {
        public SInfoFinder(String extention) {
            this.group.add(new SInfoFinderElement(true, extention));
        }

        public Object getReturnValue(Object elem) {
            return elem;
        }

        private class SInfoFinderElement
        extends FinderElement {
            SInfoFinderElement(boolean not, String extention) {
                super(not, extention);
            }

            public Object getFindValue(Object elem) {
                if (!(elem instanceof ScriptInfo)) {
                    return null;
                }
                return ((ScriptInfo)elem).getExtention();
            }
        }
    }
}

