/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss.system;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.Iterator;
import jp.wda.gpss.Progress;
import jp.wda.gpss.Socklet;
import jp.wda.gpss.SockletDeployInfo;
import jp.wda.gpss.SockletDeployingException;
import jp.wda.gpss.system.Configuration;
import jp.wda.gpss.system.ConfigurationError;
import jp.wda.gpss.system.ExecutableBase;
import jp.wda.gpss.system.ScriptInfo;
import jp.wda.gpss.system.ScriptSocklet;
import jp.wda.gpss.system.SocketProcessorBase;
import jp.wda.gpss.system.SocketProcessorImplNio;
import jp.wda.gpss.system.SockletLoader;
import jp.wda.gpss.system.SystemCommandSocklet;

public class MainNio
extends ExecutableBase {
    private ServerSocketChannel serverChannel;
    private Selector selector;
    private boolean terminator = false;
    private ByteBuffer buffer = null;
    private ByteBuffer tempBuffer = null;
    private Charset codec = null;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage : ");
            System.out.println("  java jp.wda.gpss.system.Main config.xml");
            System.out.println("    config.xml - \u521d\u671f\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb");
            return;
        }
        File configfile = new File(args[0]);
        if (!configfile.exists()) {
            System.out.println("\u521d\u671f\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
            System.out.println("File : " + configfile.getAbsolutePath());
            return;
        }
        MainNio main = new MainNio(new Configuration(configfile));
    }

    private MainNio(Configuration config) {
        super(config);
    }

    protected void finalize() {
        if (this.terminator) {
            return;
        }
        Iterator it = this.getSocklets();
        while (it.hasNext()) {
            Socklet app = (Socklet)it.next();
            app.destroy();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void accept() {
        System.out.println("Starting server...");
        this.buffer = ByteBuffer.allocateDirect(4096);
        this.tempBuffer = ByteBuffer.allocateDirect(4096);
        this.codec = Charset.forName(this.getEncoding());
        serverSocket = null;
        try {
            try {
                this.serverChannel = ServerSocketChannel.open();
                serverSocket = this.serverChannel.socket();
                this.selector = Selector.open();
                serverSocket.bind(new InetSocketAddress(this.getPort()));
                this.serverChannel.configureBlocking(false);
                this.serverChannel.register(this.selector, 16);
                block8: while (true) {
                    n = this.selector.select();
                    if (!this.terminator) {
                        if (n == 0) continue;
                        it = this.selector.selectedKeys().iterator();
                        while (true) {
                            if (it.hasNext()) ** break;
                            continue block8;
                            key = it.next();
                            if (key.isAcceptable()) {
                                this.createSocketProcessor(this.selector, key);
                            }
                            if (key.isReadable()) {
                                this.readMessage(key);
                            }
                            it.remove();
                        }
                    }
                    break;
                }
            }
            catch (ClosedSelectorException cse) {
                this.getProgress().syslog("Selector closed.");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        catch (Throwable var6_7) {
            var5_8 = null;
            if (this.serverChannel != null) {
                try {
                    this.serverChannel.close();
                    this.selector.close();
                }
                catch (Exception var7_10) {
                    // empty catch block
                }
            }
            this.terminator = false;
            throw var6_7;
        }
        var5_9 = null;
        if (this.serverChannel != null) {
            try {
                this.serverChannel.close();
                this.selector.close();
            }
            catch (Exception var7_11) {
                // empty catch block
            }
        }
        this.terminator = false;
    }

    private void readMessage(SelectionKey key) throws IOException, InterruptedException {
        int length = 0;
        byte b = 0;
        SocketChannel socketChannel = (SocketChannel)key.channel();
        SocketProcessorImplNio client = (SocketProcessorImplNio)key.attachment();
        ((Buffer)this.buffer).clear();
        try {
            while ((length = socketChannel.read(this.buffer)) > 0) {
                String message;
                ((Buffer)this.buffer).flip();
                while (this.buffer.hasRemaining()) {
                    b = this.buffer.get();
                    if (b != 0) {
                        this.tempBuffer.put(b);
                        continue;
                    }
                    ((Buffer)this.tempBuffer).flip();
                    message = this.codec.decode(this.tempBuffer).toString();
                    client.setMessage(message, true);
                    ((Buffer)this.tempBuffer).clear();
                }
                if (b != 0) {
                    ((Buffer)this.tempBuffer).flip();
                    message = this.codec.decode(this.tempBuffer).toString();
                    client.setMessage(message, false);
                    ((Buffer)this.tempBuffer).clear();
                }
                ((Buffer)this.buffer).clear();
            }
        }
        catch (ClosedChannelException e) {
            this.getProgress().errlog("\u30bd\u30b1\u30c3\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059\u3002:" + client.getClientID());
        }
        if (length < 0) {
            client.terminate();
        }
    }

    private void createSocketProcessor(Selector selector, SelectionKey key) {
        SocketProcessorBase client = null;
        try {
            ServerSocketChannel server = (ServerSocketChannel)key.channel();
            SocketChannel channel = server.accept();
            Socket socket = channel.socket();
            this.getProgress().syslog("Create Client... " + socket.getInetAddress().getHostAddress());
            client = new SocketProcessorImplNio(this, channel, this.getEncoding(), this.getMessagesBufferSize());
            if (channel != null) {
                channel.configureBlocking(false);
                channel.register(selector, 1, client);
            }
            this.getProgress().syslog("Create Client... " + socket.getInetAddress().getHostAddress());
            socket.setSoTimeout(this.getInitialTimeout());
            socket.setSoTimeout(10);
            this.getProgress().syslog("Welcome " + client.getIPAddress() + "! (ID:" + client.getClientID() + ")");
        }
        catch (InterruptedIOException e) {
            this.getProgress().errlog("\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u8a2d\u5b9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002:" + client.getClientID(), e);
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    void shutdown(SystemCommandSocklet sys) {
        if (!this.checkSystemCommandSocklet(sys)) {
            return;
        }
        this.getProgress().syslog("Shutdown server...");
        Iterator it = this.getSocklets();
        while (it.hasNext()) {
            Socklet app = (Socklet)it.next();
            app.disconnectAllClients("Good by...");
            app.destroy();
        }
        this.terminator = true;
        try {
            this.serverChannel.close();
            this.selector.close();
        }
        catch (IOException ioe) {
            this.getProgress().syslog("Shutdown Failed!");
            return;
        }
        this.getProgress().syslog("Shutdown successfully!");
    }

    void restart(SystemCommandSocklet sys) {
        if (!this.checkSystemCommandSocklet(sys)) {
            return;
        }
        this.setRestartAfterShutdown();
        this.shutdown(sys);
    }

    boolean restartSocklet(SystemCommandSocklet sys, String name) {
        if (!this.checkSystemCommandSocklet(sys)) {
            return false;
        }
        this.getProgress().syslog("Restart socklet \"" + name + "\"");
        Socklet socklet = this.getSocklet(name);
        SockletDeployInfo info = null;
        String scriptExt = null;
        File scriptFile = null;
        SockletLoader loader = null;
        if (socklet != null && socklet instanceof ScriptSocklet) {
            scriptExt = ((ScriptSocklet)socklet).getExtention();
            scriptFile = ((ScriptSocklet)socklet).getScriptFile();
            ScriptInfo scrinfo = this.getScriptInfomation(scriptExt);
            if (scrinfo != null && scriptFile != null && scriptFile.exists()) {
                info = this.getScriptSockletInformation(name);
                info.addInitParam("source", scriptFile.getAbsolutePath());
                info.addInitParam("sourceEncoding", scrinfo.getEncoding());
                info.setClassname(scrinfo.getJSClass().getName());
            }
            loader = this.scriptLoader;
        } else {
            info = this.getSockletInformation(name);
        }
        if (info == null) {
            this.getProgress().syslog("Socket \"" + name + "\"'s infomation is not found.", Progress.ERROR);
            return false;
        }
        this.terminateSocklet(socklet, "Good by...");
        this.getProgress().syslog("Socklet\"" + info.getName() + "\"(" + info.getClassname() + ")\u3092\u914d\u5099\u3057\u307e\u3059\u3002");
        try {
            socklet = this.deployNewSocklet(info, "BySystemServer", loader);
            if (socklet instanceof ScriptSocklet) {
                ((ScriptSocklet)socklet).setExtention(scriptExt);
                ((ScriptSocklet)socklet).setScriptFile(scriptFile);
            }
        }
        catch (SockletDeployingException e) {
            this.getProgress().errlog("Socklet\u306e\u914d\u5099\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
            return false;
        }
        return true;
    }

    boolean reloadConfig(SystemCommandSocklet sys) {
        if (!this.checkSystemCommandSocklet(sys)) {
            return false;
        }
        System.out.println("Reload config...");
        try {
            this.loadConfig();
        }
        catch (ConfigurationError e) {
            this.getProgress().errlog("\u521d\u671f\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u518d\u8aad\u8fbc\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
            return false;
        }
        this.reloadSystemCommandInfo();
        System.out.println("Reload config successfully!");
        return true;
    }

    public Charset getCharCoder() {
        return this.codec;
    }
}

