/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss.system;

import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Set;
import jp.wda.gpss.AttributeException;
import jp.wda.gpss.Progress;
import jp.wda.gpss.SocketProcessor;
import jp.wda.gpss.Socklet;
import jp.wda.gpss.system.ExecutableBase;
import jp.wda.gpss.system.InitParamContainerImpl;
import jp.wda.gpss.util.PseudoUUID;

abstract class SocketProcessorBase
extends InitParamContainerImpl
implements SocketProcessor,
Serializable {
    protected ExecutableBase server;
    private String clientid;
    private String encoding;
    private String username;
    private String password;
    private String ipaddr;
    private int buffermax = 30;
    private Socklet application = null;
    private Hashtable attributes = null;
    private Progress progress;

    public SocketProcessorBase(ExecutableBase server, String encoding, int buffersize, String ipaddr) throws IOException {
        this.server = server;
        this.progress = server.getProgress();
        this.ipaddr = ipaddr;
        this.setClientID(new PseudoUUID(ipaddr).toString());
        this.setEncoding(encoding);
        this.setMessagesBufferSize(buffersize);
        this.attributes = new Hashtable();
    }

    public String getClientID() {
        return this.clientid;
    }

    private void setClientID(String s) {
        this.clientid = s;
    }

    public String getEncoding() {
        return this.encoding;
    }

    private void setEncoding(String s) {
        this.encoding = s;
    }

    public String getUserName() {
        return this.username;
    }

    public void setUserName(String s) {
        this.username = s;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String s) {
        this.password = s;
    }

    public String getIPAddress() {
        return this.ipaddr;
    }

    public void setMessagesBufferSize(int size) {
        this.buffermax = size;
    }

    int getMessagesBufferSize() {
        return this.buffermax;
    }

    Socklet getApplication() {
        return this.application;
    }

    public void setApplication(Socklet s) {
        this.application = s;
    }

    public void setAttribute(Object key, Object value) {
        this.attributes.put(key, value);
    }

    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    public Set getAttributes() {
        return this.attributes.entrySet();
    }

    public boolean containsAttributeKey(Object key) {
        return this.attributes.containsKey(key);
    }

    public Set getAttributeKeys() {
        return this.attributes.keySet();
    }

    public Object removeAttribute(Object key) {
        return this.attributes.remove(key);
    }

    public final void setAttribute(Object key, int value) {
        this.attributes.put(key, new Integer(value));
    }

    public final int getAttributeInt(Object key) throws AttributeException {
        Object ret = this.attributes.get(key);
        if (ret instanceof Integer) {
            return (Integer)ret;
        }
        throw new AttributeException("\u6307\u5b9a\u3055\u308c\u305f\u5c5e\u6027(" + key + ")\u306fint\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
    }

    public final void setAttribute(Object key, long value) {
        this.attributes.put(key, new Long(value));
    }

    public final long getAttributeLong(Object key) throws AttributeException {
        Object ret = this.attributes.get(key);
        if (ret instanceof Long) {
            return (Long)ret;
        }
        throw new AttributeException("\u6307\u5b9a\u3055\u308c\u305f\u5c5e\u6027(" + key + ")\u306flong\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
    }

    public final void setAttribute(Object key, double value) {
        this.attributes.put(key, new Double(value));
    }

    public final double getAttributeDouble(Object key) throws AttributeException {
        Object ret = this.attributes.get(key);
        if (ret instanceof Double) {
            return (Double)ret;
        }
        throw new AttributeException("\u6307\u5b9a\u3055\u308c\u305f\u5c5e\u6027(" + key + ")\u306fdouble\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
    }

    public final void setAttribute(Object key, boolean value) {
        this.attributes.put(key, new Boolean(value));
    }

    public final boolean getAttributeBoolean(Object key) throws AttributeException {
        Object ret = this.attributes.get(key);
        if (ret instanceof Boolean) {
            return (Boolean)ret;
        }
        throw new AttributeException("\u6307\u5b9a\u3055\u308c\u305f\u5c5e\u6027(" + key + ")\u306fboolean\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
    }

    Progress getProgress() {
        return this.progress;
    }

    String addInitParam(String keyvalue) {
        if (keyvalue == null || keyvalue.length() == 0) {
            return null;
        }
        int idx = keyvalue.indexOf("=");
        if (idx == 0) {
            return null;
        }
        String value = keyvalue.substring(idx + 1);
        this.addInitParam(keyvalue.substring(0, idx), value);
        return value;
    }

    void doInitialCommand(String command) {
        this.server.doInitialCommand(this, command);
    }

    void notifyToSystemCommandSocklet() {
        this.server.notifyToSystemCommandSocklet(this.application);
    }

    public abstract boolean send(String var1);

    public abstract void terminate();

    public abstract void terminate(String var1);

    public abstract boolean isTerminated();
}

