/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ArrayObject;
import FESI.Data.ArrayPrototype;
import FESI.Data.BuiltinFunctionObject;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.ObjectPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.Evaluator;

public class ArrayObject
extends BuiltinFunctionObject {
    private static final String JOINstring = "join".intern();
    private static final int JOINhash = JOINstring.hashCode();
    private static final String LENGTHstring = "length".intern();
    private static final int LENGTHhash = LENGTHstring.hashCode();
    private static final String ZEROstring = "0".intern();
    private static final int ZEROhash = ZEROstring.hashCode();

    private ArrayObject(ESObject eSObject, Evaluator evaluator) {
        super(eSObject, evaluator, "Array", 1);
    }

    public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
        return this.doConstruct(eSObject, eSValueArray);
    }

    public ESObject doConstruct(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
        ESObject eSObject2 = this.evaluator.getArrayPrototype();
        ArrayPrototype arrayPrototype = new ArrayPrototype(eSObject2, this.evaluator);
        if (eSValueArray.length > 1) {
            int n = 0;
            while (n < eSValueArray.length) {
                String string = Integer.toString(n);
                arrayPrototype.putProperty(string, eSValueArray[n], string.hashCode());
                ++n;
            }
        } else if (eSValueArray.length == 1) {
            ESValue eSValue = eSValueArray[0];
            if (eSValue.isNumberValue()) {
                eSValue.toInt32();
                arrayPrototype.putProperty(LENGTHstring, eSValue, LENGTHhash);
            } else {
                arrayPrototype.putProperty(ZEROstring, eSValue, ZEROhash);
            }
        }
        return arrayPrototype;
    }

    public static ArrayObject makeArrayObject(Evaluator evaluator, ObjectPrototype objectPrototype, FunctionPrototype functionPrototype) {
        ArrayPrototype arrayPrototype = new ArrayPrototype(objectPrototype, evaluator);
        ArrayObject arrayObject = new ArrayObject(functionPrototype, evaluator);
        try {
            arrayObject.putHiddenProperty("prototype", arrayPrototype);
            arrayObject.putHiddenProperty(LENGTHstring, new ESNumber(1.0));
            arrayPrototype.putHiddenProperty("constructor", arrayObject);
            arrayPrototype.putHiddenProperty("toString", new 1.ArrayPrototypeToString("toString", evaluator, functionPrototype));
            arrayPrototype.putHiddenProperty("join", new 1.ArrayPrototypeJoin("join", evaluator, functionPrototype));
            arrayPrototype.putHiddenProperty("reverse", new 1.ArrayPrototypeReverse("reverse", evaluator, functionPrototype));
            arrayPrototype.putHiddenProperty("sort", new 1.ArrayPrototypeSort("sort", evaluator, functionPrototype));
        }
        catch (EcmaScriptException ecmaScriptException) {
            ecmaScriptException.printStackTrace();
            throw new ProgrammingError(ecmaScriptException.getMessage());
        }
        evaluator.setArrayPrototype(arrayPrototype);
        return arrayObject;
    }

    static /* synthetic */ String access$0() {
        return JOINstring;
    }

    static /* synthetic */ int access$1() {
        return JOINhash;
    }

    static /* synthetic */ String access$2() {
        return LENGTHstring;
    }

    static /* synthetic */ int access$3() {
        return LENGTHhash;
    }
}

