/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.BooleanPrototype;
import FESI.Data.ESObject;
import FESI.Data.ESPrimitive;
import FESI.Data.ESValue;
import FESI.Exceptions.EcmaScriptException;
import FESI.Interpreter.Evaluator;

public final class ESBoolean
extends ESPrimitive {
    private static ESBoolean trueValue = new ESBoolean();
    private static ESBoolean falseValue = new ESBoolean();

    private ESBoolean() {
    }

    public static ESBoolean makeBoolean(boolean bl) {
        if (bl) {
            return trueValue;
        }
        return falseValue;
    }

    public String toDetailString() {
        return "ES:<" + (this == trueValue ? "true" : "false") + ">";
    }

    public int getTypeOf() {
        return 3;
    }

    public String getTypeofString() {
        return "boolean";
    }

    public String toString() {
        if (this == trueValue) {
            return "true";
        }
        return "false";
    }

    public double doubleValue() {
        return this == trueValue ? 1 : 0;
    }

    public boolean booleanValue() {
        return this == trueValue;
    }

    public ESValue toESBoolean() {
        return this;
    }

    public ESValue toESObject(Evaluator evaluator) throws EcmaScriptException {
        BooleanPrototype booleanPrototype = null;
        ESObject eSObject = evaluator.getBooleanPrototype();
        booleanPrototype = new BooleanPrototype(eSObject, evaluator);
        booleanPrototype.value = this;
        return booleanPrototype;
    }

    public Object toJavaObject() {
        return new Boolean(this == trueValue);
    }

    public boolean isBooleanValue() {
        return true;
    }
}

