/*
 * Decompiled with CFR 0.152.
 */
package FESI.Extensions;

import FESI.Data.BuiltinFunctionObject;
import FESI.Data.ESBeans;
import FESI.Data.ESBoolean;
import FESI.Data.ESLoader;
import FESI.Data.ESObject;
import FESI.Data.ESPackages;
import FESI.Data.ESString;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.GlobalObject;
import FESI.Exceptions.EcmaScriptException;
import FESI.Extensions.Extension;
import FESI.Interpreter.Evaluator;

public class JavaAccess
extends Extension {
    private Evaluator evaluator;

    public void initializeExtension(Evaluator evaluator) throws EcmaScriptException {
        this.evaluator = evaluator;
        GlobalObject globalObject = evaluator.getGlobalObject();
        FunctionPrototype functionPrototype = (FunctionPrototype)evaluator.getFunctionPrototype();
        globalObject.putHiddenProperty("javaTypeOf", new GlobalObjectJavaTypeOf("javaTypeOf", evaluator, functionPrototype));
        globalObject.putHiddenProperty("loadExtension", new GlobalObjectLoadExtension("loadExtension", evaluator, functionPrototype));
        ESPackages eSPackages = (ESPackages)evaluator.getPackageObject();
        String string = "java".intern();
        ESPackages eSPackages2 = (ESPackages)eSPackages.getProperty(string, string.hashCode());
        globalObject.putHiddenProperty("Packages", eSPackages);
        globalObject.putHiddenProperty(string, eSPackages2);
        ESBeans eSBeans = new ESBeans(evaluator);
        globalObject.putHiddenProperty("Beans", eSBeans);
    }

    class GlobalObjectJavaTypeOf
    extends BuiltinFunctionObject {
        GlobalObjectJavaTypeOf(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            JavaAccess.this = JavaAccess.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            if (eSValueArray.length > 0) {
                Object object = eSValueArray[0].toJavaObject();
                String string = object == null ? "null" : ESLoader.typeName(object.getClass());
                return new ESString(string);
            }
            return ESUndefined.theUndefined;
        }
    }

    class GlobalObjectLoadExtension
    extends BuiltinFunctionObject {
        GlobalObjectLoadExtension(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            JavaAccess.this = JavaAccess.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            Object object = null;
            if (eSValueArray.length > 0) {
                String string = eSValueArray[0].toString();
                object = this.evaluator.addExtension(string);
            }
            return ESBoolean.makeBoolean(object != null);
        }
    }
}

