/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;

class KamenrideSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox checkBox;
    private JComboBox riders;
    private List<Rider> riderList;

    KamenrideSelectionPanel(StatusBrowserModel model) {
        this.riderList = model.getKamenridedRiderList();
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createRigidArea(new Dimension(10, 10)));
        this.checkBox = new JCheckBox("\u30ab\u30e1\u30f3\u30e9\u30a4\u30c9");
        this.riders = new JComboBox();
        this.riders.setEnabled(false);
        Iterator<Rider> i = this.riderList.iterator();
        while (i.hasNext()) {
            this.riders.addItem(i.next().toString());
        }
        this.checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KamenrideSelectionPanel.this.riders.setEnabled(KamenrideSelectionPanel.this.checkBox.isSelected());
            }
        });
        this.add(this.checkBox);
        this.add(this.riders);
    }

    public void setCheckBoxEnabled(boolean enabled) {
        this.checkBox.setEnabled(enabled);
        if (!enabled) {
            this.checkBox.setSelected(false);
        }
        this.riders.setEnabled(this.checkBox.isSelected());
    }

    public boolean isSelected() {
        return this.checkBox.isSelected();
    }

    public Rider getSelectedRider() {
        Rider r = null;
        int index = this.riders.getSelectedIndex();
        if (this.isSelected() && index != -1) {
            r = this.riderList.get(index);
        }
        return r;
    }
}

