/*
 * HLog.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */
package jp.hrtdotnet.fw.util;

import org.apache.commons.logging.LogFactory;

/**
 * org.apache.commons.logging.LogB
 * ̃NX2006N_ł̃OSIɍ쐬Ă܂B
 * ̊mFLocale.JAPANŊmFĂ܂B
 * 
 * @version 2.0
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 2.0
 */
public class HLog {

    private org.apache.commons.logging.Log log = null;

    private HLog (Class cls) {
        log = LogFactory.getLog(cls);
    }

    /**
     * ÕCX^X𐶐܂B
     * 
     * @param cls OsNX
     * @return ÕCX^X
     * @since 2.0
     */
    public static HLog getInstance(Class cls) {
        return new HLog(cls);
    }

    /**
     * g[XOB
     * @param msg bZ[W
     * @since 2.0
     */
    public void trace(Object msg) {
        if (log.isTraceEnabled()) {
            log.trace(msg);
        }
    }

    /**
     * g[XOB
     * @param msg bZ[W
     * @param e O
     * @since 2.0
     */
    public void trace(Object msg, Throwable e) {
        if (log.isTraceEnabled()) {
            log.trace(msg, e);
        }
    }

    /**
     * g[XOB
     * u\bh - bZ[Wv̌`ŃOo͂܂B
     * @param method s̃\bh
     * @param msg bZ[W
     * @since 2.0
     */
    public void trace(String method, String msg) {
        if (log.isTraceEnabled()) {
            log.trace(method + " - " + msg);
        }
    }

    /**
     * g[XOB
     * u\bh - bZ[Wv̌`ŃOo͂܂B
     * @param method \bh
     * @param msg bZ[W
     * @param e O
     * @since 2.0
     */
    public void trace(String method, String msg, Throwable e) {
        if (log.isTraceEnabled()) {
            log.trace(method + " - " + msg, e);
        }
    }

    /**
     * fobOOB
     * @param msg bZ[W
     * @since 2.0
     */
    public void debug(Object msg) {
        if (log.isDebugEnabled()) {
            log.debug(msg);
        }
    }

    /**
     * fobOOB
     * @param msg bZ[W
     * @param e O
     * @since 2.0
     */
    public void debug(Object msg, Throwable e) {
        if (log.isDebugEnabled()) {
            log.debug(msg, e);
        }
    }

    /**
     * fobOOB
     * u\bh - bZ[Wv̌`ŃOo͂܂B
     * @param method \bh
     * @param msg bZ[W
     * @since 2.0
     */
    public void debug(String method, String msg) {
        if (log.isDebugEnabled()) {
            log.debug(method + " - " + msg);
        }
    }

    /**
     * fobOOB
     * u\bh - bZ[Wv̌`ŃOo͂܂B
     * @param method \bh
     * @param msg bZ[W
     * @param e O
     * @since 2.0
     */
    public void debug(String method, String msg, Throwable e) {
        if (log.isDebugEnabled()) {
            log.debug(method + " - " + msg, e);
        }
    }

    /**
     * 񃍃OB
     * @param msg bZ[W
     * @since 2.0
     */
    public void info(Object msg) {
        if (log.isInfoEnabled()) {
            log.info(msg);
        }
    }

    /**
     * 񃍃OB
     * @param msg bZ[W
     * @param e O
     * @since 2.0
     */
    public void info(Object msg, Throwable e) {
        if (log.isInfoEnabled()) {
            log.info(msg, e);
        }
    }

    /**
     * 񃍃OB
     * u\bh - bZ[Wv̌`ŃOo͂܂B
     * @param method \bh
     * @param msg bZ[W
     * @since 2.0
     */
    public void info(String method, String msg) {
        if (log.isInfoEnabled()) {
            log.info(method + " - " + msg);
        }
    }

    /**
     * 񃍃OB
     * u\bh - bZ[Wv̌`ŃOo͂܂B
     * @param method \bh
     * @param msg bZ[W
     * @param e O
     * @since 2.0
     */
    public void info(String method, String msg, Throwable e) {
        if (log.isInfoEnabled()) {
            log.info(method + " - " + msg, e);
        }
    }


    /**
     * xOB
     * @param msg bZ[W
     * @since 2.0
     */
    public void warn(Object msg) {
        if (log.isWarnEnabled()) {
            log.warn(msg);
        }
    }

    /**
     * xOB
     * @param msg bZ[W
     * @param e O
     * @since 2.0
     */
    public void warn(Object msg, Throwable e) {
        if (log.isWarnEnabled()) {
            log.warn(msg, e);
        }
    }

    /**
     * xOB
     * u\bh - bZ[Wv̌`ŃOo͂܂B
     * @param method \bh
     * @param msg bZ[W
     * @since 2.0
     */
    public void warn(String method, String msg) {
        if (log.isWarnEnabled()) {
            log.warn(method + " - " + msg);
        }
    }

    /**
     * xOB
     * u\bh - bZ[Wv̌`ŃOo͂܂B
     * @param method \bh
     * @param msg bZ[W
     * @param e O
     * @since 2.0
     */
    public void warn(String method, String msg, Throwable e) {
        if (log.isWarnEnabled()) {
            log.warn(method + " - " + msg, e);
        }
    }

    /**
     * G[OB
     * @param msg bZ[W
     * @since 2.0
     */
    public void error(Object msg) {
        if (log.isErrorEnabled()) {
            log.error(msg);
        }
    }

    /**
     * G[OB
     * @param msg bZ[W
     * @param e O
     * @since 2.0
     */
    public void error(Object msg, Throwable e) {
        if (log.isErrorEnabled()) {
            log.error(msg, e);
        }
    }

    /**
     * G[OB
     * u\bh - bZ[Wv̌`ŃOo͂܂B
     * @param method \bh
     * @param msg bZ[W
     * @since 2.0
     */
    public void error(String method, String msg) {
        if (log.isErrorEnabled()) {
            log.error(method + " - " + msg);
        }
    }

    /**
     * G[OB
     * u\bh - bZ[Wv̌`ŃOo͂܂B
     * @param method \bh
     * @param msg bZ[W
     * @param e O
     * @since 2.0
     */
    public void error(String method, String msg, Throwable e) {
        if (log.isErrorEnabled()) {
            log.error(method + " - " + msg, e);
        }
    }

    /**
     * vIȃOB
     * @param msg bZ[W
     * @since 2.0
     */
    public void fatal(Object msg) {
        if (log.isFatalEnabled()) {
            log.fatal(msg);
        }
    }

    /**
     * vIȃOB
     * @param msg bZ[W
     * @param e O
     * @since 2.0
     */
    public void fatal(Object msg, Throwable e) {
        if (log.isFatalEnabled()) {
            log.fatal(msg, e);
        }
    }

    /**
     * vIȃOB
     * u\bh - bZ[Wv̌`ŃOo͂܂B
     * @param method \bh
     * @param msg bZ[W
     * @since 2.0
     */
    public void fatal(String method, String msg) {
        if (log.isFatalEnabled()) {
            log.fatal(method + " - " + msg);
        }
    }

    /**
     * vIȃOB
     * u\bh - bZ[Wv̌`ŃOo͂܂B
     * @param method \bh
     * @param msg bZ[W
     * @param e O
     * @since 2.0
     */
    public void fatal(String method, String msg, Throwable e) {
        if (log.isFatalEnabled()) {
            log.fatal(method + " - " + msg, e);
        }
    }

}
