/*
 * HSimpleMailTest.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */

package jp.hrtdotnet.fw.util.mail;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.mail.Authenticator;
import javax.mail.internet.InternetAddress;

import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;

import jp.hrtdotnet.java.HTestCase;

/**
 *
 * @version 
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 
 */
public class HSimpleSendMailTest extends HTestCase {

    private HSendMailServerModel serverModel = null;
    private boolean gmail = testClassResources.getBoolean("gmail");
    private boolean send = testClassResources.getBoolean("send");
    private String fromAddress = null;
    private String fromName = null;
    private String toAddress = null;
    private String toName = null;
    private String ccAddress = null;
    private String ccName = null;
    private String bccAddress = null;
    private String bccName = null;
    private String replyToAddress = null;
    private String replyToName = null;
    private String[] addressArray = null;
    private String[] nameArray = null;
    private List addressList = null;
    private List nameList = null;
    private boolean debug = false;
    private HSimpleSendMail mail = null;
    
    private String msgFormatFile1 = null;
    private Date sentDate = Calendar.getInstance().getTime();
    
    private boolean junit = testClassResources.getBoolean("junit");
    
    /* ( Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
        
        String hostName = null;
        int smtpPort = 0;
        String userName = null;
        String password = null;
        boolean auth = false;
        boolean tls = false;
        boolean ssl = false;
        
        if (gmail) {
            hostName = "smtp.gmail.com";
            smtpPort = 587;
            userName = testClassResources.getString("username.gmail");
            password = testClassResources.getString("password.gmail");
            auth = true;
            tls = true;
            ssl = true;
        } else {
            hostName = testClassResources.getString("hostname");
            smtpPort = testClassResources.getInt("smtpport");
            userName = testClassResources.getString("username");
            password = testClassResources.getString("password");
            auth = testClassResources.getBoolean("auth");
            tls = testClassResources.getBoolean("tls");
            ssl = testClassResources.getBoolean("ssl");
        }
        serverModel = new HSendMailServerModel(hostName, smtpPort);
        serverModel.setAuthentication(userName, password);
        serverModel.setAuth(auth);
        serverModel.setTls(tls);
        serverModel.setSslSmtp(ssl);

        fromAddress = testClassResources.getString("from.address");
        fromName = testClassResources.getString("from.name");
        toAddress = testClassResources.getString("to.address");
        toName = testClassResources.getString("to.name");
        ccAddress = testClassResources.getString("cc.address");
        ccName = testClassResources.getString("cc.name");
        bccAddress = testClassResources.getString("bcc.address");
        bccName = testClassResources.getString("bcc.name");
        replyToAddress = testClassResources.getString("replyto.address");
        replyToName = testClassResources.getString("replyto.name");
        debug = testClassResources.getBoolean("debug");
        msgFormatFile1 = testClassResources.getString("msg.format.file1");
        
        String address1 = testClassResources.getString("array1.address");
        String address2 = testClassResources.getString("array2.address");
        String address3 = testClassResources.getString("array3.address");
        String name1 = testClassResources.getString("array1.name");
        String name2 = testClassResources.getString("array2.name");
        String name3 = testClassResources.getString("array3.name");
        if (address1 != null && address1.length() != 0) {
            addressArray = new String[]{address1, address2, address3};
            nameArray = new String[]{name1, name2, name3};
            addressList = new ArrayList();
            addressList.add(address1);
            addressList.add(address2);
            addressList.add(address3);
            nameList = new ArrayList();
            nameList.add(name1);
            nameList.add(name2);
            nameList.add(name3);
        }
        
        mail = new HSimpleSendMail();

    }

    /* ( Javadoc)
     * @see junit.framework.TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSimpleSendMail#send()} ̂߂̃eXgE\bhB
     * @throws HMailException 
     * @throws EmailException 
     * @throws IOException 
     * @throws FileNotFoundException 
     * @throws UnsupportedEncodingException 
     */
    public void testSend() throws HMailException, EmailException, UnsupportedEncodingException, FileNotFoundException, IOException {

        if (send == false) {
            return;
        }

        mail = new HSimpleSendMail();
        mail.setServerModel(serverModel);
        mail.setDebug(debug);
        mail.setFrom(fromAddress, fromName);
        mail.setTo(toAddress, toName);
        if (ccAddress != null && ccAddress.length() != 0) {
            mail.setCc(ccAddress, ccName);
        }
        if (bccAddress != null && bccAddress.length() != 0) {
            mail.setBcc(bccAddress, bccName);
        }
        mail.setSubject("[MeXgł");
        mail.setMsg("bZ[W̃eXgłB\r\n\r\n[MeXgłB\r\n͂Ă܂ł傤H");
        mail.send();

        mail = new HSimpleSendMail();
        mail.setServerModel(serverModel);
        mail.setDebug(debug);
        mail.setFrom(fromAddress, null);
        mail.setTo(toAddress);
        mail.setSubject("[MeXgłQ");
        mail.setMsg(new File(msgFormatFile1), "MS932", "\r\n", new String[]{"eX^[P","tH[}bg̃eXgP"});
        mail.send();

        mail = new HSimpleSendMail();
        mail.setServerModel(serverModel);
        mail.setDebug(debug);
        mail.setFrom(fromAddress, fromName);
        mail.setTo(addressArray, nameArray);
        mail.setSubject("[MeXgłR");
        mail.setMsgFormat(new File(msgFormatFile1), "MS932", "\r\n");
        mail.setMsgFormatParams( new String[]{"eX^[Q","tH[}bg̃eXgQ"});
        mail.send();

        mail = new HSimpleSendMail();
        mail.setServerModel(serverModel);
        mail.setDebug(debug);
        mail.setFrom(fromAddress, fromName);
        mail.setTo(addressArray);
        mail.setSubject("[MeXgłS");
        mail.setMsgFormat(new File(msgFormatFile1), "MS932", "\r\n");
        mail.send();

        mail = new HSimpleSendMail();
        mail.setServerModel(serverModel);
        mail.setDebug(debug);
        mail.setFrom(fromAddress, fromName);
        mail.setTo(toAddress, toName);
        mail.setCc(addressArray, nameArray);
        mail.setSubject("[MeXgłT");
        mail.setMsgFormat(new File(msgFormatFile1), "MS932");
        mail.send();
    
        mail = new HSimpleSendMail();
        mail.setServerModel(serverModel);
        mail.setDebug(debug);
        mail.setFrom(fromAddress, fromName);
        mail.setTo(toAddress, toName);
        mail.setBcc(addressArray, nameArray);
        mail.setReplyTo(replyToAddress, replyToName);
        mail.setSubject("[MeXgłU");
        mail.setMsg(new File(msgFormatFile1), "MS932",  new String[]{"eX^[T","tH[}bg̃eXgT"});
        mail.send();

        mail = new HSimpleSendMail();
        mail.setServerModel(serverModel);
        mail.setDebug(debug);
        mail.setFrom(fromAddress, fromName);
        mail.setTo(toAddress, toName);
        mail.setCc(addressArray);
        mail.setReplyTo(replyToAddress);
        mail.setSubject("[MeXgłV");
        mail.setMsg("hoge1");
        mail.send();
    
        mail = new HSimpleSendMail();
        mail.setServerModel(serverModel);
        mail.setDebug(debug);
        mail.setFrom(fromAddress, fromName);
        mail.setTo(toAddress, toName);
        mail.setBcc(addressArray);
        mail.setReplyTo(addressArray);
        mail.setSubject("[MeXgłW");
        mail.setMsg("hoge2");
        mail.send();

        mail = new HSimpleSendMail();
        mail.setServerModel(serverModel);
        mail.setDebug(debug);
        mail.setFrom(fromAddress, fromName);
        mail.setTo(addressList, nameList);
        mail.setReplyTo(addressArray, nameArray);
        mail.setSubject("[MeXgłX");
        mail.setMsg("hoge3");
        mail.send();

        mail = new HSimpleSendMail();
        mail.setServerModel(serverModel);
        mail.setDebug(debug);
        mail.setFrom(fromAddress, fromName);
        mail.setTo(addressList);
        mail.setReplyTo(addressList, nameList);
        mail.setSubject("[MeXgłPO");
        mail.setMsg("hoge4");
        mail.send();

        mail = new HSimpleSendMail();
        mail.setServerModel(serverModel);
        mail.setDebug(debug);
        mail.setFrom(fromAddress, fromName);
        mail.setTo(toAddress, toName);
        mail.setCc(addressList, nameList);
        mail.setReplyTo(addressList);
        mail.setSubject("[MeXgłPP");
        mail.setMsg("hoge5");
        mail.send();

        mail = new HSimpleSendMail();
        mail.setServerModel(serverModel);
        mail.setDebug(debug);
        mail.setFrom(fromAddress, fromName);
        mail.setTo(toAddress, toName);
        mail.setCc(addressList);
        mail.setSubject("[MeXgłPQ");
        mail.setMsg("hoge6");
        mail.send();

        mail = new HSimpleSendMail();
        mail.setServerModel(serverModel);
        mail.setDebug(debug);
        mail.setFrom(fromAddress, fromName);
        mail.setTo(toAddress, toName);
        mail.setBcc(addressList, nameList);
        mail.setSubject("[MeXgłPQ");
        mail.setMsg("hoge7");
        mail.send();

        mail = new HSimpleSendMail();
        mail.setServerModel(serverModel);
        mail.setDebug(debug);
        mail.setFrom(fromAddress, fromName);
        mail.setTo(toAddress, toName);
        mail.setBcc(addressList);
        mail.setSubject("[MeXgłPR");
        mail.setMsg("hoge8");
        mail.send();
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSimpleSendMail#HSimpleMail()} ̂߂̃eXgE\bhB
     */
    public void testHSimpleMail() {
        new HSimpleSendMail();
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSimpleSendMail#HSimpleMail(jp.hrtdotnet.fw.util.mail.HSendMailServerModel)} ̂߂̃eXgE\bhB
     */
    public void testHSimpleMailHMailServerModel() {
        new HSimpleSendMail(serverModel);
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#checkMailAddress(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testCheckMailAddress() {
        //Ȃ̂ŕsv
//        mail.checkMailAddress(mailAddress);
    }

    private HSendMail setServerInfo1() {
        HSendMail mail = new HSimpleSendMail();
        HSendMailServerModel model = new HSendMailServerModel("localhost1", 101);
        model.setAuth(true);
        model.setAuthentication("user1", "password1");
        model.setSslSmtp(true);
        model.setSslSmtpPort(1001);
        model.setTls(true);
        mail.setServerModel(model);
        return mail;
    }
    private HSendMail setServerInfo2() {
        HSendMail mail = new HSimpleSendMail();
        HSendMailServerModel model = new HSendMailServerModel("localhost2", 102);
        model.setAuth(false);
        model.setAuthentication("user2", "password2");
        model.setSslSmtp(false);
        model.setSslSmtpPort(1002);
        model.setTls(false);
        mail.setServerModel(model);
        return mail;
    }
    private HSendMail setServerInfo3() {
        HSendMail mail = new HSimpleSendMail();
        HSendMailServerModel model = new HSendMailServerModel("localhost3", 103);
        model.setAuth(true);
        model.setAuthenticator(new DefaultAuthenticator("user3", "password3"));
        model.setSslSmtp(true);
        model.setSslSmtpPort(1003);
        model.setTls(true);
        mail.setServerModel(model);
        return mail;
    }
    private HSendMail setServerInfo4() {
        HSendMail mail = new HSimpleSendMail();
        HSendMailServerModel model = new HSendMailServerModel("localhost4", 104);
        model.setAuth(true);
        model.setAuthenticator(new DefaultAuthenticator("user41", "password41"));
        model.setAuthentication("user42", "password42");
        model.setSslSmtp(true);
        model.setSslSmtpPort(1004);
        model.setTls(true);
        mail.setServerModel(model);
        return mail;
    }
    private HSendMail setServerInfo5() {
        HSendMail mail = new HSimpleSendMail();
        HSendMailServerModel model = new HSendMailServerModel("localhost5", 105);
        model.setAuth(true);
        model.setUserName("user5");
        model.setPassword("password5");
        model.setSslSmtp(true);
        model.setSslSmtpPort(1005);
        model.setTls(true);
        mail.setServerModel(model);
        return mail;
    }

    private HSendMail setServerInfo11() {
        HSendMail mail = new HSimpleSendMail();
        mail.setHostName("localhost11");
        mail.setSmtpPort(111);
        mail.setAuth(true);
        mail.setUserName("user11");
        mail.setPassword("password11");
        mail.setSslSmtp(true);
        mail.setSslSmtpPort(1011);
        mail.setTls(true);
        return mail;
    }
    private HSendMail setServerInfo12() {
        HSendMail mail = new HSimpleSendMail();
        mail.setHostName("localhost12");
        mail.setSmtpPort(112);
        mail.setAuth(false);
        mail.setUserName("user12");
        mail.setPassword("password12");
        mail.setSslSmtp(false);
        mail.setSslSmtpPort(1012);
        mail.setTls(false);
        return mail;
    }
    private HSendMail setServerInfo13() {
        HSendMail mail = new HSimpleSendMail();
        mail.setHostName("localhost13");
        mail.setSmtpPort(113);
        mail.setAuth(true);
        mail.setAuthenticator(new DefaultAuthenticator("user13", "password13"));
        mail.setSslSmtp(true);
        mail.setSslSmtpPort(1013);
        mail.setTls(true);
        return mail;
    }

    private HSendMail setServerInfo21() {
        HSendMail mail = new HSimpleSendMail();
        HSendMailServerModel model = new HSendMailServerModel("localhost21", 121);
        model.setAuth(true);
        model.setAuthentication("user21", "password21");
        model.setSslSmtp(true);
        model.setSslSmtpPort(1021);
        model.setTls(true);
        model.setPopBeforeSmtp(true);
        model.setPopHostName("pop.localhost21");
        model.setPopUserName("popuser21");
        model.setPopPassword("poppassword21");
        mail.setServerModel(model);
        return mail;
    }
    
    private HSendMail setServerInfo22() {
        HSendMail mail = new HSimpleSendMail();
        HSendMailServerModel model = new HSendMailServerModel("localhost22", 122);
        model.setAuth(true);
        model.setAuthentication("user22", "password22");
        model.setSslSmtp(true);
        model.setSslSmtpPort(1022);
        model.setTls(true);
        model.setPopBeforeSmtp(false);
        model.setPopHostName("pop.localhost22");
        model.setPopUserName("popuser22");
        model.setPopPassword("poppassword22");
        mail.setServerModel(model);
        return mail;
    }

    private HSendMail setServerInfo23() {
        HSendMail mail = new HSimpleSendMail();
        mail.setHostName("localhost123");
        mail.setSmtpPort(123);
        mail.setAuth(true);
        mail.setUserName("user23");
        mail.setPassword("password23");
        mail.setSslSmtp(true);
        mail.setSslSmtpPort(1023);
        mail.setTls(true);
        mail.setPopBeforeSmtp(true);
        mail.setPopHostName("pop.localhost23");
        mail.setPopUserName("popuser23");
        mail.setPopPassword("poppassword23");
        return mail;
    }
    
    private HSendMail setServerInfo24() {
        HSendMail mail = new HSimpleSendMail();
        mail.setHostName("localhost124");
        mail.setSmtpPort(124);
        mail.setAuth(true);
        mail.setUserName("user24");
        mail.setPassword("password24");
        mail.setSslSmtp(true);
        mail.setSslSmtpPort(1024);
        mail.setTls(true);
        mail.setPopBeforeSmtp(false);
        mail.setPopHostName("pop.localhost24");
        mail.setPopUserName("popuser24");
        mail.setPopPassword("poppassword24");
        return mail;
    }
    
    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setServerInfo(org.apache.commons.mail.Email)} ̂߂̃eXgE\bhB
     * @throws HMailException 
     */
    public void testSetServerInfo() throws HMailException {

        HSendMail mail = null;
        SimpleEmail mail2 = null;

        mail2 = new SimpleEmail();

        //ݒmF
        mail = setServerInfo1();
        mail.setServerInfo(mail2);
        assertEquals("localhost1", mail2.getHostName());
        assertEquals("101", mail2.getSmtpPort());
        assertEquals(true, mail2.isSSL());
        assertEquals("1001", mail2.getSslSmtpPort());
        assertEquals(true, mail2.isTLS());
        
        mail = setServerInfo2();
        mail.setServerInfo(mail2);
        assertEquals("localhost2", mail2.getHostName());
        assertEquals("102", mail2.getSmtpPort());
        assertEquals(false, mail2.isSSL());
        assertEquals("1002", mail2.getSslSmtpPort());
        assertEquals(false, mail2.isTLS());

        mail = setServerInfo1();
        mail.setServerInfo(mail2);
        assertEquals("localhost1", mail2.getHostName());
        assertEquals("101", mail2.getSmtpPort());
        assertEquals(true, mail2.isSSL());
        assertEquals("1001", mail2.getSslSmtpPort());
        assertEquals(true, mail2.isTLS());
        
        mail = setServerInfo3();
        mail.setServerInfo(mail2);

        mail = setServerInfo4();
        mail.setServerInfo(mail2);

        mail = setServerInfo5();
        mail.setServerInfo(mail2);

        mail = setServerInfo11();
        mail.setServerInfo(mail2);
        assertEquals("localhost11", mail2.getHostName());
        assertEquals("111", mail2.getSmtpPort());
        assertEquals(true, mail2.isSSL());
        assertEquals("1011", mail2.getSslSmtpPort());
        assertEquals(true, mail2.isTLS());
        
        mail = setServerInfo12();
        mail.setServerInfo(mail2);
        assertEquals("localhost12", mail2.getHostName());
        assertEquals("112", mail2.getSmtpPort());
        assertEquals(false, mail2.isSSL());
        assertEquals("1012", mail2.getSslSmtpPort());
        assertEquals(false, mail2.isTLS());
        
        mail = setServerInfo11();
        mail.setServerInfo(mail2);
        assertEquals("localhost11", mail2.getHostName());
        assertEquals("111", mail2.getSmtpPort());
        assertEquals(true, mail2.isSSL());
        assertEquals("1011", mail2.getSslSmtpPort());
        assertEquals(true, mail2.isTLS());
        
        mail = setServerInfo13();
        mail.setServerInfo(mail2);

        mail = setServerInfo21();
        mail.setServerInfo(mail2);
        mail = setServerInfo22();
        mail.setServerInfo(mail2);
        mail = setServerInfo23();
        mail.setServerInfo(mail2);
        mail = setServerInfo24();
        mail.setServerInfo(mail2);
        
        //`FbN
        try {
            mail = new HSimpleSendMail();
            mail2 = new SimpleEmail();
            mail.setServerInfo(mail2);
            fail();
        } catch (HMailException e) {
            if (junit) {
                assertEquals("Host-name is null.", e.getMessage());
            }
        }

//        try {
//            mail = new HSimpleMail();
//            mail2 = new SimpleEmail();
//            mail.setHostName("");
//            mail.setServerInfo(mail2);
//            fail();
//        } catch (HMailException e) {
//            if (junit) {
//                assertEquals("Host-name is empty-string.", e.getMessage());
//            }
//        }
        
//        try {
//            mail = new HSimpleMail();
//            mail2 = new SimpleEmail();
//            mail.setHostName("localhost");
//            mail.setServerInfo(mail2);
//            fail();
//        } catch (HMailException e) {
//            if (junit) {
//                assertEquals("Host-name is null.", e.getMessage());
//            }
//        }

        
    }

    private HSendMail setSendInfo1() {
        HSendMail mail = new HSimpleSendMail();
        mail.setTo(toAddress, toName);
        mail.setCc(ccAddress, ccName);
        mail.setBcc(bccAddress, bccName);
        mail.setFrom(fromAddress, fromName);
        mail.setReplyTo(replyToAddress, replyToName);
        mail.setCharset("MS932");
        mail.setSubject("subject1");
        mail.setMsg("msg1");
        mail.setSentDate(sentDate);
        return mail;
    }
    
    private HSendMail setSendInfo2() {
        HSendMail mail = new HSimpleSendMail();
        mail.setTo(toAddress);
        mail.setCc(ccAddress);
        mail.setBcc(bccAddress);
        mail.setFrom(fromAddress);
        mail.setReplyTo(replyToAddress);
        mail.setCharset("MS932");
        return mail;
    }

    private HSendMail setSendInfo3() {
        HSendMail mail = new HSimpleSendMail();
        mail.setTo(toAddress);
        mail.setFrom(fromAddress);
        return mail;
    }
    
    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setSendInfo(org.apache.commons.mail.Email)} ̂߂̃eXgE\bhB
     * @throws HMailException 
     */
    public void testSetSendInfo() throws HMailException {
        HSendMail mail = null;
        SimpleEmail mail2 = null;

        mail = setSendInfo1();
        mail2 = new SimpleEmail();
        mail.setSendInfo(mail2);
        List to = mail2.getToAddresses();
        List cc = mail2.getCcAddresses();
        List bcc = mail2.getBccAddresses();
        InternetAddress from = mail2.getFromAddress();
        List replyTo = mail2.getReplyToAddresses();
        assertEquals(toName + " <" + toAddress + ">", ((InternetAddress) to.get(0)).toString());
        assertEquals(ccName + " <" + ccAddress + ">", ((InternetAddress) cc.get(0)).toString());
        assertEquals(bccName + " <" + bccAddress + ">", ((InternetAddress) bcc.get(0)).toString());
        assertEquals(fromName + " <" + fromAddress + ">", from.toString());
        assertEquals(replyToName + " <" + replyToAddress + ">", ((InternetAddress) replyTo.get(0)).toString());
        assertEquals("subject1", mail2.getSubject());
        assertEquals(sentDate.getTime(), mail2.getSentDate().getTime());

        mail = setSendInfo2();
        mail2 = new SimpleEmail();
        mail.setSendInfo(mail2);
        to = mail2.getToAddresses();
        cc = mail2.getCcAddresses();
        bcc = mail2.getBccAddresses();
        from = mail2.getFromAddress();
        replyTo = mail2.getReplyToAddresses();
        assertEquals("\"" + toAddress + "\"" + " <" + toAddress + ">", ((InternetAddress) to.get(0)).toString());
        assertEquals("\"" + ccAddress + "\"" + " <" + ccAddress + ">", ((InternetAddress) cc.get(0)).toString());
        assertEquals("\"" + bccAddress + "\"" + " <" + bccAddress + ">", ((InternetAddress) bcc.get(0)).toString());
        assertEquals("\"" + fromAddress + "\"" + " <" + fromAddress + ">", from.toString());
        assertEquals("\"" + replyToAddress + "\"" + " <" + replyToAddress + ">", ((InternetAddress) replyTo.get(0)).toString());
        assertEquals("", mail2.getSubject());
        assertNotNull(mail2.getSentDate());
        
        mail = setSendInfo3();
        mail2 = new SimpleEmail();
        mail.setSendInfo(mail2);
        to = mail2.getToAddresses();
        from = mail2.getFromAddress();
        assertEquals("\"" + toAddress + "\"" + " <" + toAddress + ">", ((InternetAddress) to.get(0)).toString());
        assertEquals(0, mail2.getCcAddresses().size());
        assertEquals(0, mail2.getBccAddresses().size());
        assertEquals("\"" + fromAddress + "\"" + " <" + fromAddress + ">", from.toString());
        assertEquals(0, mail2.getReplyToAddresses().size());
        assertEquals("", mail2.getSubject());
        assertNotNull(mail2.getSentDate());
        
        try {
            mail = new HSimpleSendMail();
            mail2 = new SimpleEmail();
            mail.setCharset(null);
            mail.setSendInfo(mail2);
            fail();
        } catch (HMailException e) {
            if (junit) {
                assertEquals("charset is null.", e.getMessage());
            }
        }

        try {
            mail = new HSimpleSendMail();
            mail2 = new SimpleEmail();
            mail.setCharset("");
            mail.setSendInfo(mail2);
            fail();
        } catch (HMailException e) {
            if (junit) {
                assertEquals("charset is un-supported.", e.getMessage());
            }
        }

        try {
            mail = new HSimpleSendMail();
            mail2 = new SimpleEmail();
            mail.setCharset("xxxxxxxxxxx");
            mail.setSendInfo(mail2);
            fail();
        } catch (HMailException e) {
            if (junit) {
                assertEquals("charset is un-supported.", e.getMessage());
            }
        }

        try {
            mail = new HSimpleSendMail();
            mail2 = new SimpleEmail();
            mail.setCharset("MS932");
            mail.setSendInfo(mail2);
            fail();
        } catch (HMailException e) {
            if (junit) {
                assertEquals("from is null.", e.getMessage());
            }
        }
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#getServerModel()} ̂߂̃eXgE\bhB
     */
    public void testGetServerModel() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setServerModel(jp.hrtdotnet.fw.util.mail.HSendMailServerModel)} ̂߂̃eXgE\bhB
     */
    public void testSetServerModel() {
        mail.setServerModel(serverModel);
        assertSame(serverModel, mail.getServerModel());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#isAuth()} ̂߂̃eXgE\bhB
     */
    public void testIsAuth() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setAuth(boolean)} ̂߂̃eXgE\bhB
     */
    public void testSetAuth() {
        mail.setAuth(true);
        assertTrue(mail.isAuth());
        mail.setAuth(false);
        assertFalse(mail.isAuth());
        mail.setAuth(true);
        assertTrue(mail.isAuth());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#getHostName()} ̂߂̃eXgE\bhB
     */
    public void testGetHostName() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setHostName(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSetHostName() {
        String hostNAme = "hrtdotnet.jp";
        mail.setHostName(hostNAme);
        assertEquals(hostNAme, mail.getHostName());
        
        try {
            mail.setHostName(null);
            fail();
        } catch (NullPointerException e) {
        }
        try {
            mail.setHostName("");
            fail();
        } catch (IllegalArgumentException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#getSmtpPort()} ̂߂̃eXgE\bhB
     */
    public void testGetSmtpPort() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setSmtpPort(int)} ̂߂̃eXgE\bhB
     */
    public void testSetSmtpPort() {
        int smtpPort = 99;
        mail.setSmtpPort(smtpPort);
        assertEquals(99, mail.getSmtpPort());
        
        try {
            mail.setSmtpPort(-1);
            fail();
        } catch (IllegalArgumentException e) {
        }
        try {
            mail.setSmtpPort(999999999);
            fail();
        } catch (IllegalArgumentException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#getUserName()} ̂߂̃eXgE\bhB
     */
    public void testGetUserName() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setUserName(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSetUserName() {
        String userName = "user1";
        mail.setUserName(userName);
        assertEquals(userName, mail.getUserName());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#getPassword()} ̂߂̃eXgE\bhB
     */
    public void testGetPassword() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setPassword(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSetPassword() {
        String password = "password1";
        mail.setPassword(password);
        assertEquals(password, mail.getPassword());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#getAuthenticator()} ̂߂̃eXgE\bhB
     */
    public void testGetAuthenticator() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setAuthenticator(javax.mail.Authenticator)} ̂߂̃eXgE\bhB
     */
    public void testSetAuthenticator() {
        Authenticator a = new DefaultAuthenticator("user1", "password1");
        mail.setAuthenticator(a);
        assertSame(a, mail.getAuthenticator());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#getFrom()} ̂߂̃eXgE\bhB
     */
    public void testGetFrom() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setFrom(java.lang.String, java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSetFrom() {
        mail.setFrom("address1", "name1");
        HMailAddress from = mail.getFrom();
        assertEquals("address1", from.getAddress());
        assertEquals("name1", from.getName());
        
        mail.setFrom("address2", null);
        from = mail.getFrom();
        assertEquals("address2", from.getAddress());
        assertNull(from.getName());
        
        try {
            mail.setFrom(null, null);
            fail();
        } catch (NullPointerException e) {
        }
        try {
            mail.setFrom("", null);
            fail();
        } catch (IllegalArgumentException e) {
        }
        
        mail.setFrom("address3");
        from = mail.getFrom();
        assertEquals("address3", from.getAddress());
        assertNull(from.getName());

        try {
            mail.setFrom(null);
            fail();
        } catch (NullPointerException e) {
        }
        try {
            mail.setFrom("");
            fail();
        } catch (IllegalArgumentException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#getTo()} ̂߂̃eXgE\bhB
     */
    public void testGetTo() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#getCc()} ̂߂̃eXgE\bhB
     */
    public void testGetCc() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#getBcc()} ̂߂̃eXgE\bhB
     */
    public void testGetBcc() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setTo(java.util.List)} ̂߂̃eXgE\bhB
     */
    public void testSetToList() {
        List addrList2 = addressList;
        mail.setTo(addrList2);
        List addrList = mail.getTo();
        assertEquals(addrList2.size(), addrList.size());
        Iterator it = addrList.iterator();
        Iterator it2 = addrList2.iterator();
        while(it.hasNext()) {
            HMailAddress addr = (HMailAddress)it.next();
            String addr2 = (String)it2.next();
            assertEquals(addr2, addr.getAddress());
            assertNull(addr.getName());
        }

        addrList2 = null;
        mail.setTo(addrList2);
        addrList = mail.getTo();
        assertEquals(0, addrList.size());

        addrList2 = new ArrayList();
        mail.setTo(addrList2);
        addrList = mail.getTo();
        assertEquals(0, addrList.size());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setTo(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSetToString() {
        String addr2 = toAddress;
        mail.setTo(addr2);
        List addrList = mail.getTo();
        assertEquals(1, addrList.size());
        Iterator it = addrList.iterator();
        while(it.hasNext()) {
            HMailAddress addr = (HMailAddress)it.next();
            assertEquals(addr2, addr.getAddress());
            assertNull(addr.getName());
        }

        addr2 = null;
        mail.setTo(addr2);
        addrList = mail.getTo();
        assertEquals(0, addrList.size());

        addr2 = "";
        mail.setTo(addr2);
        addrList = mail.getTo();
        assertEquals(0, addrList.size());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setTo(java.lang.String[])} ̂߂̃eXgE\bhB
     */
    public void testSetToStringArray() {
        String[] addrArray2 = addressArray;
        mail.setTo(addrArray2);
        List addrList = mail.getTo();
        assertEquals(addrArray2.length, addrList.size());
        Iterator it = addrList.iterator();
        int i = 0;
        while(it.hasNext()) {
            HMailAddress addr = (HMailAddress)it.next();
            String addr2 = addrArray2[i++];
            assertEquals(addr2, addr.getAddress());
            assertNull(addr.getName());
        }

        addrArray2 = null;
        mail.setTo(addrArray2);
        addrList = mail.getTo();
        assertEquals(0, addrList.size());

        addrArray2 = new String[]{};
        mail.setTo(addrArray2);
        addrList = mail.getTo();
        assertEquals(0, addrList.size());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setTo(java.util.List, java.util.List)} ̂߂̃eXgE\bhB
     */
    public void testSetToListList() {
        List addrList2 = addressList;
        List nameList2 = nameList;
        mail.setTo(addrList2, nameList2);
        List addrList = mail.getTo();
        assertEquals(addrList2.size(), addrList.size());
        Iterator it = addrList.iterator();
        Iterator it2 = addrList2.iterator();
        Iterator it2name = nameList2.iterator();
        while(it.hasNext()) {
            HMailAddress addr = (HMailAddress)it.next();
            String addr2 = (String)it2.next();
            String name2 = (String)it2name.next();
            assertEquals(addr2, addr.getAddress());
            assertEquals(name2, addr.getName());
        }

        addrList2 = null;
        nameList2 = null;
        mail.setTo(addrList2, nameList2);
        addrList = mail.getTo();
        assertEquals(0, addrList.size());

        addrList2 = new ArrayList();
        nameList2 = new ArrayList();
        mail.setTo(addrList2, nameList2);
        addrList = mail.getTo();
        assertEquals(0, addrList.size());

        addrList2 = null;
        nameList2 = new ArrayList();
        mail.setTo(addrList2, nameList2);
        addrList = mail.getTo();
        assertEquals(0, addrList.size());    

        addrList2 = new ArrayList();
        nameList2 = null;
        mail.setTo(addrList2, nameList2);
        addrList = mail.getTo();
        assertEquals(0, addrList.size());
        
        addrList2 = new ArrayList();
        addrList2.add("aaa@localhost");
        addrList2.add("bbb@localhost");
        nameList2 = new ArrayList();
        nameList2.add("aaa");
        try {
            mail.setTo(addrList2, nameList2);
            fail();
        } catch (IllegalArgumentException e) {
        }
        
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setTo(java.lang.String, java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSetToStringString() {
        String addr2 = toAddress;
        String name2 = toName;
        mail.setTo(addr2, name2);
        List addrList = mail.getTo();
        assertEquals(1, addrList.size());
        Iterator it = addrList.iterator();
        while(it.hasNext()) {
            HMailAddress addr = (HMailAddress)it.next();
            assertEquals(addr2, addr.getAddress());
            assertEquals(name2, addr.getName());
        }

        addr2 = null;
        name2 = null;
        mail.setTo(addr2, name2);
        addrList = mail.getTo();
        assertEquals(0, addrList.size());

        addr2 = "";
        name2 = "";
        mail.setTo(addr2, name2);
        addrList = mail.getTo();
        assertEquals(0, addrList.size());

        addr2 = null;
        name2 = "";
        mail.setTo(addr2, name2);
        addrList = mail.getTo();
        assertEquals(0, addrList.size());
        
        addr2 = "";
        name2 = null;
        mail.setTo(addr2, name2);
        addrList = mail.getTo();
        assertEquals(0, addrList.size());       
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setTo(java.lang.String[], java.lang.String[])} ̂߂̃eXgE\bhB
     */
    public void testSetToStringArrayStringArray() {
        String[] addrArray2 = addressArray;
        String[] nameArray2 = nameArray;
        mail.setTo(addrArray2, nameArray2);
        List addrList = mail.getTo();
        assertEquals(addrArray2.length, addrList.size());
        Iterator it = addrList.iterator();
        int i = 0;
        while(it.hasNext()) {
            HMailAddress addr = (HMailAddress)it.next();
            String addr2 = addrArray2[i];
            String name2 = nameArray2[i++];
            assertEquals(addr2, addr.getAddress());
            assertEquals(name2, addr.getName());
        }

        addrArray2 = null;
        nameArray2 = null;
        mail.setTo(addrArray2, nameArray2);
        addrList = mail.getTo();
        assertEquals(0, addrList.size());

        addrArray2 = new String[]{};
        nameArray2 = new String[]{};
        mail.setTo(addrArray2, nameArray2);
        addrList = mail.getTo();
        assertEquals(0, addrList.size());

        addrArray2 = new String[]{};
        nameArray2 = null;
        mail.setTo(addrArray2, nameArray2);
        addrList = mail.getTo();
        assertEquals(0, addrList.size());

        addrArray2 = null;
        nameArray2 = new String[]{};
        mail.setTo(addrArray2, nameArray2);
        addrList = mail.getTo();
        assertEquals(0, addrList.size());

        addrArray2 = new String[]{"aaa@localhost", "bbb@localhost"};
        nameArray2 = new String[]{"aaa@localhost"};
        try {
            mail.setTo(addrArray2, nameArray2);
            fail();
        } catch (IllegalArgumentException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setCc(java.util.List)} ̂߂̃eXgE\bhB
     */
    public void testSetCcList() {
        List addrList2 = addressList;
        mail.setCc(addrList2);
        List addrList = mail.getCc();
        assertEquals(addrList2.size(), addrList.size());
        Iterator it = addrList.iterator();
        Iterator it2 = addrList2.iterator();
        while(it.hasNext()) {
            HMailAddress addr = (HMailAddress)it.next();
            String addr2 = (String)it2.next();
            assertEquals(addr2, addr.getAddress());
            assertNull(addr.getName());
        }

        addrList2 = null;
        mail.setCc(addrList2);
        addrList = mail.getCc();
        assertEquals(0, addrList.size());

        addrList2 = new ArrayList();
        mail.setCc(addrList2);
        addrList = mail.getCc();
        assertEquals(0, addrList.size());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setCc(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSetCcString() {
        String addr2 = ccAddress;
        mail.setCc(addr2);
        List addrList = mail.getCc();
        assertEquals(1, addrList.size());
        Iterator it = addrList.iterator();
        while(it.hasNext()) {
            HMailAddress addr = (HMailAddress)it.next();
            assertEquals(addr2, addr.getAddress());
            assertNull(addr.getName());
        }

        addr2 = null;
        mail.setCc(addr2);
        addrList = mail.getCc();
        assertEquals(0, addrList.size());

        addr2 = "";
        mail.setCc(addr2);
        addrList = mail.getCc();
        assertEquals(0, addrList.size());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setCc(java.lang.String[])} ̂߂̃eXgE\bhB
     */
    public void testSetCcStringArray() {
        String[] addrArray2 = addressArray;
        mail.setCc(addrArray2);
        List addrList = mail.getCc();
        assertEquals(addrArray2.length, addrList.size());
        Iterator it = addrList.iterator();
        int i = 0;
        while(it.hasNext()) {
            HMailAddress addr = (HMailAddress)it.next();
            String addr2 = addrArray2[i++];
            assertEquals(addr2, addr.getAddress());
            assertNull(addr.getName());
        }

        addrArray2 = null;
        mail.setCc(addrArray2);
        addrList = mail.getCc();
        assertEquals(0, addrList.size());

        addrArray2 = new String[]{};
        mail.setCc(addrArray2);
        addrList = mail.getCc();
        assertEquals(0, addrList.size());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setCc(java.util.List, java.util.List)} ̂߂̃eXgE\bhB
     */
    public void testSetCcListList() {
        List addrList2 = addressList;
        List nameList2 = nameList;
        mail.setCc(addrList2, nameList2);
        List addrList = mail.getCc();
        assertEquals(addrList2.size(), addrList.size());
        Iterator it = addrList.iterator();
        Iterator it2 = addrList2.iterator();
        Iterator it2name = nameList2.iterator();
        while(it.hasNext()) {
            HMailAddress addr = (HMailAddress)it.next();
            String addr2 = (String)it2.next();
            String name2 = (String)it2name.next();
            assertEquals(addr2, addr.getAddress());
            assertEquals(name2, addr.getName());
        }

        addrList2 = null;
        nameList2 = null;
        mail.setCc(addrList2, nameList2);
        addrList = mail.getCc();
        assertEquals(0, addrList.size());

        addrList2 = new ArrayList();
        nameList2 = new ArrayList();
        mail.setCc(addrList2, nameList2);
        addrList = mail.getCc();
        assertEquals(0, addrList.size());

        addrList2 = null;
        nameList2 = new ArrayList();
        mail.setCc(addrList2, nameList2);
        addrList = mail.getCc();
        assertEquals(0, addrList.size());    

        addrList2 = new ArrayList();
        nameList2 = null;
        mail.setCc(addrList2, nameList2);
        addrList = mail.getCc();
        assertEquals(0, addrList.size());
        
        addrList2 = new ArrayList();
        addrList2.add("aaa@localhost");
        addrList2.add("bbb@localhost");
        nameList2 = new ArrayList();
        nameList2.add("aaa");
        try {
            mail.setCc(addrList2, nameList2);
            fail();
        } catch (IllegalArgumentException e) {
        }
        
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setCc(java.lang.String, java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSetCcStringString() {
        String addr2 = ccAddress;
        String name2 = ccName;
        mail.setCc(addr2, name2);
        List addrList = mail.getCc();
        assertEquals(1, addrList.size());
        Iterator it = addrList.iterator();
        while(it.hasNext()) {
            HMailAddress addr = (HMailAddress)it.next();
            assertEquals(addr2, addr.getAddress());
            assertEquals(name2, addr.getName());
        }

        addr2 = null;
        name2 = null;
        mail.setCc(addr2, name2);
        addrList = mail.getCc();
        assertEquals(0, addrList.size());

        addr2 = "";
        name2 = "";
        mail.setCc(addr2, name2);
        addrList = mail.getCc();
        assertEquals(0, addrList.size());

        addr2 = null;
        name2 = "";
        mail.setCc(addr2, name2);
        addrList = mail.getCc();
        assertEquals(0, addrList.size());
        
        addr2 = "";
        name2 = null;
        mail.setCc(addr2, name2);
        addrList = mail.getCc();
        assertEquals(0, addrList.size());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setCc(java.lang.String[], java.lang.String[])} ̂߂̃eXgE\bhB
     */
    public void testSetCcStringArrayStringArray() {
        String[] addrArray2 = addressArray;
        String[] nameArray2 = nameArray;
        mail.setCc(addrArray2, nameArray2);
        List addrList = mail.getCc();
        assertEquals(addrArray2.length, addrList.size());
        Iterator it = addrList.iterator();
        int i = 0;
        while(it.hasNext()) {
            HMailAddress addr = (HMailAddress)it.next();
            String addr2 = addrArray2[i];
            String name2 = nameArray2[i++];
            assertEquals(addr2, addr.getAddress());
            assertEquals(name2, addr.getName());
        }

        addrArray2 = null;
        nameArray2 = null;
        mail.setCc(addrArray2, nameArray2);
        addrList = mail.getCc();
        assertEquals(0, addrList.size());

        addrArray2 = new String[]{};
        nameArray2 = new String[]{};
        mail.setCc(addrArray2, nameArray2);
        addrList = mail.getCc();
        assertEquals(0, addrList.size());

        addrArray2 = new String[]{};
        nameArray2 = null;
        mail.setCc(addrArray2, nameArray2);
        addrList = mail.getCc();
        assertEquals(0, addrList.size());

        addrArray2 = null;
        nameArray2 = new String[]{};
        mail.setCc(addrArray2, nameArray2);
        addrList = mail.getCc();
        assertEquals(0, addrList.size());

        addrArray2 = new String[]{"aaa@localhost", "bbb@localhost"};
        nameArray2 = new String[]{"aaa@localhost"};
        try {
            mail.setCc(addrArray2, nameArray2);
            fail();
        } catch (IllegalArgumentException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setBcc(java.util.List)} ̂߂̃eXgE\bhB
     */
    public void testSetBccList() {
        List addrList2 = addressList;
        mail.setBcc(addrList2);
        List addrList = mail.getBcc();
        assertEquals(addrList2.size(), addrList.size());
        Iterator it = addrList.iterator();
        Iterator it2 = addrList2.iterator();
        while(it.hasNext()) {
            HMailAddress addr = (HMailAddress)it.next();
            String addr2 = (String)it2.next();
            assertEquals(addr2, addr.getAddress());
            assertNull(addr.getName());
        }

        addrList2 = null;
        mail.setBcc(addrList2);
        addrList = mail.getBcc();
        assertEquals(0, addrList.size());

        addrList2 = new ArrayList();
        mail.setBcc(addrList2);
        addrList = mail.getBcc();
        assertEquals(0, addrList.size());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setBcc(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSetBccString() {
        String addr2 = bccAddress;
        mail.setBcc(addr2);
        List addrList = mail.getBcc();
        assertEquals(1, addrList.size());
        Iterator it = addrList.iterator();
        while(it.hasNext()) {
            HMailAddress addr = (HMailAddress)it.next();
            assertEquals(addr2, addr.getAddress());
            assertNull(addr.getName());
        }

        addr2 = null;
        mail.setBcc(addr2);
        addrList = mail.getBcc();
        assertEquals(0, addrList.size());

        addr2 = "";
        mail.setBcc(addr2);
        addrList = mail.getBcc();
        assertEquals(0, addrList.size());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setBcc(java.lang.String[])} ̂߂̃eXgE\bhB
     */
    public void testSetBccStringArray() {
        String[] addrArray2 = addressArray;
        mail.setBcc(addrArray2);
        List addrList = mail.getBcc();
        assertEquals(addrArray2.length, addrList.size());
        Iterator it = addrList.iterator();
        int i = 0;
        while(it.hasNext()) {
            HMailAddress addr = (HMailAddress)it.next();
            String addr2 = addrArray2[i++];
            assertEquals(addr2, addr.getAddress());
            assertNull(addr.getName());
        }

        addrArray2 = null;
        mail.setBcc(addrArray2);
        addrList = mail.getBcc();
        assertEquals(0, addrList.size());

        addrArray2 = new String[]{};
        mail.setBcc(addrArray2);
        addrList = mail.getBcc();
        assertEquals(0, addrList.size());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setBcc(java.util.List, java.util.List)} ̂߂̃eXgE\bhB
     */
    public void testSetBccListList() {
        List addrList2 = addressList;
        List nameList2 = nameList;
        mail.setBcc(addrList2, nameList2);
        List addrList = mail.getBcc();
        assertEquals(addrList2.size(), addrList.size());
        Iterator it = addrList.iterator();
        Iterator it2 = addrList2.iterator();
        Iterator it2name = nameList2.iterator();
        while(it.hasNext()) {
            HMailAddress addr = (HMailAddress)it.next();
            String addr2 = (String)it2.next();
            String name2 = (String)it2name.next();
            assertEquals(addr2, addr.getAddress());
            assertEquals(name2, addr.getName());
        }

        addrList2 = null;
        nameList2 = null;
        mail.setBcc(addrList2, nameList2);
        addrList = mail.getBcc();
        assertEquals(0, addrList.size());

        addrList2 = new ArrayList();
        nameList2 = new ArrayList();
        mail.setBcc(addrList2, nameList2);
        addrList = mail.getBcc();
        assertEquals(0, addrList.size());

        addrList2 = null;
        nameList2 = new ArrayList();
        mail.setBcc(addrList2, nameList2);
        addrList = mail.getBcc();
        assertEquals(0, addrList.size());    

        addrList2 = new ArrayList();
        nameList2 = null;
        mail.setBcc(addrList2, nameList2);
        addrList = mail.getBcc();
        assertEquals(0, addrList.size());
        
        addrList2 = new ArrayList();
        addrList2.add("aaa@localhost");
        addrList2.add("bbb@localhost");
        nameList2 = new ArrayList();
        nameList2.add("aaa");
        try {
            mail.setBcc(addrList2, nameList2);
            fail();
        } catch (IllegalArgumentException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setBcc(java.lang.String, java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSetBccStringString() {
        String addr2 = bccAddress;
        String name2 = bccName;
        mail.setBcc(addr2, name2);
        List addrList = mail.getBcc();
        assertEquals(1, addrList.size());
        Iterator it = addrList.iterator();
        while(it.hasNext()) {
            HMailAddress addr = (HMailAddress)it.next();
            assertEquals(addr2, addr.getAddress());
            assertEquals(name2, addr.getName());
        }

        addr2 = null;
        name2 = null;
        mail.setBcc(addr2, name2);
        addrList = mail.getBcc();
        assertEquals(0, addrList.size());

        addr2 = "";
        name2 = "";
        mail.setBcc(addr2, name2);
        addrList = mail.getBcc();
        assertEquals(0, addrList.size());

        addr2 = null;
        name2 = "";
        mail.setBcc(addr2, name2);
        addrList = mail.getBcc();
        assertEquals(0, addrList.size());
        
        addr2 = "";
        name2 = null;
        mail.setBcc(addr2, name2);
        addrList = mail.getBcc();
        assertEquals(0, addrList.size());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setBcc(java.lang.String[], java.lang.String[])} ̂߂̃eXgE\bhB
     */
    public void testSetBccStringArrayStringArray() {
        String[] addrArray2 = addressArray;
        String[] nameArray2 = nameArray;
        mail.setBcc(addrArray2, nameArray2);
        List addrList = mail.getBcc();
        assertEquals(addrArray2.length, addrList.size());
        Iterator it = addrList.iterator();
        int i = 0;
        while(it.hasNext()) {
            HMailAddress addr = (HMailAddress)it.next();
            String addr2 = addrArray2[i];
            String name2 = nameArray2[i++];
            assertEquals(addr2, addr.getAddress());
            assertEquals(name2, addr.getName());
        }

        addrArray2 = null;
        nameArray2 = null;
        mail.setBcc(addrArray2, nameArray2);
        addrList = mail.getBcc();
        assertEquals(0, addrList.size());

        addrArray2 = new String[]{};
        nameArray2 = new String[]{};
        mail.setBcc(addrArray2, nameArray2);
        addrList = mail.getBcc();
        assertEquals(0, addrList.size());

        addrArray2 = new String[]{};
        nameArray2 = null;
        mail.setBcc(addrArray2, nameArray2);
        addrList = mail.getBcc();
        assertEquals(0, addrList.size());

        addrArray2 = null;
        nameArray2 = new String[]{};
        mail.setBcc(addrArray2, nameArray2);
        addrList = mail.getBcc();
        assertEquals(0, addrList.size());

        addrArray2 = new String[]{"aaa@localhost", "bbb@localhost"};
        nameArray2 = new String[]{"aaa@localhost"};
        try {
            mail.setBcc(addrArray2, nameArray2);
            fail();
        } catch (IllegalArgumentException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#getAddress(java.lang.String, java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testGetAddressStringString() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#getAddress(java.util.List, java.util.List)} ̂߂̃eXgE\bhB
     */
    public void testGetAddressListList() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#getAddress(java.lang.String[], java.lang.String[])} ̂߂̃eXgE\bhB
     */
    public void testGetAddressStringArrayStringArray() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#getSubject()} ̂߂̃eXgE\bhB
     */
    public void testGetSubject() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setSubject(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSetSubject() {
        String subject = "test subject";
        mail.setSubject(subject);
        assertEquals(subject, mail.getSubject());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#getMsg()} ̂߂̃eXgE\bhB
     */
    public void testGetMsg() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setMsg(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSetMsgString() {
        String msg = "test msg";
        mail.setMsg(msg);
        assertEquals(msg, mail.getMsg());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setMsg(java.io.File, java.lang.String, java.lang.Object[])} ̂߂̃eXgE\bhB
     * @throws IOException 
     * @throws FileNotFoundException 
     * @throws UnsupportedEncodingException 
     */
    public void testSetMsgFileStringObjectArray() throws UnsupportedEncodingException, FileNotFoundException, IOException {

        if (junit == false) return;

        String msg = "To: TEST1l\r\n\r\n̓eXg[(tH[}bg1)łB\r\n\r\nTEST2łB\r\n\r\nȏłB";
        mail.setMsg(new File(msgFormatFile1), "MS932", new String[]{"TEST1", "TEST2"});
        assertEquals(msg, mail.getMsg());
        
        try {
            mail.setMsg(null, "MS932", new String[]{"TEST1", "TEST2"});
            fail();
        } catch (NullPointerException e) {
        }

        try {
            mail.setMsg(new File(msgFormatFile1), null, new String[]{"TEST1", "TEST2"});
            fail();
        } catch (NullPointerException e) {
        }

        try {
            mail.setMsg(new File(msgFormatFile1), "", new String[]{"TEST1", "TEST2"});
            fail();
        } catch (IllegalArgumentException e) {
        }

        try {
            mail.setMsg(new File(msgFormatFile1), "@@@@", new String[]{"TEST1", "TEST2"});
            fail();
        } catch (UnsupportedEncodingException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setMsg(java.io.File, java.lang.String, java.lang.String, java.lang.Object[])} ̂߂̃eXgE\bhB
     * @throws IOException 
     * @throws FileNotFoundException 
     * @throws UnsupportedEncodingException 
     */
    public void testSetMsgFileStringStringObjectArray() throws UnsupportedEncodingException, FileNotFoundException, IOException {
        
        String msg = "To: TEST1l\r\n\r\n̓eXg[(tH[}bg1)łB\r\n\r\nTEST2łB\r\n\r\nȏłB";
        mail.setMsg(new File(msgFormatFile1), "MS932", "\r\n", new String[]{"TEST1", "TEST2"});
        assertEquals(msg, mail.getMsg());
        
        try {
            mail.setMsg(null, "MS932", "\r\n", new String[]{"TEST1", "TEST2"});
            fail();
        } catch (NullPointerException e) {
        }

        try {
            mail.setMsg(new File(msgFormatFile1), null, "\r\n", new String[]{"TEST1", "TEST2"});
            fail();
        } catch (NullPointerException e) {
        }

        try {
            mail.setMsg(new File(msgFormatFile1), "", "\r\n", new String[]{"TEST1", "TEST2"});
            fail();
        } catch (IllegalArgumentException e) {
        }

        try {
            mail.setMsg(new File(msgFormatFile1), "@@@@", "\r\n", new String[]{"TEST1", "TEST2"});
            fail();
        } catch (UnsupportedEncodingException e) {
        }
        
        try {
            mail.setMsg(new File(msgFormatFile1), "MS932", null, new String[]{"TEST1", "TEST2"});
            fail();
        } catch (NullPointerException e) {
        }

        try {
            mail.setMsg(new File(msgFormatFile1), "MS932", "", new String[]{"TEST1", "TEST2"});
            fail();
        } catch (IllegalArgumentException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setMsg(java.text.Format, java.lang.Object[])} ̂߂̃eXgE\bhB
     */
    public void testSetMsgFormatObjectArray() {

        String msg = "To: TEST1l\r\n\r\n̓eXg[(tH[}bg1)łB\r\n\r\nTEST2łB\r\n\r\nȏłB";
        Format format = new MessageFormat("To: {0}l\r\n\r\n̓eXg[(tH[}bg1)łB\r\n\r\n{1}łB\r\n\r\nȏłB");
        mail.setMsg(format, new String[]{"TEST1", "TEST2"});
        assertEquals(msg, mail.getMsg());
        
        try {
            mail.setMsg(null, new String[]{"TEST1", "TEST2"});
            fail();
        } catch (NullPointerException e) {
        }
    }
    
    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setMsgFormat(java.io.File, java.lang.String)} ̂߂̃eXgE\bhB
     * @throws IOException 
     * @throws FileNotFoundException 
     * @throws UnsupportedEncodingException 
     */
    public void testSetMsgFormatFileString() throws UnsupportedEncodingException, FileNotFoundException, IOException {

        if (junit == false) return;

        String msg = "To: TEST1l\r\n\r\n̓eXg[(tH[}bg1)łB\r\n\r\nTEST2łB\r\n\r\nȏłB";
        mail.setMsgFormat(new File(msgFormatFile1), "MS932");
        assertEquals(msg, mail.getMsgFormat().format(new String[]{"TEST1", "TEST2"}));
        
        try {
            mail.setMsgFormat(null, "MS932");
            fail();
        } catch (NullPointerException e) {
        }

        try {
            mail.setMsgFormat(new File(msgFormatFile1), null);
            fail();
        } catch (NullPointerException e) {
        }

        try {
            mail.setMsgFormat(new File(msgFormatFile1), "");
            fail();
        } catch (IllegalArgumentException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setMsgFormat(java.io.File, java.lang.String, java.lang.String)} ̂߂̃eXgE\bhB
     * @throws IOException 
     * @throws FileNotFoundException 
     * @throws UnsupportedEncodingException 
     */
    public void testSetMsgFormatFileStringString() throws UnsupportedEncodingException, FileNotFoundException, IOException {
        String msg = "To: TEST1l\r\n\r\n̓eXg[(tH[}bg1)łB\r\n\r\nTEST2łB\r\n\r\nȏłB";
        mail.setMsgFormat(new File(msgFormatFile1), "MS932", "\r\n");
        assertEquals(msg, mail.getMsgFormat().format(new String[]{"TEST1", "TEST2"}));
        
        try {
            mail.setMsgFormat(null, "MS932", "\r\n");
            fail();
        } catch (NullPointerException e) {
        }

        try {
            mail.setMsgFormat(new File(msgFormatFile1), null, "\r\n");
            fail();
        } catch (NullPointerException e) {
        }

        try {
            mail.setMsgFormat(new File(msgFormatFile1), "", "\r\n");
            fail();
        } catch (IllegalArgumentException e) {
        }

        try {
            mail.setMsgFormat(new File(msgFormatFile1), "@@@@@", "\r\n");
            fail();
        } catch (UnsupportedEncodingException e) {
        }

        try {
            mail.setMsgFormat(new File(msgFormatFile1), "MS932", null);
            fail();
        } catch (NullPointerException e) {
        }
        
        try {
            mail.setMsgFormat(new File(msgFormatFile1), "MS932", "");
            fail();
        } catch (IllegalArgumentException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setMsgFormat(java.text.Format)} ̂߂̃eXgE\bhB
     */
    public void testSetMsgFormatFormat() {
        String msg = "To: TEST1l\r\n\r\n̓eXg[(tH[}bg1)łB\r\n\r\nTEST2łB\r\n\r\nȏłB";
        Format format = new MessageFormat("To: {0}l\r\n\r\n̓eXg[(tH[}bg1)łB\r\n\r\n{1}łB\r\n\r\nȏłB");
        mail.setMsgFormat(format);
        assertEquals(msg, mail.getMsgFormat().format(new String[]{"TEST1", "TEST2"}));
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#getMsgFormat()} ̂߂̃eXgE\bhB
     */
    public void testGetMsgFormat() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setMsgFormatParams(java.lang.Object)} ̂߂̃eXgE\bhB
     */
    public void testSetMsgFormatParams() {
        mail.setMsgFormatParams(new String[]{"AAA", "BBB"});
        String[] params = (String[])mail.getMsgFormatParams();
        assertEquals("AAA", params[0]);
        assertEquals("BBB", params[1]);
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#getMsgFormatParams()} ̂߂̃eXgE\bhB
     */
    public void testGetMsgFormatParams() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#getCharset()} ̂߂̃eXgE\bhB
     */
    public void testGetCharset() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setCharset(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSetCharset() {
        mail.setCharset("EUC-JP");
        assertEquals("EUC-JP", mail.getCharset());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#isDebug()} ̂߂̃eXgE\bhB
     */
    public void testIsDebug() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setDebug(boolean)} ̂߂̃eXgE\bhB
     */
    public void testSetDebug() {
        mail.setDebug(true);
        assertTrue(mail.isDebug());
        mail.setDebug(false);
        assertFalse(mail.isDebug());
        mail.setDebug(true);
        assertTrue(mail.isDebug());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#getReplyTo()} ̂߂̃eXgE\bhB
     */
    public void testGetReplyTo() {
        //sv
    }

    
    
    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setReplyTo(java.util.List)} ̂߂̃eXgE\bhB
     */
    public void testSetReplyToList() {
        List addrList2 = addressList;
        mail.setReplyTo(addrList2);
        List addrList = mail.getReplyTo();
        assertEquals(addrList2.size(), addrList.size());
        Iterator it = addrList.iterator();
        Iterator it2 = addrList2.iterator();
        while(it.hasNext()) {
            HMailAddress addr = (HMailAddress)it.next();
            String addr2 = (String)it2.next();
            assertEquals(addr2, addr.getAddress());
            assertNull(addr.getName());
        }

        addrList2 = null;
        mail.setReplyTo(addrList2);
        addrList = mail.getReplyTo();
        assertEquals(0, addrList.size());

        addrList2 = new ArrayList();
        mail.setReplyTo(addrList2);
        addrList = mail.getReplyTo();
        assertEquals(0, addrList.size());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setReplyTo(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSetReplyToString() {
        String addr2 = replyToAddress;
        mail.setReplyTo(addr2);
        List addrList = mail.getReplyTo();
        assertEquals(1, addrList.size());
        Iterator it = addrList.iterator();
        while(it.hasNext()) {
            HMailAddress addr = (HMailAddress)it.next();
            assertEquals(addr2, addr.getAddress());
            assertNull(addr.getName());
        }

        addr2 = null;
        mail.setReplyTo(addr2);
        addrList = mail.getReplyTo();
        assertEquals(0, addrList.size());

        addr2 = "";
        mail.setReplyTo(addr2);
        addrList = mail.getReplyTo();
        assertEquals(0, addrList.size());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setReplyTo(java.lang.String[])} ̂߂̃eXgE\bhB
     */
    public void testSetReplyToStringArray() {
        String[] addrArray2 = addressArray;
        mail.setReplyTo(addrArray2);
        List addrList = mail.getReplyTo();
        assertEquals(addrArray2.length, addrList.size());
        Iterator it = addrList.iterator();
        int i = 0;
        while(it.hasNext()) {
            HMailAddress addr = (HMailAddress)it.next();
            String addr2 = addrArray2[i++];
            assertEquals(addr2, addr.getAddress());
            assertNull(addr.getName());
        }

        addrArray2 = null;
        mail.setReplyTo(addrArray2);
        addrList = mail.getReplyTo();
        assertEquals(0, addrList.size());

        addrArray2 = new String[]{};
        mail.setReplyTo(addrArray2);
        addrList = mail.getReplyTo();
        assertEquals(0, addrList.size());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setReplyTo(java.util.List, java.util.List)} ̂߂̃eXgE\bhB
     */
    public void testSetReplyToListList() {
        List addrList2 = addressList;
        List nameList2 = nameList;
        mail.setReplyTo(addrList2, nameList2);
        List addrList = mail.getReplyTo();
        assertEquals(addrList2.size(), addrList.size());
        Iterator it = addrList.iterator();
        Iterator it2 = addrList2.iterator();
        Iterator it2name = nameList2.iterator();
        while(it.hasNext()) {
            HMailAddress addr = (HMailAddress)it.next();
            String addr2 = (String)it2.next();
            String name2 = (String)it2name.next();
            assertEquals(addr2, addr.getAddress());
            assertEquals(name2, addr.getName());
        }

        addrList2 = null;
        nameList2 = null;
        mail.setReplyTo(addrList2, nameList2);
        addrList = mail.getReplyTo();
        assertEquals(0, addrList.size());

        addrList2 = new ArrayList();
        nameList2 = new ArrayList();
        mail.setReplyTo(addrList2, nameList2);
        addrList = mail.getReplyTo();
        assertEquals(0, addrList.size());

        addrList2 = null;
        nameList2 = new ArrayList();
        mail.setReplyTo(addrList2, nameList2);
        addrList = mail.getReplyTo();
        assertEquals(0, addrList.size());    

        addrList2 = new ArrayList();
        nameList2 = null;
        mail.setReplyTo(addrList2, nameList2);
        addrList = mail.getReplyTo();
        assertEquals(0, addrList.size());
        
        addrList2 = new ArrayList();
        addrList2.add("aaa@localhost");
        addrList2.add("bbb@localhost");
        nameList2 = new ArrayList();
        nameList2.add("aaa");
        try {
            mail.setReplyTo(addrList2, nameList2);
            fail();
        } catch (IllegalArgumentException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setReplyTo(java.lang.String, java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSetReplyToStringString() {
        String addr2 = bccAddress;
        String name2 = bccName;
        mail.setReplyTo(addr2, name2);
        List addrList = mail.getReplyTo();
        assertEquals(1, addrList.size());
        Iterator it = addrList.iterator();
        while(it.hasNext()) {
            HMailAddress addr = (HMailAddress)it.next();
            assertEquals(addr2, addr.getAddress());
            assertEquals(name2, addr.getName());
        }

        addr2 = null;
        name2 = null;
        mail.setReplyTo(addr2, name2);
        addrList = mail.getReplyTo();
        assertEquals(0, addrList.size());

        addr2 = "";
        name2 = "";
        mail.setReplyTo(addr2, name2);
        addrList = mail.getReplyTo();
        assertEquals(0, addrList.size());

        addr2 = null;
        name2 = "";
        mail.setReplyTo(addr2, name2);
        addrList = mail.getReplyTo();
        assertEquals(0, addrList.size());
        
        addr2 = "";
        name2 = null;
        mail.setReplyTo(addr2, name2);
        addrList = mail.getReplyTo();
        assertEquals(0, addrList.size());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setReplyTo(java.lang.String[], java.lang.String[])} ̂߂̃eXgE\bhB
     */
    public void testSetReplyToStringArrayStringArray() {
        String[] addrArray2 = addressArray;
        String[] nameArray2 = nameArray;
        mail.setReplyTo(addrArray2, nameArray2);
        List addrList = mail.getReplyTo();
        assertEquals(addrArray2.length, addrList.size());
        Iterator it = addrList.iterator();
        int i = 0;
        while(it.hasNext()) {
            HMailAddress addr = (HMailAddress)it.next();
            String addr2 = addrArray2[i];
            String name2 = nameArray2[i++];
            assertEquals(addr2, addr.getAddress());
            assertEquals(name2, addr.getName());
        }

        addrArray2 = null;
        nameArray2 = null;
        mail.setReplyTo(addrArray2, nameArray2);
        addrList = mail.getReplyTo();
        assertEquals(0, addrList.size());

        addrArray2 = new String[]{};
        nameArray2 = new String[]{};
        mail.setReplyTo(addrArray2, nameArray2);
        addrList = mail.getReplyTo();
        assertEquals(0, addrList.size());

        addrArray2 = new String[]{};
        nameArray2 = null;
        mail.setReplyTo(addrArray2, nameArray2);
        addrList = mail.getReplyTo();
        assertEquals(0, addrList.size());

        addrArray2 = null;
        nameArray2 = new String[]{};
        mail.setReplyTo(addrArray2, nameArray2);
        addrList = mail.getReplyTo();
        assertEquals(0, addrList.size());

        addrArray2 = new String[]{"aaa@localhost", "bbb@localhost"};
        nameArray2 = new String[]{"aaa@localhost"};
        try {
            mail.setReplyTo(addrArray2, nameArray2);
            fail();
        } catch (IllegalArgumentException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#getSentDate()} ̂߂̃eXgE\bhB
     */
    public void testGetSentDate() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setSentDate(java.util.Date)} ̂߂̃eXgE\bhB
     */
    public void testSetSentDate() {
        Date date = Calendar.getInstance().getTime();
        mail.setSentDate(date);
        assertSame(date, mail.getSentDate());
        assertEquals(date.getTime(), mail.getSentDate().getTime());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#isPopBeforeSmtp()} ̂߂̃eXgE\bhB
     */
    public void testIsPopBeforeSmtp() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setPopBeforeSmtp(boolean)} ̂߂̃eXgE\bhB
     */
    public void testSetPopBeforeSmtp() {
        mail.setPopBeforeSmtp(true);
        assertTrue(mail.isPopBeforeSmtp());
        mail.setPopBeforeSmtp(false);
        assertFalse(mail.isPopBeforeSmtp());
        mail.setPopBeforeSmtp(true);
        assertTrue(mail.isPopBeforeSmtp());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#getPopHostName()} ̂߂̃eXgE\bhB
     */
    public void testGetPopHostName() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setPopHostName(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSetPopHostName() {
        mail.setPopHostName("pop.localhost");
        assertEquals("pop.localhost", mail.getPopHostName());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#getPopUserName()} ̂߂̃eXgE\bhB
     */
    public void testGetPopUserName() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setPopUserName(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSetPopUserName() {
        mail.setPopUserName("popuser");
        assertEquals("popuser", mail.getPopUserName());
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#getPopPassword()} ̂߂̃eXgE\bhB
     */
    public void testGetPopPassword() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.fw.util.mail.HSendMail#setPopPassword(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSetPopPassword() {
        mail.setPopPassword("poppassword");
        assertEquals("poppassword", mail.getPopPassword());
    }

}
