package jp.hrtdotnet.java;

import java.util.ResourceBundle;

import jp.hrtdotnet.java.util.BooleanUtil;
import jp.hrtdotnet.java.util.IntegerUtil;

public class TestResources {

    private static TestResources resource = null;
    
    public static TestResources getInstance(String cls) {
        if (resource == null) {
            resource = new TestResources(cls, "jp.hrtdotnet.java.test");
        }
        return resource;
    }
    
    public static TestResources getInstance(Class cls) {
        return getInstance(cls.getName());
    }

    protected ResourceBundle bundle = null;
    protected String cls = null;

    protected TestResources(String cls, String baseName) {
        this.bundle = ResourceBundle.getBundle(baseName);
        this.cls = cls;
    }
    
    
    public String getString(String key) {
        return bundle.getString(key);
    }

    public boolean isTestMethod(String method) {
        return BooleanUtil.toBoolean(bundle.getString("test." + method), false);
    }

    public boolean isTestMethod(String method, String point) {
        return BooleanUtil.toBoolean(bundle.getString("test." + method + "." + point), false);
    }
    
    public int getInt(String key) {
        return IntegerUtil.toInt(bundle.getString(key));
    }
    
    public boolean getBoolean(String key) {
        return BooleanUtil.toBoolean(bundle.getString(key));
    }
}
