/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.environments.remote;

import com.sun.star.lib.uno.environments.remote.IThreadPool;
import com.sun.star.lib.uno.environments.remote.JavaThreadPoolFactory;
import com.sun.star.lib.uno.environments.remote.Job;
import com.sun.star.lib.uno.environments.remote.JobQueue;
import com.sun.star.lib.uno.environments.remote.ThreadId;

public class JavaThreadPool
implements IThreadPool {
    private static final boolean DEBUG = false;
    JavaThreadPoolFactory _javaThreadPoolFactory;

    JavaThreadPool(JavaThreadPoolFactory javaThreadPoolFactory) {
        this._javaThreadPoolFactory = javaThreadPoolFactory;
    }

    public ThreadId getThreadId() {
        return JavaThreadPoolFactory.getThreadId();
    }

    public Object attach(ThreadId threadId) {
        JobQueue jobQueue = this._javaThreadPoolFactory.getJobQueue(threadId);
        if (jobQueue == null) {
            jobQueue = new JobQueue(this._javaThreadPoolFactory, threadId, false);
        }
        jobQueue.acquire();
        return jobQueue;
    }

    public void attach() {
        this.attach(this.getThreadId());
    }

    public void detach(Object object, ThreadId threadId) {
        ((JobQueue)object).release();
    }

    public void detach() {
        ThreadId threadId = this.getThreadId();
        this.detach(this._javaThreadPoolFactory.getJobQueue(threadId), threadId);
    }

    public Object enter() throws Throwable {
        ThreadId threadId = this.getThreadId();
        return this.enter(this._javaThreadPoolFactory.getJobQueue(threadId), threadId);
    }

    public Object enter(Object object, ThreadId threadId) throws Throwable {
        return ((JobQueue)object).enter(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void putJob(Job job) {
        if (job.isSynchron() || job.getOperation() == null) {
            JobQueue jobQueue = this._javaThreadPoolFactory.getJobQueue(job.getThreadId());
            if (jobQueue == null) {
                jobQueue = new JobQueue(this._javaThreadPoolFactory, job.getThreadId(), true);
            }
            jobQueue.putJob(job, this);
            return;
        }
        JavaThreadPoolFactory javaThreadPoolFactory = this._javaThreadPoolFactory;
        synchronized (javaThreadPoolFactory) {
            JobQueue jobQueue;
            try {
                jobQueue = this._javaThreadPoolFactory.getAsyncJobQueue(job.getThreadId());
                if (jobQueue == null) {
                    jobQueue = new JobQueue(this._javaThreadPoolFactory, job.getThreadId());
                }
                jobQueue.putJob(job, this);
                return;
            }
            finally {
                jobQueue = null;
            }
        }
    }

    public void dispose(Throwable throwable) {
        this._javaThreadPoolFactory.dispose(this, throwable);
    }

    public void destroy() {
    }
}

