/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility;

import com.sun.star.accessibility.XAccessible;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import org.openoffice.java.accessibility.AccessibleObjectFactory;

public class PopupWindow
extends Window {
    AccessibleContext accessibleContext;
    ContainerProxy layeredPane;
    ContainerProxy rootPane;
    ContainerProxy popupLayer;
    boolean opened;
    boolean visible;

    private /* synthetic */ void finit$() {
        this.accessibleContext = null;
        this.layeredPane = new ContainerProxy(this, AccessibleRole.LAYERED_PANE);
        this.rootPane = new ContainerProxy(this, AccessibleRole.ROOT_PANE);
        this.popupLayer = new ContainerProxy(this, AccessibleRole.PANEL);
        this.opened = false;
        this.visible = false;
    }

    public PopupWindow(Window window) {
        super(window);
        this.finit$();
        super.add(this.rootPane);
        this.rootPane.add(this.layeredPane);
        AccessibleContext accessibleContext = this.rootPane.getAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.setAccessibleParent(this);
        }
    }

    static PopupWindow create(XAccessible xAccessible) {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (window != null) {
            PopupWindow popupWindow = new PopupWindow(window);
            popupWindow.setVisible(true);
            AccessibleObjectFactory.invokeAndWait();
            AccessibleObjectFactory.addChild((Container)popupWindow, xAccessible);
            return popupWindow;
        }
        return null;
    }

    public boolean isShowing() {
        if (this.isVisible()) {
            Container container = this.getParent();
            return container == null || container.isShowing();
        }
        return false;
    }

    public void addNotify() {
    }

    public void removeNotify() {
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        if (this.visible != bl) {
            this.visible = bl;
            if (bl && !this.opened) {
                AccessibleObjectFactory.postWindowOpened(this);
                this.opened = true;
            }
        }
    }

    public Component add(Component component) {
        AccessibleContext accessibleContext;
        this.popupLayer.add(component);
        this.layeredPane.add(this.popupLayer);
        if (component instanceof Accessible && (accessibleContext = this.layeredPane.getAccessibleContext()) != null) {
            accessibleContext.firePropertyChange("AccessibleChild", null, this.popupLayer.getAccessibleContext());
        }
        return component;
    }

    public void remove(Component component) {
        AccessibleContext accessibleContext;
        this.layeredPane.remove(this.popupLayer);
        if (component instanceof Accessible && (accessibleContext = this.layeredPane.getAccessibleContext()) != null) {
            accessibleContext.firePropertyChange("AccessibleChild", this.popupLayer.getAccessibleContext(), null);
        }
        this.popupLayer.remove(component);
    }

    public void dispose() {
        this.setVisible(false);
        AccessibleObjectFactory.postWindowClosed(this);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessiblePopupWindow(this);
        }
        return this.accessibleContext;
    }

    protected class ContainerProxy
    extends Container
    implements Accessible {
        private /* synthetic */ PopupWindow this$0;
        AccessibleContext accessibleContext;
        AccessibleRole role;

        private /* synthetic */ void finit$() {
            this.accessibleContext = null;
        }

        static PopupWindow access$0(ContainerProxy containerProxy) {
            return containerProxy.this$0;
        }

        protected ContainerProxy(PopupWindow popupWindow, AccessibleRole accessibleRole) {
            this.this$0 = popupWindow;
            this.finit$();
            this.role = accessibleRole;
        }

        public Component add(Component component) {
            Accessible accessible;
            AccessibleContext accessibleContext;
            if (component instanceof Accessible && (accessibleContext = (accessible = (Accessible)((Object)component)).getAccessibleContext()) != null) {
                accessibleContext.setAccessibleParent(this);
            }
            return super.add(component);
        }

        public void remove(Component component) {
            Accessible accessible;
            AccessibleContext accessibleContext;
            if (component instanceof Accessible && (accessibleContext = (accessible = (Accessible)((Object)component)).getAccessibleContext()) != null) {
                accessibleContext.setAccessibleParent(null);
            }
            super.remove(component);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleContainerProxy(this);
            }
            return this.accessibleContext;
        }

        private class AccessibleContainerProxy
        extends Container.AccessibleAWTContainer {
            private /* synthetic */ ContainerProxy this$1;

            AccessibleContainerProxy(ContainerProxy containerProxy) {
                this.this$1 = containerProxy;
                super(ContainerProxy.access$0(containerProxy));
            }

            public AccessibleRole getAccessibleRole() {
                return this.this$1.role;
            }
        }
    }

    protected class AccessiblePopupWindow
    extends Window.AccessibleAWTWindow {
        private /* synthetic */ PopupWindow this$0;

        AccessiblePopupWindow(PopupWindow popupWindow) {
            this.this$0 = popupWindow;
            super(popupWindow);
        }
    }
}

