/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.gnu.charset;

import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.util.HashMap;
import java.util.Iterator;
import jp.sourceforge.jeextension.gnu.charset.IconvCharsetWrapper;

public class JaJPCharsetProvider
extends CharsetProvider {
    private final HashMap charsets = new HashMap();
    private final HashMap canonicalNames = new HashMap();

    public JaJPCharsetProvider() {
        this.addCharset(new IconvCharsetWrapper("EUC-JP", new String[]{"euc_jp", "eucjis", "eucjp", "Extended_UNIX_Code_Packed_Format_for_Japanese", "csEUCPkdFmtjapanese", "x-euc-jp", "x-eucjp"}));
        this.addCharset(new IconvCharsetWrapper("Windows-31J", new String[]{"MS932", "windows-932", "csWindows31J"}));
        this.addCharset(new IconvCharsetWrapper("Shift_JIS", new String[]{"sjis", "pck", "shift_jis", "shift-jis", "ms_kanji", "x-sjis", "csShiftJIS"}));
    }

    private void addCharset(Charset charset) {
        String string = charset.name().toLowerCase();
        this.charsets.put(string, charset);
        this.canonicalNames.put(string, string);
        Iterator<String> iterator = charset.aliases().iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            this.canonicalNames.put(string2.toLowerCase(), string);
        }
    }

    public Charset charsetForName(String string) {
        Object v = this.canonicalNames.get(string.toLowerCase());
        return (Charset)this.charsets.get(v);
    }

    public Iterator charsets() {
        return this.charsets.values().iterator();
    }
}

