/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.collection.calc;

import java.util.Iterator;
import java.util.List;
import org.asyrinx.brownie.core.collection.calc.Selection;
import org.asyrinx.brownie.core.lang.ArrayUtils;
import org.asyrinx.brownie.core.lang.NumberUtils;

public interface Calculation {
    public static final Calculation SUMMARY = new AbstractCalculation(){

        public Number calculate(List list) {
            double result = 0.0;
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Number number = NumberUtils.toNumber(iter.next());
                result += number.doubleValue();
            }
            return NumberUtils.toMinimunNumberObject(result);
        }
    };
    public static final Calculation COUNT = new AbstractCalculation(){

        public Number calculate(List list) {
            return new Integer(list.size());
        }

        public Number calculate(Number[] values) {
            return new Integer(values.length);
        }
    };
    public static final Calculation AVERAGE = new AbstractCalculation(){

        public Number calculate(List list) {
            return null;
        }

        public Number calculate(Number[] values) {
            double sum = SUMMARY.calculate(values).doubleValue();
            int count = COUNT.calculate(values).intValue();
            if (count == 0) {
                return new Double(0.0);
            }
            return NumberUtils.toMinimunNumberObject(sum / (double)count);
        }
    };
    public static final Calculation MIN = new Selection(){

        protected double select(double val1, double val2) {
            return val1 < val2 ? val1 : val2;
        }
    };
    public static final Calculation MAX = new Selection(){

        protected double select(double val1, double val2) {
            return val1 > val2 ? val1 : val2;
        }
    };

    public Number calculate(Number[] var1);

    public Number calculate(List var1);

    public static abstract class AbstractCalculation
    implements Calculation {
        public Number calculate(Number[] values) {
            return this.calculate(ArrayUtils.toArrayList(values));
        }
    }
}

