/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.asyrinx.brownie.core.io.FileNameUtils;
import org.asyrinx.brownie.core.lang.StringUtils;

public class PathPointer {
    private final List dirList = new ArrayList();
    private String separator = "/";

    public PathPointer() {
    }

    public PathPointer(String path) {
        this.setPath(path);
    }

    public PathPointer(File file) {
        this(file.getPath());
    }

    public String getPath() {
        return StringUtils.join(this.dirList.iterator(), (String)this.separator);
    }

    public void setPath(String path) {
        this.dirList.clear();
        path = FileNameUtils.deleteSeparatorTail(path);
        this.separator = FileNameUtils.getFileSeparator(path);
        StringUtils.tokenize(this.dirList, path, this.separator);
    }

    public File toFile() {
        return new File(this.getPath());
    }

    public void moveTo(String relativePath) {
        this.changeImpl(relativePath);
    }

    public void goUp() {
        this.changeImpl("..");
    }

    public void goDown(String directoryName) {
        this.changeImpl(directoryName);
    }

    protected void changeImpl(String relativePath) {
        String path = FileNameUtils.toFileSeparatorSlash(FileNameUtils.deleteSeparatorHead(relativePath));
        List pathList = StringUtils.tokenize(path, "/");
        Iterator iterator = pathList.iterator();
        while (iterator.hasNext()) {
            String dir = (String)iterator.next();
            if (dir.equals(".")) continue;
            if (dir.equals("..")) {
                this.dirList.remove(this.dirList.size() - 1);
                continue;
            }
            this.dirList.add(dir);
        }
    }
}

