/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.io.sf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.asyrinx.brownie.core.io.FileNameUtils;
import org.asyrinx.brownie.core.io.sf.AbstractFileStreamFactory;

public class DirectoryBaseFileStreamFactory
extends AbstractFileStreamFactory {
    private final String baseDirectory;

    public DirectoryBaseFileStreamFactory(String baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    protected String keyStringToString(String key) {
        key = FileNameUtils.replaceSeparatorSlash(key);
        return FileNameUtils.toAbsolutePath(this.baseDirectory, key);
    }

    public InputStream newInput(Object key) throws IOException {
        if (key instanceof File) {
            return new FileInputStream((File)key);
        }
        return new FileInputStream(this.keyToString(key));
    }

    public OutputStream newOutput(Object key) throws IOException {
        if (key instanceof File) {
            return new FileOutputStream((File)key);
        }
        return new FileOutputStream(this.keyToString(key));
    }

    public String getCaption() {
        return this.baseDirectory;
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }
}

