/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.io.sf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.asyrinx.brownie.core.io.sf.AbstractFileStreamFactory;

public class ZipEntryFileStreamFactory
extends AbstractFileStreamFactory {
    private final File zipFile;
    private ZipFile targetZip = null;

    public ZipEntryFileStreamFactory(String zipFilePath) {
        this(new File(zipFilePath));
    }

    public ZipEntryFileStreamFactory(File zipFile) {
        this.zipFile = zipFile;
    }

    protected void initZipFile() throws IOException {
        if (this.targetZip != null) {
            return;
        }
        this.targetZip = new ZipFile(this.zipFile);
    }

    public InputStream newInput(Object key) throws IOException {
        this.initZipFile();
        String path = this.keyToString(key);
        ZipEntry entry = new ZipEntry(path);
        InputStream result = this.targetZip.getInputStream(entry);
        if (result == null) {
            throw new IOException("\u30b9\u30c8\u30ea\u30fc\u30e0[" + key + "]\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        }
        return result;
    }

    public OutputStream newOutput(Object key) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected String keyFileToString(File key) {
        return key.getPath();
    }

    public String getCaption() {
        return this.zipFile.getAbsolutePath();
    }
}

