/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.lang.enum;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.enum.Enum;
import org.apache.commons.lang.enum.EnumUtils;
import org.asyrinx.brownie.core.lang.enum.EnumSetEntry;
import org.asyrinx.brownie.core.lang.enum.ValuedEnum;

public class EnumSet {
    protected final Class enumClass;
    protected final List entries;

    public EnumSet(Class enumClass) {
        this.enumClass = enumClass;
        this.entries = this.createEntries();
    }

    protected List createEntries() {
        List enums = EnumUtils.getEnumList((Class)this.enumClass);
        ArrayList<EnumSetEntry> result = new ArrayList<EnumSetEntry>(enums.size());
        Iterator iterator = enums.iterator();
        while (iterator.hasNext()) {
            ValuedEnum valuedEnum = (ValuedEnum)((Object)iterator.next());
            result.add(this.toEntry(valuedEnum));
        }
        return Collections.unmodifiableList(result);
    }

    protected EnumSetEntry toEntry(Enum enum_) {
        return new EnumSetEntry(enum_);
    }

    public Set getSelectedEnums() {
        return this.toEnumSet(new SelectedPredicate(true));
    }

    public Set getUnselectedEnums() {
        return this.toEnumSet(new SelectedPredicate(false));
    }

    protected final Set toEnumSet(Predicate predicate) {
        HashSet<Enum> result = new HashSet<Enum>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            EnumSetEntry entry = (EnumSetEntry)iterator.next();
            if (!predicate.evaluate((Object)entry)) continue;
            result.add(entry.getEnum());
        }
        return result;
    }

    protected final EnumSetEntry findEntry(Predicate predicate) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            EnumSetEntry entry = (EnumSetEntry)iterator.next();
            if (!predicate.evaluate((Object)entry)) continue;
            return entry;
        }
        return null;
    }

    public EnumSetEntry getEntryByName(final String enumName) {
        return this.findEntry(new Predicate(){

            public boolean evaluate(Object input) {
                EnumSetEntry entry = (EnumSetEntry)input;
                return enumName.equals(entry.getName());
            }
        });
    }

    public EnumSetEntry getEntry(final Enum enum_) {
        return this.findEntry(new Predicate(){

            public boolean evaluate(Object input) {
                EnumSetEntry entry = (EnumSetEntry)input;
                return enum_ == entry.getEnum();
            }
        });
    }

    public int size() {
        return this.entries.size();
    }

    public Iterator iterator() {
        return this.entries.iterator();
    }

    protected static class SelectedPredicate
    implements Predicate {
        final boolean selected;

        public SelectedPredicate(boolean selected) {
            this.selected = selected;
        }

        public boolean evaluate(Object input) {
            EnumSetEntry entry = (EnumSetEntry)input;
            return entry.isSelected() == this.selected;
        }
    }
}

