/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.query.exp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.core.query.exp.FieldCompare;
import org.asyrinx.brownie.core.query.exp.FieldExpression;
import org.asyrinx.brownie.core.query.exp.ICompositeExpression;
import org.asyrinx.brownie.core.query.exp.IExpression;
import org.asyrinx.brownie.core.query.exp.ObjectExpression;
import org.asyrinx.brownie.core.query.model.FieldAlias;

public class CompositeExpression
implements ICompositeExpression {
    private String operator;
    protected final List children = new ArrayList();

    public CompositeExpression() {
    }

    public CompositeExpression(String operator) {
        this.operator = operator;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public CompositeExpression add(IExpression expression) {
        this.children.add(expression);
        return this;
    }

    public CompositeExpression addField(String fieldName, Object value) {
        ObjectExpression result = new ObjectExpression(fieldName, "=", value);
        return this.add(result);
    }

    public IExpression addField(String fieldName, String operator, Object value) {
        ObjectExpression result = new ObjectExpression(fieldName, operator, value);
        return this.add(result);
    }

    public IExpression addField(FieldAlias field, Object value) {
        return this.addField(field, "=", value);
    }

    public IExpression addField(FieldAlias field, String operator, Object value) {
        FieldAlias alias = field;
        return this.add(new FieldExpression(alias, operator, value));
    }

    public IExpression addCompare(FieldAlias left, FieldAlias right) {
        return this.addCompare(left, right, "=");
    }

    public IExpression addCompare(FieldAlias left, FieldAlias right, String operator) {
        FieldAlias leftAlias = left;
        FieldAlias rightAlias = right;
        return this.add(new FieldCompare(leftAlias, rightAlias, operator));
    }

    public CompositeExpression addCompo(String operator) {
        CompositeExpression result = new CompositeExpression(operator);
        this.add(result);
        return result;
    }

    public void clear() {
        this.children.clear();
    }

    public boolean contains(IExpression o) {
        return this.children.contains(o);
    }

    public IExpression get(int index) {
        return (IExpression)this.children.get(index);
    }

    public int indexOf(IExpression o) {
        return this.children.indexOf(o);
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public Iterator iterator() {
        return this.children.iterator();
    }

    public boolean remove(IExpression o) {
        return this.children.remove(o);
    }

    public int size() {
        return this.children.size();
    }

    public IExpression[] toArray() {
        return (IExpression[])this.children.toArray();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ICompositeExpression)) {
            return false;
        }
        ICompositeExpression other = (ICompositeExpression)obj;
        new EqualsBuilder().append((Object)this.getOperator(), (Object)other.getOperator()).append((Object[])this.toArray(), (Object[])other.toArray()).isEquals();
        return super.equals(obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getOperator()).append((Object[])this.toArray()).toHashCode();
    }

    public String toString() {
        return "(" + StringUtils.join((Iterator)this.iterator(), (String)(")" + this.getOperator() + "(")) + ")";
    }
}

