/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.util;

import java.util.Comparator;
import org.asyrinx.brownie.core.util.NumberComparator;

public class ArrayComparator
implements Comparator {
    private final Comparator comparator;

    public ArrayComparator() {
        this(new NumberComparator());
    }

    public ArrayComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public int compare(Object o1, Object o2) {
        if (!o1.getClass().isArray() || !o2.getClass().isArray()) {
            throw new IllegalArgumentException("object must be array");
        }
        Object[] array1 = (Object[])o1;
        Object[] array2 = (Object[])o2;
        int i = 0;
        while (i < array1.length) {
            if (i >= array2.length) {
                return 1;
            }
            int r = this.comparator.compare(array1[i], array2[i]);
            if (r != 0) {
                return r;
            }
            ++i;
        }
        if (array1.length < array2.length) {
            return -1;
        }
        return 0;
    }
}

