/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.util;

import java.util.Date;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.asyrinx.brownie.core.util.DateUtils;

public class DateRange {
    private final Date from;
    private final Date to;

    public DateRange(Date from, Date to) {
        this.from = from != null ? from : DateUtils.getInfinitePast();
        this.to = to != null ? to : DateUtils.getInfiniteFuture();
    }

    public Date getFrom() {
        return this.from;
    }

    public Date getTo() {
        return this.to;
    }

    public boolean includesDate(Date date) {
        if (date == null) {
            return false;
        }
        return date.after(this.getFrom()) && date.before(this.getTo());
    }

    public boolean includesRange(DateRange range) {
        if (range == null) {
            return false;
        }
        return this.includesDate(range.getFrom()) && this.includesDate(range.getTo());
    }

    public boolean overlaps(DateRange range) {
        if (range == null) {
            return false;
        }
        return range.includesDate(this.getFrom()) || range.includesDate(this.getTo()) || this.includesRange(range);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DateRange)) {
            return false;
        }
        DateRange range = (DateRange)obj;
        return new EqualsBuilder().append((Object)this.getFrom(), (Object)range.getFrom()).append((Object)this.getTo(), (Object)range.getTo()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getFrom()).append((Object)this.getTo()).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.getFrom()).append((Object)this.getTo()).toString();
    }
}

