/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.util;

import java.util.Calendar;
import java.util.Date;
import org.asyrinx.brownie.core.util.DateUtils;

public final class SimpleDate {
    private final int year;
    private final int month;
    private final int day;

    public SimpleDate(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public SimpleDate(Date d) {
        this(d, Calendar.getInstance());
    }

    public SimpleDate(Date d, Calendar calendar) {
        calendar.setTime(d);
        this.year = calendar.get(1);
        this.month = calendar.get(2) + 1;
        this.day = calendar.get(5);
    }

    public Date toDate() {
        return this.toDateBegin();
    }

    public Date toDateBegin() {
        return DateUtils.toDate(this.year, this.month, this.day, 0, 0, 0, 0);
    }

    public Date toDateEnd() {
        return DateUtils.toDate(this.year, this.month, this.day, 23, 59, 59, 999);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SimpleDate) {
            SimpleDate date = (SimpleDate)obj;
            return this.year == date.year && this.month == date.month && this.day == date.day;
        }
        if (obj instanceof Date) {
            return this.equals(new SimpleDate((Date)obj));
        }
        return super.equals(obj);
    }

    public boolean after(SimpleDate when) {
        if (when.year < this.year) {
            return true;
        }
        if (when.year > this.year) {
            return false;
        }
        if (when.month < this.month) {
            return true;
        }
        if (when.month > this.month) {
            return false;
        }
        return when.day < this.day;
    }

    public boolean before(SimpleDate when) {
        if (when.year > this.year) {
            return true;
        }
        if (when.year < this.year) {
            return false;
        }
        if (when.month > this.month) {
            return true;
        }
        if (when.month < this.month) {
            return false;
        }
        return when.day > this.day;
    }

    public int getDayGap(SimpleDate when) {
        int result = 0;
        if (when.getYear() > this.getYear()) {
            result = this.getDayGap(new SimpleDate(this.getYear(), 12, 31));
            ++result;
            int y = this.getYear() + 1;
            while (y < when.getYear()) {
                result += DateUtils.isLeapYear(y) ? 366 : 365;
                ++y;
            }
            return result += new SimpleDate(when.getYear(), 1, 1).getDayGap(when);
        }
        if (when.getYear() < this.getYear()) {
            result = this.getDayGap(new SimpleDate(this.getYear(), 1, 1));
            int y = this.getYear() - 1;
            while (y > when.getYear()) {
                result -= DateUtils.isLeapYear(y) ? 366 : 365;
                --y;
            }
            --result;
            return result += new SimpleDate(when.getYear(), 12, 31).getDayGap(when);
        }
        if (when.getMonth() > this.getMonth()) {
            result += DateUtils.getLastDayOfMonth(this.getYear(), this.getMonth()) - this.getDay();
            ++result;
            int m = this.getMonth() + 1;
            while (m < when.getMonth()) {
                result += DateUtils.getLastDayOfMonth(this.getYear(), m);
                ++m;
            }
            return result += when.getDay() - 1;
        }
        if (when.month < this.month) {
            result -= this.getDay();
            int m = this.getMonth() - 1;
            while (m > when.getMonth()) {
                result -= DateUtils.getLastDayOfMonth(this.getYear(), m);
                --m;
            }
            return result -= DateUtils.getLastDayOfMonth(when.getYear(), when.getMonth()) - when.getDay();
        }
        return when.day - this.day;
    }

    public int getMonthGap(SimpleDate when) {
        int result = 0;
        if (when.getYear() > this.getYear()) {
            result = 12 - this.getMonth();
            int y = this.getYear() + 1;
            while (y < when.getYear()) {
                result += 12;
                ++y;
            }
            return result += when.getMonth();
        }
        if (when.getYear() < this.getYear()) {
            result -= this.getMonth();
            int y = this.getYear() + 1;
            while (y < when.getYear()) {
                result -= 12;
                ++y;
            }
            return result -= 12 - when.getMonth();
        }
        return when.getMonth() - this.getMonth();
    }

    public int getYearGap(SimpleDate when) {
        return when.getYear() - this.getYear();
    }

    public int getDayOfWeek() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.toDate());
        return calendar.get(7);
    }

    public String toString() {
        return String.valueOf(this.year) + "/" + this.month + "/" + this.day;
    }

    public int getDay() {
        return this.day;
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public SimpleDate prev(int length, int unit) {
        return this.next(-length, unit);
    }

    public SimpleDate next(int length, int unit) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.toDate());
        calendar.add(unit, length);
        return new SimpleDate(calendar.getTime());
    }
}

