/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.util;

import java.util.Date;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.asyrinx.brownie.core.util.DateRange;
import org.asyrinx.brownie.core.util.SimpleDate;

public class SimpleDateRange {
    private final SimpleDate from;
    private final SimpleDate to;

    public SimpleDateRange(SimpleDate from, SimpleDate to) {
        this.from = from;
        this.to = to;
    }

    public SimpleDateRange(DateRange dateRange) {
        this(SimpleDateRange.toSimpleDate(dateRange.getFrom()), SimpleDateRange.toSimpleDate(dateRange.getTo()));
    }

    public SimpleDateRange(int fromYear, int fromMonth, int fromDay, int toYear, int toMonth, int toDay) {
        this(SimpleDateRange.toSimpleDate(fromYear, fromMonth, fromDay), SimpleDateRange.toSimpleDate(toYear, toMonth, toDay));
    }

    private static SimpleDate toSimpleDate(int y, int m, int d) {
        if (d < 1) {
            return null;
        }
        return new SimpleDate(y, m, d);
    }

    public static SimpleDate toSimpleDate(Date d) {
        if (d != null) {
            return new SimpleDate(d);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SimpleDateRange) {
            SimpleDateRange range = (SimpleDateRange)obj;
            return ObjectUtils.equals((Object)this.from, (Object)range.from) && ObjectUtils.equals((Object)this.to, (Object)range.to);
        }
        return super.equals(obj);
    }

    public boolean include(SimpleDate when) {
        if (this.from == null && this.to == null) {
            return true;
        }
        if (this.from != null && this.to == null) {
            return this.from.before(when) || this.from.equals(when);
        }
        if (this.from == null && this.to != null) {
            return this.to.after(when) || this.to.equals(when);
        }
        return !(!this.from.before(when) && !this.from.equals(when) || !this.to.after(when) && !this.to.equals(when));
    }

    public String toString() {
        return String.valueOf(StringUtils.defaultString((String)this.from.toString())) + "-" + StringUtils.defaultString((String)this.to.toString());
    }

    public SimpleDate getFrom() {
        return this.from;
    }

    public SimpleDate getTo() {
        return this.to;
    }

    public int getFromDay() {
        return this.from == null ? 0 : this.from.getDay();
    }

    public int getFromMonth() {
        return this.from == null ? 0 : this.from.getMonth();
    }

    public int getFromYear() {
        return this.from == null ? 0 : this.from.getYear();
    }

    public int getToDay() {
        return this.to == null ? 0 : this.to.getDay();
    }

    public int getToMonth() {
        return this.to == null ? 0 : this.to.getMonth();
    }

    public int getToYear() {
        return this.to == null ? 0 : this.to.getYear();
    }
}

