/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.jdbc.logger;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.jdbc.logger.LogConnection;
import org.asyrinx.brownie.jdbc.logger.LogXAResource;
import org.asyrinx.brownie.jdbc.wrapper.XAConnectionWrapper;

public class LogXAConnection
extends XAConnectionWrapper {
    protected final CascadeNamedLog log;

    public LogXAConnection(XAConnection wrapped) {
        this(wrapped, new CascadeNamedLog(wrapped.getClass(), "debug"));
    }

    public LogXAConnection(XAConnection wrapped, CascadeNamedLog log) {
        super(wrapped);
        this.log = log;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        super.addConnectionEventListener(listener);
        this.log.log("addConnectionEventListener(" + listener + ")");
    }

    public void close() throws SQLException {
        try {
            super.close();
            this.log.log("close()");
        }
        catch (SQLException e) {
            this.log.error("failed to close() ", e);
            throw e;
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            Connection result = super.getConnection();
            this.log.log("getConnection(): " + result);
            return new LogConnection(result, this.log.subLog(result));
        }
        catch (SQLException e) {
            this.log.error("failed to getConnection(): ", e);
            throw e;
        }
    }

    public XAResource getXAResource() throws SQLException {
        try {
            XAResource result = super.getXAResource();
            this.log.log("getXAResource(): " + result);
            return new LogXAResource(result, this.log.subLog(result));
        }
        catch (SQLException e) {
            this.log.error("failed to getXAResource(): ", e);
            throw e;
        }
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        super.removeConnectionEventListener(listener);
        this.log.log("removeConnectionEventListener(" + listener + ")");
    }
}

