/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.jdbc.measure;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.asyrinx.brownie.core.log.MeasureLog;
import org.asyrinx.brownie.core.log.MeasureLogImpl;
import org.asyrinx.brownie.core.util.Wrapper;

public class StatementMeasure
extends Wrapper
implements Statement {
    protected final MeasureLog measureLog;
    private final Statement source;
    protected static final String PREFIX = "[measure]";

    public StatementMeasure(Statement source, MeasureLog measureLog) {
        super(source);
        this.source = source;
        if (measureLog == null) {
            measureLog = new MeasureLogImpl("sql");
        }
        this.measureLog = measureLog;
    }

    public StatementMeasure(Statement source) {
        this(source, null);
    }

    public static String format(String name, long t) {
        return "[measure] " + name + " -- " + String.valueOf(t);
    }

    public boolean execute(String sql) throws SQLException {
        this.measureLog.reset();
        boolean result = this.source.execute(sql);
        this.measureLog.done(sql);
        return result;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.measureLog.reset();
        ResultSet result = this.source.executeQuery(sql);
        this.measureLog.done(sql);
        return result;
    }

    public int executeUpdate(String sql) throws SQLException {
        this.measureLog.reset();
        int result = this.source.executeUpdate(sql);
        this.measureLog.done(sql);
        return result;
    }

    public void addBatch(String sql) throws SQLException {
        this.source.addBatch(sql);
    }

    public void clearBatch() throws SQLException {
        this.source.clearBatch();
    }

    public int[] executeBatch() throws SQLException {
        this.measureLog.reset();
        int[] result = this.source.executeBatch();
        this.measureLog.done("batch");
        return result;
    }

    public void close() throws SQLException {
        this.source.close();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.source.getMaxFieldSize();
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.source.setMaxFieldSize(max);
    }

    public int getMaxRows() throws SQLException {
        return this.source.getMaxRows();
    }

    public void setMaxRows(int max) throws SQLException {
        this.source.setMaxRows(max);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.source.setEscapeProcessing(enable);
    }

    public int getQueryTimeout() throws SQLException {
        return this.source.getQueryTimeout();
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.source.setQueryTimeout(seconds);
    }

    public void cancel() throws SQLException {
        this.source.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.source.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.source.clearWarnings();
    }

    public void setCursorName(String name) throws SQLException {
        this.source.setCursorName(name);
    }

    public ResultSet getResultSet() throws SQLException {
        return this.source.getResultSet();
    }

    public int getUpdateCount() throws SQLException {
        return this.source.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        return this.source.getMoreResults();
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.source.setFetchDirection(direction);
    }

    public int getFetchDirection() throws SQLException {
        return this.source.getFetchDirection();
    }

    public void setFetchSize(int rows) throws SQLException {
        this.source.setFetchSize(rows);
    }

    public int getFetchSize() throws SQLException {
        return this.source.getFetchSize();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.source.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        return this.source.getResultSetType();
    }

    public Connection getConnection() throws SQLException {
        return this.source.getConnection();
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.source.execute(sql, autoGeneratedKeys);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.source.execute(sql, columnIndexes);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.source.execute(sql, columnNames);
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.source.executeUpdate(sql, autoGeneratedKeys);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.source.executeUpdate(sql, columnIndexes);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.source.executeUpdate(sql, columnNames);
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.source.getGeneratedKeys();
    }

    public boolean getMoreResults(int current) throws SQLException {
        return this.source.getMoreResults(current);
    }

    public int getResultSetHoldability() throws SQLException {
        return this.source.getResultSetHoldability();
    }
}

