/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.jdbc.util;

import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.asyrinx.brownie.core.io.sf.ClassResourceStreamFactory;
import org.asyrinx.brownie.core.io.sf.StringLoader;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.jdbc.util.JdbcDriverType;
import org.asyrinx.brownie.jdbc.util.JdbcServerService;

public class JdbcServerServiceImpl
implements JdbcServerService {
    private Connection connection = null;
    private JdbcDriverType jdbcDriver = null;
    private static final String PATH_SQL = JdbcServerServiceImpl.getPathSql();
    private StringLoader loader = null;
    static /* synthetic */ Class class$0;

    public JdbcServerServiceImpl() {
    }

    public JdbcServerServiceImpl(Connection connection) {
        this.setConnection(connection);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
        if (this.connection == null) {
            this.jdbcDriver = null;
        }
    }

    private void initDriver() throws SQLException {
        if (this.getConnection() == null) {
            throw new SQLException("connection not found.");
        }
        if (this.jdbcDriver == null) {
            this.jdbcDriver = JdbcDriverType.get(this.connection);
        }
    }

    public Date getCurrentDate() throws SQLException {
        ResultSet rs = this.executeNoParamSql("currentDate.sql");
        if (rs.next()) {
            return rs.getDate(1);
        }
        throw new SQLException("failed to retrieve current date.");
    }

    public Time getCurrentTime() throws SQLException {
        ResultSet rs = this.executeNoParamSql("currentTime.sql");
        if (rs.next()) {
            return rs.getTime(1);
        }
        throw new SQLException("failed to retrieve current time.");
    }

    public Timestamp getCurrentTimestamp() throws SQLException {
        ResultSet rs = this.executeNoParamSql("currentTimestamp.sql");
        if (rs.next()) {
            return rs.getTimestamp(1);
        }
        throw new SQLException("failed to retrieve current timestamp.");
    }

    protected final ResultSet executeNoParamSql(String filename) throws SQLException {
        String sql;
        this.initDriver();
        try {
            sql = this.getSql(filename);
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
        PreparedStatement st = this.getConnection().prepareStatement(sql);
        return st.executeQuery();
    }

    private static String getPathSql() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.asyrinx.brownie.jdbc.util.JdbcServerServiceImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return StringUtils.replace((String)(String.valueOf(clazz.getPackage().getName()) + ".sql"), (String)".", (String)"/");
    }

    public String getSql(String filename) throws IOException {
        if (this.loader == null) {
            this.loader = new StringLoader(new ClassResourceStreamFactory());
        }
        return this.loader.load(String.valueOf(PATH_SQL) + "/" + this.jdbcDriver.getInnerName() + "/" + filename);
    }
}

