/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.net.socket;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.asyrinx.brownie.net.socket.SocketClient;
import org.asyrinx.brownie.net.socket.SocketServerListener;

public class SocketServer
implements Runnable {
    public static final String DEFAULT_TERMINATE_MESSAGE = "<<terminate>>";
    private final int port;
    private final String terminateMessage;
    private final SocketServerListener listener;
    private final Log log = LogFactory.getLog(this.getClass());
    private boolean runnging = false;
    private ServerSocket serverSocket = null;
    private IOException occurred = null;
    private static SocketServer server = null;

    public SocketServer(SocketServerListener listener, int port) {
        this(listener, port, DEFAULT_TERMINATE_MESSAGE);
    }

    public SocketServer(SocketServerListener listener, int port, String terminateMessage) {
        this.port = port;
        this.listener = listener;
        this.terminateMessage = terminateMessage;
    }

    protected void connect() throws IOException {
        if (this.isConnected()) {
            return;
        }
        this.serverSocket = new ServerSocket(this.port);
        this.log.info((Object)("socket connected port " + this.port));
    }

    protected void disconnect() throws IOException {
        if (!this.isConnected()) {
            return;
        }
        this.log.info((Object)"socket disconnected");
        this.serverSocket.close();
        this.serverSocket = null;
    }

    public void stop() {
        this.runnging = false;
    }

    protected void sendTerminateMessage() {
        SocketClient client = new SocketClient("localhost", this.port);
        try {
            client.execute(this.terminateMessage);
        }
        catch (IOException e) {
            this.log.error((Object)"failed to stop socket.");
        }
    }

    public boolean isConnected() {
        return this.serverSocket != null;
    }

    public IOException getOccurred() {
        return this.occurred;
    }

    public void executeAsThread() {
        Thread thread = new Thread(this);
        thread.run();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            this.connect();
            this.runnging = true;
            try {
                while (this.runnging) {
                    this.receive();
                }
            }
            catch (Throwable throwable) {
                Object var1_3 = null;
                this.disconnect();
                throw throwable;
            }
            {
                Object var1_4 = null;
                this.disconnect();
                return;
            }
        }
        catch (IOException e) {
            this.occurred = e;
            if (!this.isConnected()) return;
            try {
                this.disconnect();
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void receive() throws IOException {
        this.log.info((Object)"socket waiting....");
        Socket socket = this.serverSocket.accept();
        this.log.info((Object)"socket accepted");
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    this.log.info((Object)("socket accepted message: '" + line + "'"));
                    if (line.equals(this.terminateMessage)) {
                        this.runnging = false;
                        this.log.info((Object)"accept terminateMessage");
                        continue;
                    }
                    this.notifyToClient(line);
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                in.close();
                throw throwable;
            }
            {
                Object var4_6 = null;
                in.close();
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            socket.close();
            this.log.info((Object)"socket closed");
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        socket.close();
        this.log.info((Object)"socket closed");
    }

    protected void notifyToClient(String line) {
        SocketServerListener socketServerListener = this.listener;
        synchronized (socketServerListener) {
            this.listener.receipt(line);
        }
    }

    public static void main(String[] args) {
        server = new SocketServer(new SocketServerListener(){
            private int count = 0;

            public void receipt(String line) {
                ++this.count;
                System.out.println(String.valueOf(this.count) + "reciept: " + line);
                SocketServer.received(line, this.count);
            }
        }, 5555);
        server.run();
    }

    protected static void received(String line, int count) {
        if (count >= 5) {
            server.stop();
        }
    }
}

